/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.DimensionAPI;
import qouteall.q_misc_util.forge.events.ServerDimensionsLoadEvent;
import qouteall.q_misc_util.mixin.dimension.IEMappedRegistry;

public class DimensionMisc {
    public static final Set<ResourceLocation> nonPersistentDimensions = new HashSet<ResourceLocation>();
    private static final Logger logger = LogManager.getLogger();

    public static void addMissingVanillaDimensions(WorldGenSettings generatorOptions, RegistryAccess registryManager) {
        LevelStem levelStem;
        WorldGenSettings worldGenSettings;
        WorldPreset worldPreset;
        Registry registry = generatorOptions.m_204655_();
        long seed = generatorOptions.m_64619_();
        if (!registry.m_6566_().contains(LevelStem.f_63972_.m_135782_())) {
            logger.error("Missing the nether. This may be caused by DFU. Trying to fix");
            worldPreset = (WorldPreset)BuiltinRegistries.f_235989_.m_123024_().findFirst().orElseThrow();
            worldGenSettings = worldPreset.m_226427_(generatorOptions);
            levelStem = (LevelStem)worldGenSettings.m_204655_().m_6246_(LevelStem.f_63972_);
            if (levelStem != null) {
                DimensionAPI.addDimension((Registry<LevelStem>)registry, LevelStem.f_63972_.m_135782_(), (Holder<DimensionType>)levelStem.m_204521_(), levelStem.m_63990_());
            } else {
                Helper.err("cannot create default nether");
            }
        }
        if (!registry.m_6566_().contains(LevelStem.f_63973_.m_135782_())) {
            logger.error("Missing the end. This may be caused by DFU. Trying to fix");
            worldPreset = (WorldPreset)BuiltinRegistries.f_235989_.m_123024_().findFirst().orElseThrow();
            worldGenSettings = worldPreset.m_226427_(generatorOptions);
            levelStem = (LevelStem)worldGenSettings.m_204655_().m_6246_(LevelStem.f_63973_);
            if (levelStem != null) {
                DimensionAPI.addDimension((Registry<LevelStem>)registry, LevelStem.f_63973_.m_135782_(), (Holder<DimensionType>)levelStem.m_204521_(), levelStem.m_63990_());
            } else {
                Helper.err("cannot create default end");
            }
        }
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register(DimensionMisc.class);
    }

    @SubscribeEvent
    public static void onServerDimensionsLoad(ServerDimensionsLoadEvent event) {
        DimensionMisc.addMissingVanillaDimensions(event.generatorOptions, event.registryManager);
    }

    public static MappedRegistry<LevelStem> getAdditionalDimensionsRemoved(MappedRegistry<LevelStem> registry) {
        if (nonPersistentDimensions.isEmpty()) {
            return registry;
        }
        return MiscHelper.filterAndCopyRegistry(registry, (key, obj) -> {
            ResourceLocation identifier = key.m_135782_();
            return !nonPersistentDimensions.contains(identifier);
        });
    }

    public static void ensureRegistryNotFrozen(WorldGenSettings worldGenSettings) {
        Registry dimensions = worldGenSettings.m_204655_();
        ((IEMappedRegistry)dimensions).ip_setIsFrozen(false);
    }

    public static void ensureRegistryFrozen(WorldGenSettings worldGenSettings) {
        Registry dimensions = worldGenSettings.m_204655_();
        if (!((IEMappedRegistry)dimensions).ip_getIsFrozen()) {
            dimensions.m_203521_();
        }
    }
}

