/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import com.mojang.math.Quaternion;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DQuaternion {
    private static final Logger logger = LogManager.getLogger(DQuaternion.class);
    public final double x;
    public final double y;
    public final double z;
    public final double w;
    public static final DQuaternion identity = new DQuaternion(0.0, 0.0, 0.0, 1.0);

    public DQuaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public static DQuaternion fromMcQuaternion(Quaternion quaternion) {
        return new DQuaternion(quaternion.m_80140_(), quaternion.m_80150_(), quaternion.m_80153_(), quaternion.m_80156_());
    }

    public Vec3 getRotatingAxis() {
        return new Vec3(this.x, this.y, this.z).m_82541_();
    }

    public double getRotatingAngleRadians() {
        return Math.acos(this.w) * 2.0;
    }

    public double getRotatingAngleDegrees() {
        return Math.toDegrees(this.getRotatingAngleRadians());
    }

    public Quaternion toMcQuaternion() {
        return new Quaternion((float)this.x, (float)this.y, (float)this.z, (float)this.w);
    }

    public static DQuaternion rotationByDegrees(Vec3 rotatingAxis, double degrees) {
        return DQuaternion.rotationByRadians(rotatingAxis, Math.toRadians(degrees));
    }

    public static DQuaternion rotationByRadians(Vec3 axis, double rotationAngle) {
        double s = Math.sin(rotationAngle / 2.0);
        Vec3 normalizedAxis = axis.m_82541_();
        return new DQuaternion(normalizedAxis.m_7096_() * s, normalizedAxis.m_7098_() * s, normalizedAxis.m_7094_() * s, Math.cos(rotationAngle / 2.0));
    }

    public Vec3 rotate(Vec3 vec) {
        DQuaternion result = this.hamiltonProduct(new DQuaternion(vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0)).hamiltonProduct(this.getConjugated());
        return new Vec3(result.x, result.y, result.z);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }

    public DQuaternion hamiltonProduct(DQuaternion other) {
        double x1 = this.getX();
        double y1 = this.getY();
        double z1 = this.getZ();
        double w1 = this.getW();
        double x2 = other.getX();
        double y2 = other.getY();
        double z2 = other.getZ();
        double w2 = other.getW();
        return new DQuaternion(w1 * x2 + x1 * w2 + y1 * z2 - z1 * y2, w1 * y2 - x1 * z2 + y1 * w2 + z1 * x2, w1 * z2 + x1 * y2 - y1 * x2 + z1 * w2, w1 * w2 - x1 * x2 - y1 * y2 - z1 * z2);
    }

    public DQuaternion combine(DQuaternion other) {
        return other.hamiltonProduct(this);
    }

    public DQuaternion getConjugated() {
        return new DQuaternion(-this.x, -this.y, -this.z, this.w);
    }

    public DQuaternion multiply(double val) {
        return new DQuaternion(this.x * val, this.y * val, this.z * val, this.w * val);
    }

    public DQuaternion add(DQuaternion q) {
        return new DQuaternion(this.x + q.x, this.y + q.y, this.z + q.z, this.w + q.w);
    }

    public double dotProduct(DQuaternion q) {
        return this.getX() * q.getX() + this.getY() * q.getY() + this.getZ() * q.getZ() + this.getW() * q.getW();
    }

    public DQuaternion getNormalized() {
        double lenSq = this.dotProduct(this);
        if (lenSq != 0.0) {
            double len = Math.sqrt(lenSq);
            return this.multiply(1.0 / len);
        }
        logger.error("Normalizing zero-length quaternion", new Throwable());
        return identity;
    }

    public static DQuaternion getCameraRotation(double pitch, double yaw) {
        DQuaternion r1 = DQuaternion.rotationByDegrees(new Vec3(1.0, 0.0, 0.0), pitch);
        DQuaternion r2 = DQuaternion.rotationByDegrees(new Vec3(0.0, 1.0, 0.0), yaw + 180.0);
        DQuaternion result = r1.hamiltonProduct(r2);
        return result;
    }

    public static DQuaternion getCameraRotation1(double pitch, double yaw) {
        double p = Math.toRadians(pitch) / 2.0;
        double y = Math.toRadians(yaw) / 2.0;
        return new DQuaternion(-Math.sin(p) * Math.sin(y), Math.cos(p) * Math.cos(y), Math.sin(p) * Math.cos(y), -Math.cos(p) * Math.sin(y));
    }

    public static boolean isClose(DQuaternion a, DQuaternion b, double valve) {
        double da1 = a.getX() - b.getX();
        double db1 = a.getY() - b.getY();
        double dc1 = a.getZ() - b.getZ();
        double dd1 = a.getW() - b.getW();
        double v1 = da1 * da1 + db1 * db1 + dc1 * dc1 + dd1 * dd1;
        double da2 = a.getX() + b.getX();
        double db2 = a.getY() + b.getY();
        double dc2 = a.getZ() + b.getZ();
        double dd2 = a.getW() + b.getW();
        double v2 = da2 * da2 + db2 * db2 + dc2 * dc2 + dd2 * dd2;
        return v1 < valve || v2 < valve;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DQuaternion that = (DQuaternion)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && Double.compare(that.z, this.z) == 0 && Double.compare(that.w, this.w) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.w);
    }

    public String toString() {
        Vec3 rotatingAxis = this.getRotatingAxis();
        return String.format("Rotates %.3f degrees along (%.3f %.3f %.3f) Quaternion:(%.3f %.3f %.3f %.3f)", this.getRotatingAngleDegrees(), rotatingAxis.f_82479_, rotatingAxis.f_82480_, rotatingAxis.f_82481_, this.x, this.y, this.z, this.w);
    }

    public static DQuaternion interpolate(DQuaternion a, DQuaternion b, double t) {
        double DOT_THRESHOLD;
        double dot = a.dotProduct(b);
        if (dot < 0.0) {
            a = a.multiply(-1.0);
            dot = -dot;
        }
        if (dot > (DOT_THRESHOLD = 0.9995)) {
            return a.multiply(1.0 - t).add(b.multiply(t)).getNormalized();
        }
        double theta_0 = Math.acos(dot);
        double theta = theta_0 * t;
        double sin_theta = Math.sin(theta);
        double sin_theta_0 = Math.sin(theta_0);
        double s0 = Math.cos(theta) - dot * sin_theta / sin_theta_0;
        double s1 = sin_theta / sin_theta_0;
        return a.multiply(s0).add(b.multiply(s1));
    }

    public static Tuple<Double, Double> getPitchYawFromRotation(DQuaternion quaternion) {
        double x = quaternion.getX();
        double y = quaternion.getY();
        double z = quaternion.getZ();
        double w = quaternion.getW();
        double cosYaw = 2.0 * (y * y + z * z) - 1.0;
        double sinYaw = -(x * z + y * w) * 2.0;
        double cosPitch = 1.0 - 2.0 * (x * x + z * z);
        double sinPitch = (x * w + y * z) * 2.0;
        return new Tuple((Object)Math.toDegrees(Math.atan2(sinPitch, cosPitch)), (Object)Math.toDegrees(Math.atan2(sinYaw, cosYaw)));
    }

    public static DQuaternion matrixToQuaternion(Vec3 x, Vec3 y, Vec3 z) {
        double qz;
        double qy;
        double qx;
        double qw;
        double m00 = x.m_7096_();
        double m11 = y.m_7098_();
        double m22 = z.m_7094_();
        double m12 = z.m_7098_();
        double m21 = y.m_7094_();
        double m20 = x.m_7094_();
        double m02 = z.m_7096_();
        double m01 = y.m_7096_();
        double m10 = x.m_7098_();
        double tr = m00 + m11 + m22;
        if (tr > 0.0) {
            double S = Math.sqrt(tr + 1.0) * 2.0;
            qw = 0.25 * S;
            qx = (m21 - m12) / S;
            qy = (m02 - m20) / S;
            qz = (m10 - m01) / S;
        } else if (m00 > m11 && m00 > m22) {
            double S = Math.sqrt(1.0 + m00 - m11 - m22) * 2.0;
            qw = (m21 - m12) / S;
            qx = 0.25 * S;
            qy = (m01 + m10) / S;
            qz = (m02 + m20) / S;
        } else if (m11 > m22) {
            double S = Math.sqrt(1.0 + m11 - m00 - m22) * 2.0;
            qw = (m02 - m20) / S;
            qx = (m01 + m10) / S;
            qy = 0.25 * S;
            qz = (m12 + m21) / S;
        } else {
            double S = Math.sqrt(1.0 + m22 - m00 - m11) * 2.0;
            qw = (m10 - m01) / S;
            qx = (m02 + m20) / S;
            qy = (m12 + m21) / S;
            qz = 0.25 * S;
        }
        return new DQuaternion(qx, qy, qz, qw);
    }

    public static DQuaternion getRotationBetween(Vec3 from, Vec3 to) {
        from = from.m_82541_();
        to = to.m_82541_();
        Vec3 axis = from.m_82537_(to).m_82541_();
        double cos = from.m_82526_(to);
        double angle = Math.acos(cos);
        return DQuaternion.rotationByRadians(axis, angle);
    }

    public Tag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("x", this.x);
        tag.m_128347_("y", this.y);
        tag.m_128347_("z", this.z);
        tag.m_128347_("w", this.w);
        return tag;
    }

    public static DQuaternion fromTag(Tag tag) {
        if (!(tag instanceof CompoundTag)) {
            return identity;
        }
        CompoundTag compoundTag = (CompoundTag)tag;
        if (!compoundTag.m_128441_("x")) {
            return identity;
        }
        return new DQuaternion(compoundTag.m_128459_("x"), compoundTag.m_128459_("y"), compoundTag.m_128459_("z"), compoundTag.m_128459_("w"));
    }

    public DQuaternion fixFloatingPointErrorAccumulation() {
        DQuaternion quaternion = new DQuaternion(DQuaternion.fixCoordinateFloatingPointError(this.getX()), DQuaternion.fixCoordinateFloatingPointError(this.getY()), DQuaternion.fixCoordinateFloatingPointError(this.getZ()), DQuaternion.fixCoordinateFloatingPointError(this.getW()));
        return quaternion.getNormalized();
    }

    private static double fixCoordinateFloatingPointError(double num) {
        double threshold = 1.0E-7;
        if (Math.abs(num) < 1.0E-7) {
            return 0.0;
        }
        if (Math.abs(num - 1.0) < 1.0E-7) {
            return 1.0;
        }
        if (Math.abs(num - -1.0) < 1.0E-7) {
            return -1.0;
        }
        return num;
    }

    public boolean isAxisAligned() {
        return DQuaternion.isCoordinateZeroOrOneOrNegativeOne(this.getX()) && DQuaternion.isCoordinateZeroOrOneOrNegativeOne(this.getY()) && DQuaternion.isCoordinateZeroOrOneOrNegativeOne(this.getZ()) && DQuaternion.isCoordinateZeroOrOneOrNegativeOne(this.getW());
    }

    private static boolean isCoordinateZeroOrOneOrNegativeOne(double coord) {
        return coord == 0.0 || coord == 1.0 || coord == -1.0;
    }
}

