/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import qouteall.q_misc_util.Helper;

public class Signal {
    private List<Runnable> funcList = new ArrayList<Runnable>();
    private boolean isEmitting = false;

    public void emit() {
        this.isEmitting = true;
        try {
            this.funcList.forEach(runnable -> runnable.run());
        }
        finally {
            this.isEmitting = false;
        }
    }

    public <T> void connectWithWeakRef(T owner, Consumer<T> func) {
        WeakReference weakRef = new WeakReference(owner);
        Helper.SimpleBox<Object> boxOfRunnable = new Helper.SimpleBox<Object>(null);
        boxOfRunnable.obj = () -> {
            Object currentTarget = weakRef.get();
            if (currentTarget != null) {
                func.accept(currentTarget);
            } else {
                this.disconnect((Runnable)boxOfRunnable.obj);
            }
        };
        this.connect((Runnable)boxOfRunnable.obj);
    }

    public void connect(Runnable func) {
        this.copyDataWhenEmitting();
        this.funcList.add(func);
    }

    public void disconnect(Runnable func) {
        this.copyDataWhenEmitting();
        boolean removed = this.funcList.remove(func);
        assert (removed);
    }

    private void copyDataWhenEmitting() {
        if (this.isEmitting) {
            this.funcList = new ArrayList<Runnable>(this.funcList);
        }
    }
}

