/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.tiles;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.TorchmasterConfig;
import net.xalcon.torchmaster.common.ModBlocks;

public class FeralFlareLanternTileEntity
extends BlockEntity {
    private FakePlayer fakePlayer;
    private int ticks;
    private boolean useLineOfSight;
    private List<BlockPos> childLights = new ArrayList<BlockPos>();

    public FeralFlareLanternTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.tileFeralFlareLantern.get(), pos, state);
    }

    public void tick() {
        int z;
        int y;
        int diameter;
        int radius;
        int x;
        BlockPos targetPos;
        if (this.f_58857_.f_46443_ || ++this.ticks % (Integer)TorchmasterConfig.GENERAL.feralFlareTickRate.get() != 0) {
            return;
        }
        if (this.childLights.size() > (Integer)TorchmasterConfig.GENERAL.feralFlareLanternLightCountHardcap.get()) {
            return;
        }
        this.ticks = 0;
        if (this.fakePlayer == null) {
            this.fakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.f_58857_), (GameProfile)new GameProfile(UUID.fromString("2282ab80-e482-11e9-81b4-2a2ae2dbcce4"), "TorchMasterFeralFlareLantern"));
        }
        if (!this.f_58857_.m_46749_(targetPos = new BlockPos(x = (radius = ((Integer)TorchmasterConfig.GENERAL.feralFlareRadius.get()).intValue()) - this.f_58857_.f_46441_.m_188503_(diameter = radius * 2) + this.f_58858_.m_123341_(), y = radius - this.f_58857_.f_46441_.m_188503_(diameter) + this.f_58858_.m_123342_(), z = radius - this.f_58857_.f_46441_.m_188503_(diameter) + this.f_58858_.m_123343_()))) {
            return;
        }
        int surfaceHeight = this.f_58857_.m_6924_(Heightmap.Types.WORLD_SURFACE, targetPos.m_123341_(), targetPos.m_123343_());
        if (targetPos.m_123342_() > surfaceHeight + 4) {
            targetPos = targetPos.m_175288_(surfaceHeight).m_6630_(4);
        }
        int worldHeightCap = this.f_58857_.m_141928_();
        if (targetPos.m_123342_() > worldHeightCap) {
            targetPos = new BlockPos(targetPos.m_123341_(), worldHeightCap - 1, targetPos.m_123343_());
        }
        if (!this.f_58857_.m_46749_(targetPos)) {
            return;
        }
        if (this.f_58857_.m_46859_(targetPos) && this.f_58857_.m_45517_(LightLayer.BLOCK, targetPos) < (Integer)TorchmasterConfig.GENERAL.feralFlareMinLightLevel.get()) {
            BlockPos hitPos;
            Vec3 end;
            Vec3 start;
            ClipContext rtxCtx;
            BlockHitResult rtResult;
            if (this.useLineOfSight && (rtResult = this.f_58857_.m_45547_(rtxCtx = new ClipContext(start = new Vec3((double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_()).m_82520_(0.5, 0.5, 0.5), end = new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()).m_82520_(0.5, 0.5, 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this.fakePlayer))).m_6662_() == HitResult.Type.BLOCK && ((hitPos = rtResult.m_82425_()).m_123341_() != this.f_58858_.m_123341_() || hitPos.m_123342_() != this.f_58858_.m_123342_() || hitPos.m_123343_() != this.f_58858_.m_123343_())) {
                return;
            }
            if (this.f_58857_.m_7731_(targetPos, ((AirBlock)ModBlocks.blockInvisibleLight.get()).m_49966_(), 3)) {
                this.childLights.add(targetPos);
                this.m_6596_();
            }
        }
    }

    public static <T extends BlockEntity> void dispatchTickBlockEntity(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof FeralFlareLanternTileEntity) {
            ((FeralFlareLanternTileEntity)blockEntity).tick();
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ArrayList<Integer> childLightsEncoded = new ArrayList<Integer>(this.childLights.size());
        for (BlockPos child : this.childLights) {
            childLightsEncoded.add(FeralFlareLanternTileEntity.encodePosition(this.f_58858_, child));
        }
        nbt.m_128365_("lights", (Tag)new IntArrayTag(childLightsEncoded));
        nbt.m_128405_("ticks", this.ticks);
        nbt.m_128379_("useLoS", this.useLineOfSight);
    }

    public void m_142466_(CompoundTag nbt) {
        this.childLights.clear();
        if (nbt.m_128435_("lights") == 11) {
            int[] lightsEncoded;
            BlockPos origin = new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
            for (int encodedLight : lightsEncoded = ((IntArrayTag)nbt.m_128423_("lights")).m_128648_()) {
                this.childLights.add(FeralFlareLanternTileEntity.decodePosition(origin, encodedLight));
            }
        }
        this.ticks = nbt.m_128451_("ticks");
        this.useLineOfSight = nbt.m_128471_("useLoS");
        super.m_142466_(nbt);
    }

    public void setUseLineOfSight(boolean state) {
        Torchmaster.Log.info("Current: {}, New: {}", (Object)this.useLineOfSight, (Object)state);
        this.useLineOfSight = state;
        this.m_6596_();
        BlockState blockState = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, blockState, blockState, 3);
    }

    public boolean shouldUseLineOfSight() {
        return this.useLineOfSight;
    }

    public void removeChildLights() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        for (BlockPos pos : this.childLights) {
            if (this.f_58857_.m_8055_(pos).m_60734_() != ModBlocks.blockInvisibleLight.get()) continue;
            this.f_58857_.m_7471_(pos, false);
        }
        this.childLights.clear();
    }

    private static int encodePosition(BlockPos origin, BlockPos target) {
        int x = target.m_123341_() - origin.m_123341_();
        int y = target.m_123342_() - origin.m_123342_();
        int z = target.m_123343_() - origin.m_123343_();
        return ((x & 0xFF) << 16) + ((y & 0xFF) << 8) + (z & 0xFF);
    }

    private static BlockPos decodePosition(BlockPos origin, int pos) {
        byte x = (byte)(pos >> 16 & 0xFF);
        byte y = (byte)(pos >> 8 & 0xFF);
        byte z = (byte)(pos & 0xFF);
        return origin.m_7918_((int)x, (int)y, (int)z);
    }
}

