/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.book.Book;
import juuxel.adorn.client.book.Image;
import juuxel.adorn.client.book.Page;
import juuxel.adorn.client.gui.Scissors;
import juuxel.adorn.client.gui.widget.Draggable;
import juuxel.adorn.client.gui.widget.FlipBook;
import juuxel.adorn.client.gui.widget.Panel;
import juuxel.adorn.client.gui.widget.ScrollEnvelope;
import juuxel.adorn.client.gui.widget.SizedElement;
import juuxel.adorn.client.gui.widget.TickingElement;
import juuxel.adorn.util.Colors;
import juuxel.adorn.util.ColorsKt;
import juuxel.adorn.util.animation.AnimationEngine;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 *2\u00020\u0001:\u0005+,-*.B\u000f\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b(\u0010)J\u0019\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0010\u0010\tJ/\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0019\u0010\tJ\u000f\u0010\u001a\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001a\u0010\tR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010%\u001a\u00020$8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010'\u001a\u00020$8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b'\u0010&\u00a8\u0006/"}, d2={"Ljuuxel/adorn/client/gui/screen/GuideBookScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "Lnet/minecraft/network/chat/Style;", "style", "", "handleTextClick", "(Lnet/minecraft/network/chat/Style;)Z", "", "init", "()V", "", "keyCode", "scanCode", "modifiers", "keyPressed", "(III)Z", "removed", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "mouseX", "mouseY", "", "delta", "render", "(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V", "tick", "updatePageTurnButtons", "Ljuuxel/adorn/util/animation/AnimationEngine;", "animationEngine", "Ljuuxel/adorn/util/animation/AnimationEngine;", "Ljuuxel/adorn/client/book/Book;", "book", "Ljuuxel/adorn/client/book/Book;", "Ljuuxel/adorn/client/gui/widget/FlipBook;", "flipBook", "Ljuuxel/adorn/client/gui/widget/FlipBook;", "Lnet/minecraft/client/gui/screens/inventory/PageButton;", "nextPageButton", "Lnet/minecraft/client/gui/screens/inventory/PageButton;", "previousPageButton", "<init>", "(Ljuuxel/adorn/client/book/Book;)V", "Companion", "BookPageBody", "BookPageTitle", "CloseButton", "TitlePage", "Adorn"})
public final class GuideBookScreen
extends Screen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Book book;
    private FlipBook flipBook;
    private PageButton previousPageButton;
    private PageButton nextPageButton;
    @NotNull
    private final AnimationEngine animationEngine;
    private static final int BOOK_SIZE = 192;
    private static final int PAGE_TITLE_X = 20;
    private static final int PAGE_WIDTH = 116;
    private static final int PAGE_BODY_HEIGHT = 121;
    private static final int PAGE_TITLE_WIDTH = 76;
    private static final int PAGE_TEXT_X = 4;
    private static final int PAGE_TEXT_Y = 24;
    private static final int PAGE_IMAGE_GAP = 4;
    private static final int ICON_DURATION = 25;
    @NotNull
    private static final ResourceLocation CLOSE_BOOK_ACTIVE_TEXTURE = AdornCommon.id("textures/gui/close_book_active.png");
    @NotNull
    private static final ResourceLocation CLOSE_BOOK_INACTIVE_TEXTURE = AdornCommon.id("textures/gui/close_book_inactive.png");
    private static final int HOVER_AREA_HIGHLIGHT_COLOR = ColorsKt.color(0xFFFFFF, 128);

    public GuideBookScreen(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        super(GameNarrator.f_93310_);
        this.book = book;
        this.animationEngine = new AnimationEngine();
    }

    protected void m_7856_() {
        int x = (this.f_96543_ - 192) / 2;
        int y = (this.f_96544_ - 192) / 2;
        int pageX = x + 35;
        int pageY = y + 14;
        this.m_142416_((GuiEventListener)new CloseButton(x + 142, y + 14, arg_0 -> GuideBookScreen.init$lambda-0(this, arg_0)));
        GuiEventListener guiEventListener = this.m_142416_((GuiEventListener)new PageButton(x + 49, y + 159, false, arg_0 -> GuideBookScreen.init$lambda-1(this, arg_0), true));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener, (String)"addDrawableChild(PageTur\u2026wPreviousPage() }, true))");
        this.previousPageButton = (PageButton)guiEventListener;
        GuiEventListener guiEventListener2 = this.m_142416_((GuiEventListener)new PageButton(x + 116, y + 159, true, arg_0 -> GuideBookScreen.init$lambda-2(this, arg_0), true));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener2, (String)"addDrawableChild(PageTur\u2026.showNextPage() }, true))");
        this.nextPageButton = (PageButton)guiEventListener2;
        GuiEventListener guiEventListener3 = this.m_142416_(new FlipBook((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                GuideBookScreen.access$updatePageTurnButtons((GuideBookScreen)((Object)this.receiver));
            }
        })));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener3, (String)"addDrawableChild(FlipBoo\u2026::updatePageTurnButtons))");
        this.flipBook = (FlipBook)guiEventListener3;
        FlipBook flipBook = this.flipBook;
        if (flipBook == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
            flipBook = null;
        }
        flipBook.add(new TitlePage(pageX, pageY, this.book));
        for (Page page : this.book.getPages()) {
            Panel panel = new Panel();
            panel.add(new BookPageTitle(pageX, pageY, page));
            BookPageBody body = new BookPageBody(pageX, pageY + 24, page);
            panel.add(new ScrollEnvelope(pageX, pageY + 24, 116, 121, body, this.animationEngine));
            FlipBook flipBook2 = this.flipBook;
            if (flipBook2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
                flipBook2 = null;
            }
            flipBook2.add((GuiEventListener)panel);
        }
        this.updatePageTurnButtons();
        this.animationEngine.start();
    }

    private final void updatePageTurnButtons() {
        FlipBook flipBook;
        FlipBook flipBook2;
        PageButton pageButton = this.previousPageButton;
        if (pageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previousPageButton");
            pageButton = null;
        }
        if ((flipBook2 = this.flipBook) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
            flipBook2 = null;
        }
        pageButton.f_93624_ = flipBook2.hasPreviousPage();
        PageButton pageButton2 = this.nextPageButton;
        if (pageButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nextPageButton");
            pageButton2 = null;
        }
        if ((flipBook = this.flipBook) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
            flipBook = null;
        }
        pageButton2.f_93624_ = flipBook.hasNextPage();
    }

    public void m_6305_(@NotNull PoseStack matrices, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        this.m_7333_(matrices);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BookViewScreen.f_98252_);
        int x = (this.f_96543_ - 192) / 2;
        int y = (this.f_96544_ - 192) / 2;
        this.m_93228_(matrices, x, y, 0, 0, 192, 192);
        super.m_6305_(matrices, mouseX, mouseY, delta);
    }

    public boolean m_5561_(@Nullable Style style) {
        ClickEvent clickEvent;
        if (style != null && (clickEvent = style.m_131182_()) != null && clickEvent.m_130622_() == ClickEvent.Action.CHANGE_PAGE) {
            boolean bl;
            String string = clickEvent.m_130623_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clickEvent.value");
            Integer n = StringsKt.toIntOrNull((String)string);
            if (n == null) {
                return false;
            }
            int page = n;
            int pageIndex = page - 1;
            if (0 <= pageIndex) {
                FlipBook flipBook = this.flipBook;
                if (flipBook == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
                    flipBook = null;
                }
                bl = pageIndex < flipBook.getPageCount();
            } else {
                bl = false;
            }
            if (bl) {
                FlipBook flipBook = this.flipBook;
                if (flipBook == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
                    flipBook = null;
                }
                flipBook.setCurrentPage(pageIndex);
                Minecraft minecraft = this.f_96541_;
                Intrinsics.checkNotNull((Object)minecraft);
                minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                return true;
            }
        }
        return super.m_5561_(style);
    }

    public void m_86600_() {
        ContainerEventHandler $this$forEach$iv = (ContainerEventHandler)this;
        boolean $i$f$forEach = false;
        for (GuiEventListener child$iv : $this$forEach$iv.m_6702_()) {
            if (!(child$iv instanceof TickingElement)) continue;
            TickingElement it = (TickingElement)child$iv;
            boolean bl = false;
            it.tick();
        }
        GuiEventListener focused = this.m_7222_();
        if (focused instanceof Draggable && !this.m_7282_()) {
            ((Draggable)focused).stopDragging();
        }
    }

    public void m_7861_() {
        this.animationEngine.stop();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        GuiEventListener currentPage;
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        FlipBook flipBook = this.flipBook;
        if (flipBook == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
            flipBook = null;
        }
        if ((currentPage = flipBook.getCurrentPageValue()) instanceof Panel) {
            Object v1;
            block5: {
                Iterable $this$firstOrNull$iv = ((Panel)currentPage).m_6702_();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    GuiEventListener it = (GuiEventListener)element$iv;
                    boolean bl = false;
                    if (!(it instanceof ScrollEnvelope)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            GuiEventListener scroll = v1;
            if (scroll != null) {
                return scroll.m_7933_(keyCode, scanCode, modifiers);
            }
        }
        return false;
    }

    private static final void init$lambda-0(GuideBookScreen this$0, Button it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.m_7379_();
    }

    private static final void init$lambda-1(GuideBookScreen this$0, Button it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        FlipBook flipBook = this$0.flipBook;
        if (flipBook == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
            flipBook = null;
        }
        flipBook.showPreviousPage();
    }

    private static final void init$lambda-2(GuideBookScreen this$0, Button it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        FlipBook flipBook = this$0.flipBook;
        if (flipBook == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flipBook");
            flipBook = null;
        }
        flipBook.showNextPage();
    }

    public static final /* synthetic */ void access$updatePageTurnButtons(GuideBookScreen $this) {
        $this.updatePageTurnButtons();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0007R\u0014\u0010\t\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0004R\u0014\u0010\n\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0004R\u0014\u0010\u000b\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0004R\u0014\u0010\f\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0004R\u0014\u0010\r\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0004R\u0014\u0010\u000e\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0004R\u0014\u0010\u000f\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0004R\u0014\u0010\u0010\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0004R\u0014\u0010\u0011\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0004\u00a8\u0006\u0014"}, d2={"Ljuuxel/adorn/client/gui/screen/GuideBookScreen$Companion;", "", "", "BOOK_SIZE", "I", "Lnet/minecraft/resources/ResourceLocation;", "CLOSE_BOOK_ACTIVE_TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "CLOSE_BOOK_INACTIVE_TEXTURE", "HOVER_AREA_HIGHLIGHT_COLOR", "ICON_DURATION", "PAGE_BODY_HEIGHT", "PAGE_IMAGE_GAP", "PAGE_TEXT_X", "PAGE_TEXT_Y", "PAGE_TITLE_WIDTH", "PAGE_TITLE_X", "PAGE_WIDTH", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0014\u001a\u00020\u0005\u0012\u0006\u0010\u0016\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015\u00a8\u0006\u0019"}, d2={"Ljuuxel/adorn/client/gui/screen/GuideBookScreen$TitlePage;", "Lnet/minecraft/client/gui/components/events/GuiEventListener;", "Lnet/minecraft/client/gui/components/Widget;", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "", "mouseX", "mouseY", "", "delta", "", "render", "(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V", "Ljuuxel/adorn/client/book/Book;", "book", "Ljuuxel/adorn/client/book/Book;", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "byAuthor", "Lnet/minecraft/network/chat/MutableComponent;", "x", "I", "y", "<init>", "(Ljuuxel/adorn/client/gui/screen/GuideBookScreen;IILjuuxel/adorn/client/book/Book;)V", "Adorn"})
    private final class TitlePage
    implements GuiEventListener,
    Widget {
        private final int x;
        private final int y;
        @NotNull
        private final Book book;
        private final MutableComponent byAuthor;

        public TitlePage(int x, @NotNull int y, Book book) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            this.x = x;
            this.y = y;
            this.book = book;
            Object[] objectArray = new Object[]{this.book.getAuthor()};
            this.byAuthor = Component.m_237110_((String)"book.byAuthor", (Object[])objectArray);
        }

        public void m_6305_(@NotNull PoseStack matrices, int mouseX, int mouseY, float delta) {
            Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
            int cx = this.x + 58;
            matrices.m_85836_();
            matrices.m_85837_((double)cx, (double)(this.y + 7) + (double)25, 0.0);
            matrices.m_85841_(this.book.getTitleScale(), this.book.getTitleScale(), 1.0f);
            GuideBookScreen.this.f_96547_.m_92889_(matrices, this.book.getTitle(), -((float)(GuideBookScreen.this.f_96547_.m_92852_((FormattedText)this.book.getTitle()) / 2)), 0.0f, Colors.INSTANCE.getSCREEN_TEXT());
            matrices.m_85849_();
            GuideBookScreen.this.f_96547_.m_92889_(matrices, this.book.getSubtitle(), (float)(cx - GuideBookScreen.this.f_96547_.m_92852_((FormattedText)this.book.getSubtitle()) / 2), (float)this.y + 45.0f, Colors.INSTANCE.getSCREEN_TEXT());
            GuideBookScreen.this.f_96547_.m_92889_(matrices, (Component)this.byAuthor, (float)(cx - GuideBookScreen.this.f_96547_.m_92852_((FormattedText)this.byAuthor) / 2), (float)this.y + 60.0f, Colors.INSTANCE.getSCREEN_TEXT());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u001b\u001a\u00020\u0006\u0012\u0006\u0010\u001c\u001a\u00020\u0006\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0011R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R8\u0010\u001a\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u0018 \u0019*\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u0018\u0018\u00010\u00130\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0016R\u0014\u0010\u001b\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0011R\u0014\u0010\u001c\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0011\u00a8\u0006!"}, d2={"Ljuuxel/adorn/client/gui/screen/GuideBookScreen$BookPageTitle;", "Lnet/minecraft/client/gui/components/events/GuiEventListener;", "Lnet/minecraft/client/gui/components/Widget;", "Ljuuxel/adorn/client/gui/widget/TickingElement;", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "", "mouseX", "mouseY", "", "delta", "", "render", "(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V", "tick", "()V", "icon", "I", "iconTicks", "", "Lnet/minecraft/world/item/ItemStack;", "icons", "Ljava/util/List;", "", "Lnet/minecraft/util/FormattedCharSequence;", "kotlin.jvm.PlatformType", "wrappedTitleLines", "x", "y", "Ljuuxel/adorn/client/book/Page;", "page", "<init>", "(Ljuuxel/adorn/client/gui/screen/GuideBookScreen;IILjuuxel/adorn/client/book/Page;)V", "Adorn"})
    private final class BookPageTitle
    implements GuiEventListener,
    Widget,
    TickingElement {
        private final int x;
        private final int y;
        private final List<FormattedCharSequence> wrappedTitleLines;
        @NotNull
        private final List<ItemStack> icons;
        private int icon;
        private int iconTicks;

        /*
         * WARNING - void declaration
         */
        public BookPageTitle(int x, @NotNull int y, Page page) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            this.x = x;
            this.y = y;
            this.wrappedTitleLines = GuideBookScreen.this.f_96547_.m_92923_((FormattedText)page.getTitle().m_6881_().m_130938_(BookPageTitle::wrappedTitleLines$lambda-0), 76);
            Iterable iterable = page.getIcons();
            BookPageTitle bookPageTitle = this;
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Page.Icon icon = (Page.Icon)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.createStacks());
            }
            bookPageTitle.icons = juuxel.adorn.util.CollectionsKt.interleave((List)destination$iv$iv);
        }

        public void m_6305_(@NotNull PoseStack matrices, int mouseX, int mouseY, float delta) {
            Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
            GuideBookScreen.this.f_96542_.m_115123_(this.icons.get(this.icon), this.x, this.y);
            float titleY = this.y + 10 - ((GuideBookScreen)GuideBookScreen.this).f_96547_.f_92710_ * this.wrappedTitleLines.size() / 2;
            Iterator<FormattedCharSequence> iterator = this.wrappedTitleLines.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                FormattedCharSequence line = iterator.next();
                GuideBookScreen.this.f_96547_.m_92877_(matrices, line, (float)(this.x + 20), titleY + (float)(i * ((GuideBookScreen)GuideBookScreen.this).f_96547_.f_92710_), Colors.INSTANCE.getSCREEN_TEXT());
            }
        }

        @Override
        public void tick() {
            int n = this.iconTicks;
            this.iconTicks = n + 1;
            if (n >= 25) {
                this.iconTicks = 0;
                this.icon = (this.icon + 1) % this.icons.size();
            }
        }

        private static final Style wrappedTitleLines$lambda-0(Style it) {
            return it.m_131136_(Boolean.valueOf(true));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b.\u0010/J!\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0010\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J/\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\u001eR\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010\u001eR\u001a\u0010&\u001a\u00020\u00038\u0016X\u0096D\u00a2\u0006\f\n\u0004\b&\u0010\u001e\u001a\u0004\b'\u0010 R8\u0010,\u001a&\u0012\f\u0012\n **\u0004\u0018\u00010)0) **\u0012\u0012\f\u0012\n **\u0004\u0018\u00010)0)\u0018\u00010+0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001eR\u0014\u0010\u0005\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001e\u00a8\u00060"}, d2={"Ljuuxel/adorn/client/gui/screen/GuideBookScreen$BookPageBody;", "Ljuuxel/adorn/client/gui/widget/SizedElement;", "Lnet/minecraft/client/gui/components/Widget;", "", "x", "y", "Lnet/minecraft/network/chat/Style;", "getTextStyleAt", "(II)Lnet/minecraft/network/chat/Style;", "", "mouseX", "mouseY", "", "isMouseOver", "(DD)Z", "button", "mouseClicked", "(DDI)Z", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "", "delta", "", "render", "(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V", "Ljuuxel/adorn/client/book/Image;", "image", "renderImage", "(Lcom/mojang/blaze3d/vertex/PoseStack;Ljuuxel/adorn/client/book/Image;II)V", "height", "I", "getHeight", "()I", "imageHeight", "Ljuuxel/adorn/client/book/Page;", "page", "Ljuuxel/adorn/client/book/Page;", "textHeight", "width", "getWidth", "", "Lnet/minecraft/util/FormattedCharSequence;", "kotlin.jvm.PlatformType", "", "wrappedBodyLines", "Ljava/util/List;", "<init>", "(Ljuuxel/adorn/client/gui/screen/GuideBookScreen;IILjuuxel/adorn/client/book/Page;)V", "Adorn"})
    private final class BookPageBody
    implements SizedElement,
    Widget {
        private final int x;
        private final int y;
        @NotNull
        private final Page page;
        private final int width;
        private final List<FormattedCharSequence> wrappedBodyLines;
        private final int textHeight;
        private final int imageHeight;
        private final int height;

        public BookPageBody(int x, @NotNull int y, Page page) {
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            this.x = x;
            this.y = y;
            this.page = page;
            this.width = 116;
            this.wrappedBodyLines = GuideBookScreen.this.f_96547_.m_92923_((FormattedText)this.page.getText(), 112);
            this.textHeight = this.wrappedBodyLines.size() * ((GuideBookScreen)GuideBookScreen.this).f_96547_.f_92710_;
            this.imageHeight = this.page.getImage() != null ? this.page.getImage().getSize().getY() + 4 : 0;
            this.height = Math.max(121, this.textHeight + this.imageHeight);
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return (double)this.x <= mouseX && mouseX <= (double)(this.x + this.getWidth()) && (double)this.y <= mouseY && mouseY <= (double)(this.y + this.getHeight());
        }

        private final Style getTextStyleAt(int x, int y) {
            if (!this.m_5953_(x, y)) {
                return null;
            }
            int wx = x - (this.x + 4);
            int wy = y - this.y;
            int lineIndex = wy / ((GuideBookScreen)GuideBookScreen.this).f_96547_.f_92710_;
            boolean bl = 0 <= lineIndex ? lineIndex < this.wrappedBodyLines.size() : false;
            if (bl) {
                FormattedCharSequence line = this.wrappedBodyLines.get(lineIndex);
                return GuideBookScreen.this.f_96547_.m_92865_().m_92338_(line, wx);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public void m_6305_(@NotNull PoseStack matrices, int mouseX, int mouseY, float delta) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
            int textYOffset = this.page.getImage() != null && this.page.getImage().getPlacement() == Image.Placement.BEFORE_TEXT ? this.imageHeight : 0;
            Iterator<FormattedCharSequence> iterator = this.wrappedBodyLines.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                FormattedCharSequence line = iterator.next();
                GuideBookScreen.this.f_96547_.m_92877_(matrices, line, (float)(this.x + 4), (float)(textYOffset + this.y + i * ((GuideBookScreen)GuideBookScreen.this).f_96547_.f_92710_), Colors.INSTANCE.getSCREEN_TEXT());
            }
            if (this.page.getImage() != null) {
                this.renderImage(matrices, this.page.getImage(), mouseX, mouseY);
            }
            Style hoveredStyle = this.getTextStyleAt(mouseX, mouseY);
            Scissors scissors = Scissors.INSTANCE;
            GuideBookScreen guideBookScreen = GuideBookScreen.this;
            boolean $i$f$suspendScissors = false;
            Scissors.Frame frame$iv = this_$iv.pop();
            boolean bl = false;
            guideBookScreen.m_96570_(matrices, hoveredStyle, mouseX, mouseY);
            this_$iv.push(frame$iv);
        }

        /*
         * WARNING - void declaration
         */
        private final void renderImage(PoseStack matrices, Image image, int mouseX, int mouseY) {
            int imageX = this.x + (116 - image.getSize().getX()) / 2;
            int imageY = switch (WhenMappings.$EnumSwitchMapping$0[image.getPlacement().ordinal()]) {
                case 1 -> this.y;
                case 2 -> this.y + this.textHeight + 4;
                default -> throw new NoWhenBranchMatchedException();
            };
            RenderSystem.m_69478_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)image.getLocation());
            Screen.m_93133_((PoseStack)matrices, (int)imageX, (int)imageY, (float)0.0f, (float)0.0f, (int)image.getSize().getX(), (int)image.getSize().getY(), (int)image.getSize().getX(), (int)image.getSize().getY());
            RenderSystem.m_69461_();
            for (Image.HoverArea hoverArea : image.getHoverAreas()) {
                void this_$iv;
                if (!hoverArea.contains(mouseX - imageX, mouseY - imageY)) continue;
                int hX = imageX + hoverArea.getPosition().getX();
                int hY = imageY + hoverArea.getPosition().getY();
                Screen.m_93172_((PoseStack)matrices, (int)hX, (int)hY, (int)(hX + hoverArea.getSize().getX()), (int)(hY + hoverArea.getSize().getY()), (int)HOVER_AREA_HIGHLIGHT_COLOR);
                Minecraft minecraft = GuideBookScreen.this.f_96541_;
                Intrinsics.checkNotNull((Object)minecraft);
                List wrappedTooltip = minecraft.f_91062_.m_92923_((FormattedText)hoverArea.getTooltip(), 116);
                Scissors scissors = Scissors.INSTANCE;
                GuideBookScreen guideBookScreen = GuideBookScreen.this;
                boolean $i$f$suspendScissors = false;
                Scissors.Frame frame$iv = this_$iv.pop();
                boolean bl = false;
                guideBookScreen.m_96617_(matrices, wrappedTooltip, mouseX, mouseY);
                this_$iv.push(frame$iv);
                break;
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            Style style;
            if (button == 0 && (style = this.getTextStyleAt((int)mouseX, (int)mouseY)) != null && GuideBookScreen.this.m_5561_(style)) {
                return true;
            }
            return SizedElement.super.m_6375_(mouseX, mouseY, button);
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Image.Placement.values().length];
                nArray[Image.Placement.BEFORE_TEXT.ordinal()] = 1;
                nArray[Image.Placement.AFTER_TEXT.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\f\u001a\u00020\u0004\u0012\u0006\u0010\r\u001a\u00020\u0004\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J/\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Ljuuxel/adorn/client/gui/screen/GuideBookScreen$CloseButton;", "Lnet/minecraft/client/gui/components/Button;", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "", "mouseX", "mouseY", "", "delta", "", "renderButton", "(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V", "x", "y", "Lnet/minecraft/client/gui/widget/ButtonWidget$PressAction;", "pressAction", "<init>", "(IILnet/minecraft/client/gui/components/Button$OnPress;)V", "Adorn"})
    private static final class CloseButton
    extends Button {
        public CloseButton(int x, int y, @NotNull Button.OnPress pressAction) {
            Intrinsics.checkNotNullParameter((Object)pressAction, (String)"pressAction");
            super(x, y, 8, 8, (Component)Component.m_237119_(), pressAction);
        }

        public void m_6303_(@NotNull PoseStack matrices, int mouseX, int mouseY, float delta) {
            Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)(this.m_198029_() ? CLOSE_BOOK_ACTIVE_TEXTURE : CLOSE_BOOK_INACTIVE_TEXTURE));
            Button.m_93133_((PoseStack)matrices, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)0.0f, (int)8, (int)8, (int)8, (int)8);
        }
    }
}

