/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge.util;

import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001f\u0010 R$\u0010\b\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00028V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R$\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR(\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0016\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001b\u001a\u00020\u001a8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Ljuuxel/adorn/platform/forge/util/FluidTankReference;", "Ljuuxel/adorn/fluid/FluidReference;", "", "value", "getAmount", "()J", "setAmount", "(J)V", "amount", "Lnet/minecraft/world/level/material/Fluid;", "getFluid", "()Lnet/minecraft/world/level/material/Fluid;", "setFluid", "(Lnet/minecraft/world/level/material/Fluid;)V", "fluid", "Lnet/minecraft/nbt/CompoundTag;", "getNbt", "()Lnet/minecraft/nbt/CompoundTag;", "setNbt", "(Lnet/minecraft/nbt/CompoundTag;)V", "nbt", "Lnet/minecraftforge/fluids/capability/templates/FluidTank;", "tank", "Lnet/minecraftforge/fluids/capability/templates/FluidTank;", "getTank", "()Lnet/minecraftforge/fluids/capability/templates/FluidTank;", "Ljuuxel/adorn/fluid/FluidUnit;", "unit", "Ljuuxel/adorn/fluid/FluidUnit;", "getUnit", "()Ljuuxel/adorn/fluid/FluidUnit;", "<init>", "(Lnet/minecraftforge/fluids/capability/templates/FluidTank;)V", "Adorn"})
public final class FluidTankReference
extends FluidReference {
    @NotNull
    private final FluidTank tank;
    @NotNull
    private final FluidUnit unit;

    public FluidTankReference(@NotNull FluidTank tank2) {
        Intrinsics.checkNotNullParameter((Object)tank2, (String)"tank");
        this.tank = tank2;
        this.unit = FluidUnit.LITRE;
    }

    @NotNull
    public final FluidTank getTank() {
        return this.tank;
    }

    @Override
    @NotNull
    public Fluid getFluid() {
        Fluid fluid = this.tank.getFluid().getFluid();
        Intrinsics.checkNotNullExpressionValue((Object)fluid, (String)"tank.fluid.fluid");
        return fluid;
    }

    @Override
    public void setFluid(@NotNull Fluid value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.tank.setFluid(new FluidStack(value2, this.tank.getFluid().getAmount(), this.tank.getFluid().getTag()));
    }

    @Override
    public long getAmount() {
        return this.tank.getFluid().getAmount();
    }

    @Override
    public void setAmount(long value2) {
        this.tank.getFluid().setAmount((int)value2);
    }

    @Override
    @Nullable
    public CompoundTag getNbt() {
        return this.tank.getFluid().getTag();
    }

    @Override
    public void setNbt(@Nullable CompoundTag value2) {
        this.tank.getFluid().setTag(value2);
    }

    @Override
    @NotNull
    public FluidUnit getUnit() {
        return this.unit;
    }
}

