/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.gui;

import com.aizistral.nochatreports.config.NCRConfig;
import com.aizistral.nochatreports.config.NCRConfigEncryption;
import com.aizistral.nochatreports.encryption.Encryption;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EncryptionConfigScreen
extends Screen {
    private static final ResourceLocation ENCRYPTION_ICONS = new ResourceLocation("nochatreports", "textures/gui/encryption_gui_icons.png");
    private static final Component HEADER = Component.m_237115_((String)"gui.nochatreports.encryption_config.header");
    private static final Component KEY_DESC = Component.m_237115_((String)"gui.nochatreports.encryption_config.key_desc");
    private static final Component PASS_DESC = Component.m_237115_((String)"gui.nochatreports.encryption_config.passphrase_desc");
    private static final Component VALIDATION_OK = Component.m_237115_((String)"gui.nochatreports.encryption_config.validation_ok");
    private static final Component VALIDATION_FAILED = Component.m_237115_((String)"gui.nochatreports.encryption_config.validation_failed");
    private static final Component DICE_TOOLTIP = Component.m_237115_((String)"gui.nochatreports.encryption_config.dice_tooltip");
    private static final Component PASS_NOT_ALLOWED = Component.m_237115_((String)"gui.nochatreports.encryption_config.pass_not_allowed");
    private static final Component ENCRYPT_PUBLIC = Component.m_237115_((String)"gui.nochatreports.encryption_config.encrypt_public");
    private static final int FIELDS_Y_START = 45;
    private final Screen previous;
    private CustomEditBox keyField;
    private CustomEditBox passField;
    private ImageButton validationIcon;
    private CycleButton<Encryption> algorithmButton;
    private MultiLineLabel keyDesc = MultiLineLabel.f_94331_;
    private MultiLineLabel passDesc = MultiLineLabel.f_94331_;
    protected Checkbox encryptPublicCheck;
    private boolean settingPassKey = false;

    public EncryptionConfigScreen(Screen previous) {
        super(CommonComponents.f_237098_);
        this.previous = previous;
    }

    private NCRConfigEncryption getConfig() {
        return NCRConfig.getEncryption();
    }

    protected void m_7856_() {
        CycleButton cycle;
        this.f_96541_.f_91068_.m_90926_(true);
        this.m_169413_();
        super.m_7856_();
        int w = (int)((double)this.f_96543_ * (this.hugeGUI() ? 0.9 : 0.7));
        this.keyDesc = MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)KEY_DESC, (int)(w - 5));
        int keyDescSpace = (this.keyDesc.m_5770_() + 1) * this.getLineHeight();
        this.passDesc = MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)PASS_DESC, (int)(w - 5));
        int passDescSpace = (this.passDesc.m_5770_() + 1) * this.getLineHeight();
        this.keyField = new CustomEditBox(this.f_96547_, (this.f_96543_ - (w -= 52)) / 2 - 2, (this.hugeGUI() ? 25 : 45) + keyDescSpace - 15, w, 18, CommonComponents.f_237098_);
        this.keyField.m_94199_(512);
        this.keyField.m_94151_(this::onKeyUpdate);
        this.m_7787_((GuiEventListener)this.keyField);
        ImageButton button = new ImageButton(this.keyField.f_93620_ + this.keyField.m_5711_() - 15, this.keyField.f_93621_ + 3, 12, 12, 0, 0, 0, ENCRYPTION_ICONS, 64, 64, btn -> {}, (btn, poseStack, i, j) -> this.m_96617_(poseStack, this.f_96541_.f_91062_.m_92923_((FormattedText)(this.validationIcon.f_94225_ == 0 ? VALIDATION_OK : VALIDATION_FAILED), 250), i, j), (Component)Component.m_237119_());
        button.f_93623_ = false;
        button.f_93624_ = true;
        this.validationIcon = button;
        this.m_169394_((Widget)this.validationIcon);
        button = new ImageButton(this.keyField.f_93620_ - 22, this.keyField.f_93621_ - 0, 18, 18, 0, 28, 0, ENCRYPTION_ICONS, 64, 64, btn -> {}, (btn, poseStack, i, j) -> this.m_96617_(poseStack, this.f_96541_.f_91062_.m_92923_((FormattedText)CommonComponents.f_237098_, 250), i, j), (Component)Component.m_237119_());
        button.f_93623_ = false;
        button.f_93624_ = true;
        this.m_169394_((Widget)button);
        button = new ImageButton(this.keyField.f_93620_ + this.keyField.m_5711_() + 4, this.keyField.f_93621_ - 1, 23, 20, 41, 24, 20, ENCRYPTION_ICONS, 64, 64, btn -> {
            this.unfocusFields();
            this.keyField.m_94144_(((Encryption)this.algorithmButton.m_168883_()).getRandomKey());
        }, (btn, poseStack, i, j) -> this.m_96617_(poseStack, this.f_96541_.f_91062_.m_92923_((FormattedText)DICE_TOOLTIP, 250), i, j), (Component)Component.m_237119_());
        button.f_93623_ = true;
        button.f_93624_ = true;
        this.m_142416_((GuiEventListener)button);
        this.passField = new CustomEditBox(this.f_96547_, (this.f_96543_ - (w += 25)) / 2 + 11, this.keyField.f_93621_ + this.keyField.m_93694_() + passDescSpace + (this.hugeGUI() ? -3 : 13), w, 18, CommonComponents.f_237098_);
        this.passField.m_94199_(512);
        this.passField.m_94151_(this::onPassphraseUpdate);
        this.m_7787_((GuiEventListener)this.passField);
        button = new ImageButton(this.passField.f_93620_ - 22, this.passField.f_93621_ - 0, 18, 18, 0, 46, 0, ENCRYPTION_ICONS, 64, 64, btn -> {}, (btn, poseStack, i, j) -> this.m_96617_(poseStack, this.f_96541_.f_91062_.m_92923_((FormattedText)CommonComponents.f_237098_, 250), i, j), (Component)Component.m_237119_());
        button.f_93623_ = false;
        button.f_93624_ = true;
        this.m_169394_((Widget)button);
        int checkWidth = this.f_96547_.m_92852_((FormattedText)ENCRYPT_PUBLIC);
        this.encryptPublicCheck = new Checkbox(this.f_96543_ / 2 - checkWidth / 2 - 8, this.passField.f_93621_ + 24, checkWidth + 24, 20, ENCRYPT_PUBLIC, NCRConfig.getEncryption().shouldEncryptPublic());
        this.m_142416_((GuiEventListener)this.encryptPublicCheck);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 4, this.passField.f_93621_ + 48, 219, 20, CommonComponents.f_130655_, btn -> {
            this.onDone();
            this.m_7379_();
        }));
        this.algorithmButton = cycle = CycleButton.m_168894_(value -> Component.m_237110_((String)"gui.nochatreports.encryption_config.algorithm", (Object[])new Object[]{Component.m_237115_((String)("algorithm.nochatreports." + value.getID() + ".name"))})).m_232502_(Encryption.getRegistered()).m_168929_().m_168948_((Object)this.getConfig().getAlgorithm()).m_232498_(value -> this.f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)("algorithm.nochatreports." + value.getID())), 250)).m_168936_(this.f_96543_ / 2 - 4 - 218, this.passField.f_93621_ + 48, 218, 20, CommonComponents.f_237098_, (cycleButton, value) -> {
            this.unfocusFields();
            this.onAlgorithmUpdate((Encryption)value);
        });
        this.m_142416_((GuiEventListener)this.algorithmButton);
        this.onAlgorithmUpdate((Encryption)this.algorithmButton.m_168883_());
        if (!StringUtil.m_14408_((String)this.getConfig().getEncryptionPassphrase())) {
            this.passField.m_94144_(this.getConfig().getEncryptionPassphrase());
        } else if (!StringUtil.m_14408_((String)this.getConfig().getEncryptionKey())) {
            if (!Objects.equals(this.getConfig().getEncryptionKey(), ((Encryption)this.algorithmButton.m_168883_()).getDefaultKey())) {
                this.keyField.m_94144_(this.getConfig().getEncryptionKey());
            } else {
                this.keyField.m_94144_("");
            }
        }
    }

    public void m_6305_(PoseStack poseStack, int i, int j, float f) {
        if (!this.passField.m_142518_()) {
            if (this.passField.m_93696_()) {
                this.passField.m_93692_(false);
            }
            this.passField.m_94186_(false);
        }
        this.m_7333_(poseStack);
        Screen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)HEADER, (int)(this.f_96543_ / 2), (int)(this.hugeGUI() ? 8 : 16), (int)0xFFFFFF);
        this.keyDesc.m_6516_(poseStack, this.keyField.f_93620_ - 20, this.hugeGUI() ? 25 : 45, this.getLineHeight(), 0xFFFFFF);
        this.keyField.m_6305_(poseStack, i, j, f);
        this.passDesc.m_6516_(poseStack, this.passField.f_93620_ - 20, this.keyField.f_93621_ + this.keyField.m_93694_() + (this.hugeGUI() ? 12 : 28), this.getLineHeight(), 0xFFFFFF);
        this.passField.m_6305_(poseStack, i, j, f);
        if (this.algorithmButton != null && this.algorithmButton.m_5953_((double)i, (double)j)) {
            this.m_96617_(poseStack, this.algorithmButton.m_141932_(), i, j);
        }
        super.m_6305_(poseStack, i, j, f);
        if (StringUtil.m_14408_((String)this.keyField.m_94155_()) && !this.keyField.m_93696_()) {
            Screen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Component.m_237110_((String)"gui.nochatreports.encryption_config.default_key", (Object[])new Object[]{((Encryption)this.algorithmButton.m_168883_()).getDefaultKey()}), (int)(this.keyField.f_93620_ + 4), (int)(this.keyField.f_93621_ + 5), (int)0x999999);
        }
        if (!this.passField.f_93623_) {
            Screen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)PASS_NOT_ALLOWED, (int)(this.passField.f_93620_ + 4), (int)(this.passField.f_93621_ + 5), (int)0x999999);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ENCRYPTION_ICONS);
            RenderSystem.m_69482_();
            EncryptionConfigScreen.m_93133_((PoseStack)poseStack, (int)(this.passField.f_93620_ - 20), (int)(this.passField.f_93621_ + 3), (float)50.0f, (float)0.0f, (int)14, (int)13, (int)64, (int)64);
        }
    }

    private int getLineHeight() {
        if (this.hugeGUI()) {
            Objects.requireNonNull(this.f_96541_.f_91062_);
            return (int)(9.0 * 1.5) + 1;
        }
        Objects.requireNonNull(this.f_96541_.f_91062_);
        return 9 * 2;
    }

    public void m_86600_() {
        this.keyField.m_94120_();
    }

    private void onKeyUpdate(String key) {
        if (!this.settingPassKey) {
            this.passField.m_94144_("");
        }
        this.validationIcon.f_94225_ = !StringUtil.m_14408_((String)key) ? (((Encryption)this.algorithmButton.m_168883_()).validateKey(key) ? 0 : 12) : 0;
    }

    private void onPassphraseUpdate(String pass) {
        Encryption encryption = (Encryption)this.algorithmButton.m_168883_();
        this.settingPassKey = true;
        if (!StringUtil.m_14408_((String)pass)) {
            if (encryption.supportsPassphrases()) {
                this.keyField.m_94144_(encryption.getPassphraseKey(pass));
            }
        } else {
            this.onKeyUpdate(this.keyField.m_94155_());
        }
        this.settingPassKey = false;
    }

    private void onAlgorithmUpdate(Encryption encryption) {
        if (!encryption.supportsPassphrases()) {
            this.passField.m_93692_(false);
            this.passField.f_93623_ = false;
            this.passField.m_94186_(false);
            this.onKeyUpdate(this.keyField.m_94155_());
        } else {
            this.passField.f_93623_ = true;
            this.passField.m_94186_(true);
            this.onPassphraseUpdate(this.passField.m_94155_());
        }
    }

    private void unfocusFields() {
        this.keyField.m_93692_(false);
        this.passField.m_93692_(false);
    }

    private void onDone() {
        NCRConfigEncryption config = NCRConfig.getEncryption();
        Encryption encryption = (Encryption)this.algorithmButton.m_168883_();
        config.setAlgorithm(encryption);
        config.setEncryptionKey(!StringUtil.m_14408_((String)this.keyField.m_94155_()) ? this.keyField.m_94155_() : encryption.getDefaultKey());
        config.setEncryptPublic(this.encryptPublicCheck.m_93840_());
    }

    private boolean hugeGUI() {
        return this.f_96544_ <= 270;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.previous);
    }

    private static class CustomEditBox
    extends EditBox {
        public CustomEditBox(Font font, int i, int j, int k, int l, Component component) {
            super(font, i, j, k, l, component);
        }

        public void m_93692_(boolean bl) {
            super.m_93692_(bl);
        }
    }
}

