/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.mixins.client;

import com.aizistral.nochatreports.NoChatReports;
import com.aizistral.nochatreports.config.NCRConfig;
import com.aizistral.nochatreports.core.ServerSafetyLevel;
import com.aizistral.nochatreports.core.ServerSafetyState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ConnectScreen.class})
public class MixinConnectScreen {
    @Inject(method={"startConnecting"}, at={@At(value="HEAD")})
    private static void onStartConnecting(Screen screen, Minecraft minecraft, ServerAddress serverAddress, @Nullable ServerData serverData, CallbackInfo info) {
        if (!NCRConfig.getClient().enableMod()) {
            return;
        }
        ServerSafetyState.updateCurrent(ServerSafetyLevel.UNDEFINED);
        ServerSafetyState.setLastConnectedServer(serverAddress, serverData);
        if (NCRConfig.getServerWhitelist().isWhitelisted(serverAddress) && !NCRConfig.getClient().doSigningCheck(serverAddress)) {
            ServerSafetyState.setAllowsUnsafeServer(true);
        }
        if (NCRConfig.getCommon().enableDebugLog()) {
            NoChatReports.LOGGER.info("Connecting to: {}, will expose public key: {}", (Object)(serverAddress.m_171863_() + ":" + serverAddress.m_171866_()), (Object)ServerSafetyState.allowsUnsafeServer());
            NoChatReports.LOGGER.info("Server Data IP: {}", (Object)(serverData != null ? serverData.f_105363_ : "null"));
        }
    }
}

