/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.api.forge;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import net.devtech.arrp.api.RRPEvent;
import net.devtech.arrp.api.RRPEventHelper;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.AvailableSince(value="0.8.1")
public class RRPEventHelperImpl<E extends Event>
extends RRPEventHelper {
    public static final RRPEventHelperImpl<RRPEvent.BeforeVanilla> BEFORE_VANILLA = new RRPEventHelperImpl(consumer -> event -> consumer.accept(event));
    public static final RRPEventHelperImpl<RRPEvent.AfterVanilla> AFTER_VANILLA = new RRPEventHelperImpl(consumer -> event -> consumer.accept(event));
    private final Function<Consumer<Event>, Consumer<E>> consumerTransformer;

    public RRPEventHelperImpl(Function<Consumer<Event>, Consumer<E>> consumerTransformer) {
        this.consumerTransformer = consumerTransformer;
    }

    public static RRPEventHelper getBeforeVanilla() {
        return BEFORE_VANILLA;
    }

    public static RRPEventHelper getAfterVanilla() {
        return AFTER_VANILLA;
    }

    @Override
    public void registerPack(RuntimeResourcePack pack) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this.consumerTransformer.apply(event -> ((RRPEvent)((Object)event)).addPack(pack)));
    }

    @Override
    public void registerSidedPack(PackType resourceType, RuntimeResourcePack pack) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this.consumerTransformer.apply(event -> {
            if (((RRPEvent)event).resourceType == resourceType) {
                ((RRPEvent)((Object)event)).addPack(pack);
            }
        }));
    }

    @Override
    public void registerPack(@NotNull Function<PackType, @Nullable RuntimeResourcePack> packFunction) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this.consumerTransformer.apply(event -> {
            RuntimeResourcePack pack = (RuntimeResourcePack)packFunction.apply(((RRPEvent)event).resourceType);
            if (pack != null) {
                ((RRPEvent)((Object)event)).addPack(pack);
            }
        }));
    }

    @Override
    public void registerPacks(@NotNull @NotNull Function<PackType, @NotNull Collection<RuntimeResourcePack>> packsFunction) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this.consumerTransformer.apply(event -> ((RRPEvent)((Object)event)).addPacks((Collection)packsFunction.apply(((RRPEvent)event).resourceType))));
    }
}

