/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.generator;

import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.generator.BlockResourceGenerator;
import net.devtech.arrp.json.blockstate.JBlockStates;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.recipe.JShapedRecipe;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class BRRPFenceGateBlock
extends FenceGateBlock
implements BlockResourceGenerator {
    @Nullable
    public final Block baseBlock;

    public BRRPFenceGateBlock(@Nullable Block baseBlock, BlockBehaviour.Properties settings) {
        super(settings);
        this.baseBlock = baseBlock;
    }

    public BRRPFenceGateBlock(@NotNull Block baseBlock) {
        this(baseBlock, BlockBehaviour.Properties.m_60926_((BlockBehaviour)baseBlock));
    }

    @Override
    @Nullable
    public Block getBaseBlock() {
        return this.baseBlock;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public @UnknownNullability JBlockStates getBlockStates() {
        ResourceLocation blockModelId = this.getBlockModelId();
        return JBlockStates.delegate(BlockModelGenerators.m_124809_((Block)this, (ResourceLocation)blockModelId.brrp_append("_open"), (ResourceLocation)blockModelId, (ResourceLocation)blockModelId.brrp_append("_wall_open"), (ResourceLocation)blockModelId.brrp_append("_wall")));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public @UnknownNullability JModel getBlockModel() {
        return new JModel("block/template_fence_gate").addTexture("texture", this.getTextureId(TextureSlot.f_125868_));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void writeBlockModel(RuntimeResourcePack pack) {
        JModel blockModel = this.getBlockModel();
        ResourceLocation blockModelId = this.getBlockModelId();
        pack.addModel(blockModel, blockModelId);
        pack.addModel(blockModel.parent("block/template_fence_gate_open"), blockModelId.brrp_append("_open"));
        pack.addModel(blockModel.parent("block/template_fence_gate_wall"), blockModelId.brrp_append("_wall"));
        pack.addModel(blockModel.parent("block/template_fence_gate_wall_open"), blockModelId.brrp_append("_wall_open"));
    }

    @Override
    public @UnknownNullability(value="It will be null if the base block is null.") JRecipe getCraftingRecipe() {
        Item secondIngredient = this.getSecondIngredient();
        return this.baseBlock == null || secondIngredient == null ? null : new JShapedRecipe((ItemLike)this).pattern("#W#", "#W#").addKey("W", (ItemLike)this.baseBlock).addKey("#", secondIngredient).addInventoryChangedCriterion("has_ingredient", (ItemLike)this.baseBlock);
    }

    @Nullable
    public Item getSecondIngredient() {
        return Items.f_42398_;
    }
}

