/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.generator;

import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.generator.BlockResourceGenerator;
import net.devtech.arrp.json.blockstate.JBlockStates;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.recipe.JShapedRecipe;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class BRRPWallBlock
extends WallBlock
implements BlockResourceGenerator {
    @Nullable
    public final Block baseBlock;

    public BRRPWallBlock(@Nullable Block baseBlock, BlockBehaviour.Properties settings) {
        super(settings);
        this.baseBlock = baseBlock;
    }

    public BRRPWallBlock(@NotNull Block baseBlock) {
        this(baseBlock, BlockBehaviour.Properties.m_60926_((BlockBehaviour)baseBlock));
    }

    @Override
    @Nullable
    public Block getBaseBlock() {
        return this.baseBlock;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public @UnknownNullability JBlockStates getBlockStates() {
        ResourceLocation blockModelId = this.getBlockModelId();
        return JBlockStates.delegate(BlockModelGenerators.m_124838_((Block)this, (ResourceLocation)blockModelId.brrp_append("_post"), (ResourceLocation)blockModelId.brrp_append("_side"), (ResourceLocation)blockModelId.brrp_append("_side_tall")));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public @UnknownNullability JModel getBlockModel() {
        return new JModel("block/template_wall_post").addTexture("wall", this.getTextureId(TextureSlot.f_125884_));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void writeBlockModel(RuntimeResourcePack pack) {
        ResourceLocation blockModelId = this.getBlockModelId();
        JModel blockModel = this.getBlockModel();
        pack.addModel(blockModel, blockModelId.brrp_append("_post"));
        pack.addModel(blockModel.parent("block/template_wall_side"), blockModelId.brrp_append("_side"));
        pack.addModel(blockModel.parent("block/template_wall_side_tall"), blockModelId.brrp_append("_side_tall"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public @UnknownNullability JModel getItemModel() {
        return new JModel("block/wall_inventory").addTexture("wall", this.getTextureId(TextureSlot.f_125884_));
    }

    @Override
    public @UnknownNullability(value="Null if the base block is null.") JRecipe getCraftingRecipe() {
        return this.baseBlock == null ? null : new JShapedRecipe((ItemLike)this).resultCount(6).pattern("###", "###").addKey("#", (ItemLike)this.baseBlock).addInventoryChangedCriterion("has_ingredient", (ItemLike)this.baseBlock);
    }
}

