/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.blockstate;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.devtech.arrp.annotations.PreferredEnvironment;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.impl.RuntimeResourcePackImpl;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@PreferredEnvironment(value=Dist.CLIENT)
public class JWhenProperties
extends ForwardingMap<String, String>
implements Cloneable,
Condition,
JsonSerializable {
    @NotNull
    public final Map<String, String> properties;

    public JWhenProperties() {
        this(new LinkedHashMap<String, String>());
    }

    public JWhenProperties(@NotNull Map<String, String> properties) {
        this.properties = properties;
    }

    @Contract(value="_, _ -> new", pure=true)
    public static JWhenProperties of(String property, String ... values) {
        return new JWhenProperties().add(property, values);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static JWhenProperties of(String property, StringRepresentable ... values) {
        return new JWhenProperties().add(property, values);
    }

    @SafeVarargs
    @Contract(value="_, _ -> new", pure=true)
    public static <T extends Comparable<T>> JWhenProperties of(Property<T> property, T ... value) {
        return new JWhenProperties().add(property, (T)value);
    }

    @Override
    public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize(this.properties);
    }

    public void m_7619_(StateDefinition<?, ?> stateManager) {
        List<String> list = this.properties.keySet().stream().filter(property -> stateManager.m_61081_(property) != null).toList();
        if (!list.isEmpty()) {
            throw new IllegalStateException("Properties " + list + " are missing from " + stateManager);
        }
    }

    public JsonElement get() {
        return RuntimeResourcePackImpl.GSON.toJsonTree((Object)this);
    }

    @NotNull
    protected Map<String, String> delegate() {
        return this.properties;
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public <T extends Comparable<T>> JWhenProperties add(Property<T> property, T value) {
        return this.add(property.m_61708_(), property.m_6940_(value));
    }

    @SafeVarargs
    @Contract(value="_, _ -> this", mutates="this")
    @CanIgnoreReturnValue
    public final <T extends Comparable<T>> JWhenProperties add(Property<T> property, T ... values) {
        return this.add(property.m_61708_(), Arrays.stream(values).map(arg_0 -> property.m_6940_(arg_0)).collect(Collectors.joining("|")));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _->this", mutates="this")
    public JWhenProperties add(String property, String value) {
        this.properties.put(property, value);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _->this", mutates="this")
    public JWhenProperties addNegated(String property, String value) {
        return this.add(property, "!" + value);
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _->this", mutates="this")
    public JWhenProperties add(String property, StringRepresentable value) {
        return this.add(property, value.m_7912_());
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _->this", mutates="this")
    public JWhenProperties addNegated(String property, StringRepresentable value) {
        return this.add(property, "!" + value.m_7912_());
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _->this", mutates="this")
    public JWhenProperties add(String property, String ... values) {
        return this.add(property, String.join((CharSequence)"|", values));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _->this", mutates="this")
    public JWhenProperties addNegated(String property, String ... values) {
        return this.add(property, "!" + String.join((CharSequence)"|", values));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _->this", mutates="this")
    public JWhenProperties add(String property, StringRepresentable ... values) {
        return this.add(property, Arrays.stream(values).map(StringRepresentable::m_7912_).collect(Collectors.joining("|")));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _->this", mutates="this")
    public JWhenProperties addNegated(String property, StringRepresentable ... values) {
        return this.add(property, "!" + Arrays.stream(values).map(StringRepresentable::m_7912_).collect(Collectors.joining("|")));
    }

    @ApiStatus.AvailableSince(value="0.8.0")
    public JWhenProperties clone() {
        return new JWhenProperties(Maps.newLinkedHashMap(this.properties));
    }
}

