/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.tags;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.devtech.arrp.json.tags.IdentifiedTag;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Contract;

public class JTag {
    public Boolean replace;
    public List<String> values = new ArrayList<String>();

    @Contract(value="_, _ -> new")
    public IdentifiedTag identified(String type, ResourceLocation identifier) {
        IdentifiedTag identifiedTag = new IdentifiedTag(type, identifier);
        identifiedTag.replace = this.replace;
        identifiedTag.values = this.values;
        return identifiedTag;
    }

    @Contract(value="_, _, _ -> new")
    public IdentifiedTag identified(String namespace, String type, String path) {
        IdentifiedTag identifiedTag = new IdentifiedTag(namespace, type, path);
        identifiedTag.replace = this.replace;
        identifiedTag.values = this.values;
        return identifiedTag;
    }

    @Deprecated
    public static JTag replacingTag() {
        return JTag.tag().replace();
    }

    @CanIgnoreReturnValue
    @Contract(value="-> this", mutates="this")
    public JTag replace() {
        this.replace = true;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag replace(boolean replace) {
        this.replace = replace;
        return this;
    }

    @Deprecated
    public static JTag tag() {
        return new JTag();
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag add(String identifier) {
        this.values.add(identifier);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag add(ResourceLocation identifier) {
        this.values.add(identifier.toString());
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag add(ResourceLocation ... identifiers) {
        for (ResourceLocation identifier : identifiers) {
            this.add(identifier);
        }
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addBlock(Block block) {
        this.add(Registry.f_122824_.m_7981_((Object)block));
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addBlocks(Iterable<Block> blocks) {
        blocks.forEach(this::addBlock);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addBlocks(Block ... blocks) {
        return this.addBlocks(Arrays.asList(blocks));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addItem(ItemLike item) {
        this.add(Registry.f_122827_.m_7981_((Object)item.m_5456_()));
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addItems(Iterable<ItemLike> items) {
        items.forEach(this::addItem);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addItems(ItemLike ... items) {
        return this.addItems(Arrays.asList(items));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addFluid(Fluid fluid) {
        this.add(Registry.f_122822_.m_7981_((Object)fluid));
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addFluids(Iterable<Fluid> fluids) {
        fluids.forEach(this::addFluid);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addFluids(Fluid ... fluids) {
        return this.addFluids(Arrays.asList(fluids));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addEntityType(EntityType<?> entityType) {
        this.add(Registry.f_122826_.m_7981_(entityType));
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addEntityTypes(Iterable<EntityType<?>> entityTypes) {
        entityTypes.forEach(this::addEntityType);
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    public JTag addEntityTypes(EntityType<?> ... entityTypes) {
        return this.addEntityTypes(Arrays.asList(entityTypes));
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag tag(ResourceLocation tag) {
        this.values.add("#" + tag.m_135827_() + ":" + tag.m_135815_());
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addTag(ResourceLocation tagIdentifier) {
        this.values.add("#" + tagIdentifier.toString());
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addTagIds(Iterable<ResourceLocation> tagIdentifiers) {
        tagIdentifiers.forEach(this::addTag);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addTagIds(ResourceLocation ... tagIdentifiers) {
        return this.addTagIds(Arrays.asList(tagIdentifiers));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addTag(IdentifiedTag tag) {
        this.values.add("#" + tag.identifier.toString());
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addTags(Iterable<IdentifiedTag> tags) {
        tags.forEach(this::addTag);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JTag addTags(IdentifiedTag ... tags) {
        return this.addTags(Arrays.asList(tags));
    }

    public JTag clone() {
        try {
            return (JTag)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

