/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.net.mca.client.gui.Button;
import forge.net.mca.client.gui.MCAScreens;
import forge.net.mca.client.resources.Icon;
import forge.net.mca.entity.interaction.Constraint;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class AbstractDynamicScreen
extends Screen {
    protected static final float iconScale = 1.5f;
    private String activeScreen = "main";
    private int mouseX;
    private int mouseY;
    private Set<Constraint> constraints = new HashSet<Constraint>();

    protected AbstractDynamicScreen(Component title) {
        super(title);
    }

    public String getActiveScreen() {
        return this.activeScreen;
    }

    public Set<Constraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Set<Constraint> constraints) {
        this.constraints = constraints;
        this.setLayout(this.activeScreen);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6305_(matrices, mouseX, mouseY, delta);
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    protected abstract void buttonPressed(Button var1);

    protected void disableButton(String id) {
        this.m_6702_().forEach(b -> {
            if (b instanceof ButtonEx && ((ButtonEx)((Object)b)).getApiButton().identifier().equals(id)) {
                ((ButtonEx)b).f_93623_ = false;
            }
        });
    }

    protected void enableAllButtons() {
        this.m_6702_().forEach(b -> {
            if (b instanceof AbstractWidget) {
                ((AbstractWidget)b).f_93623_ = true;
            }
        });
    }

    protected void disableAllButtons() {
        this.m_6702_().forEach(b -> {
            if (b instanceof AbstractWidget) {
                if (b instanceof ButtonEx) {
                    if (!((ButtonEx)((Object)b)).getApiButton().identifier().equals("gui.button.backarrow")) {
                        ((AbstractWidget)b).f_93623_ = false;
                    }
                } else {
                    ((AbstractWidget)b).f_93623_ = false;
                }
            }
        });
    }

    public void setLayout(String guiKey) {
        this.activeScreen = guiKey;
        this.m_169413_();
        MCAScreens.getInstance().getScreen(guiKey).ifPresent(buttons -> {
            for (Button b : buttons) {
                this.m_142416_((GuiEventListener)new ButtonEx(b, this));
            }
        });
    }

    protected void drawIcon(PoseStack transform, String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        this.m_93228_(transform, (int)((float)icon.x() / 1.5f), (int)((float)icon.y() / 1.5f), icon.u(), icon.v(), 16, 16);
    }

    protected void drawHoveringIconText(PoseStack transform, Component text, String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        this.m_96602_(transform, text, icon.x() + 16, icon.y() + 20);
    }

    protected void drawHoveringIconText(PoseStack transform, List<Component> text, String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        this.m_96597_(transform, text, icon.x() + 16, icon.y() + 20);
    }

    protected boolean hoveringOverIcon(String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        return this.hoveringOver(icon.x(), icon.y(), 24, 24);
    }

    protected boolean hoveringOver(int x, int y, int w, int h) {
        return this.mouseX > x && this.mouseX < x + w && this.mouseY > y && this.mouseY < y + h;
    }

    private static class ButtonEx
    extends net.minecraft.client.gui.components.Button {
        private final Button apiButton;

        public ButtonEx(Button apiButton, AbstractDynamicScreen screen) {
            super((int)((float)screen.f_96543_ * Alignment.alignments.get((Object)apiButton.align()).h + (float)apiButton.x()), (int)((float)screen.f_96544_ * Alignment.alignments.get((Object)apiButton.align()).v + (float)apiButton.y()), apiButton.width(), apiButton.height(), (Component)Component.m_237115_((String)apiButton.identifier()), a -> screen.buttonPressed(apiButton));
            this.apiButton = apiButton;
            if (!apiButton.isValidForConstraint(screen.getConstraints())) {
                if (apiButton.hideOnFail()) {
                    this.f_93624_ = false;
                }
                this.f_93623_ = false;
            }
        }

        public Button getApiButton() {
            return this.apiButton;
        }
    }

    private static enum Alignment {
        TOP_LEFT(0.0f, 0.0f),
        TOP(0.5f, 0.0f),
        TOP_RIGHT(1.0f, 0.0f),
        RIGHT(1.0f, 0.5f),
        BOTTOM_RIGHT(1.0f, 1.0f),
        BOTTOM(0.5f, 1.0f),
        BOTTOM_LEFT(0.0f, 1.0f),
        LEFT(0.0f, 0.5f),
        CENTER(0.5f, 0.5f);

        final float h;
        final float v;
        static final Map<String, Alignment> alignments;

        private Alignment(float h, float v) {
            this.h = h;
            this.v = v;
        }

        static {
            alignments = new HashMap<String, Alignment>();
            for (Alignment a : Alignment.values()) {
                alignments.put(a.name().toLowerCase(Locale.ENGLISH), a);
            }
        }
    }
}

