/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data.villageComponents;

import forge.net.mca.Config;
import forge.net.mca.resources.Rank;
import forge.net.mca.resources.Tasks;
import forge.net.mca.server.world.data.Village;
import forge.net.mca.util.WorldUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class VillageTaxesManager {
    private static final int MAX_STORAGE_SIZE = 1024;
    private final Village village;

    public VillageTaxesManager(Village village) {
        this.village = village;
    }

    public void taxes(ServerLevel world) {
        MutableComponent msg;
        double taxes = (double)(Config.getInstance().taxesFactor * (float)this.village.getPopulation() * this.village.getTaxes()) + world.f_46441_.m_188500_();
        int moodImpact = 0;
        float r = this.village.getTaxes() + (world.f_46441_.m_188501_() - 0.5f) * world.f_46441_.m_188501_();
        if (this.village.getTaxes() == 0.0f) {
            msg = Component.m_237110_((String)"gui.village.taxes.no", (Object[])new Object[]{this.village.getName()}).m_130940_(ChatFormatting.GREEN);
            moodImpact = 5;
            taxes = 0.0;
        } else if ((double)r < 0.1) {
            msg = Component.m_237110_((String)"gui.village.taxes.more", (Object[])new Object[]{this.village.getName()}).m_130940_(ChatFormatting.GREEN);
            taxes += (double)this.village.getPopulation() * 0.25;
        } else if ((double)r < 0.3) {
            msg = Component.m_237110_((String)"gui.village.taxes.happy", (Object[])new Object[]{this.village.getName()}).m_130940_(ChatFormatting.DARK_GREEN);
            moodImpact = 5;
        } else if ((double)r < 0.7) {
            msg = Component.m_237110_((String)"gui.village.taxes", (Object[])new Object[]{this.village.getName()});
        } else if ((double)r < 0.8) {
            msg = Component.m_237110_((String)"gui.village.taxes.sad", (Object[])new Object[]{this.village.getName()}).m_130940_(ChatFormatting.GOLD);
            moodImpact = -5;
        } else if ((double)r < 0.9) {
            msg = Component.m_237110_((String)"gui.village.taxes.angry", (Object[])new Object[]{this.village.getName()}).m_130940_(ChatFormatting.RED);
            moodImpact = -10;
        } else {
            msg = Component.m_237110_((String)"gui.village.taxes.riot", (Object[])new Object[]{this.village.getName()}).m_130940_(ChatFormatting.DARK_RED);
            taxes = 0.0;
        }
        world.m_6907_().stream().filter(v -> Tasks.getRank(this.village, v).isAtLeast(Rank.MERCHANT)).forEach(arg_0 -> VillageTaxesManager.lambda$taxes$1((Component)msg, arg_0));
        if (this.village.hasBuilding("library")) {
            taxes *= 1.5;
        }
        while (taxes > 0.0) {
            double finalTaxes = taxes;
            List<String> valids = Config.getInstance().taxesMap.entrySet().stream().filter(e -> (double)(((Float)e.getValue()).floatValue() * world.f_46441_.m_188501_()) < finalTaxes).map(Map.Entry::getKey).toList();
            if (valids.isEmpty()) break;
            String itemName = valids.get(world.f_46441_.m_188503_(valids.size()));
            Item item = (Item)Registry.f_122827_.m_7745_(new ResourceLocation(itemName));
            if (item == Items.f_41852_) {
                throw new RuntimeException("The taxes map contains an invalid item %s!".formatted(itemName));
            }
            taxes -= (double)Config.getInstance().taxesMap.get(itemName).floatValue();
            Optional<ItemStack> stack = this.village.storageBuffer.stream().filter(i -> i.m_150930_(item) && i.m_41613_() < i.m_41741_()).findAny();
            if (stack.isPresent()) {
                stack.get().m_41769_(1);
                continue;
            }
            if (this.village.storageBuffer.size() >= 1024) continue;
            this.village.storageBuffer.add(new ItemStack((ItemLike)item, 1));
        }
        if (moodImpact != 0) {
            this.village.pushMood(moodImpact * this.village.getPopulation());
        }
        this.deliverTaxes(world);
    }

    public void deliverTaxes(ServerLevel world) {
        if (this.village.hasStoredResource() && WorldUtils.isChunkLoaded((Level)world, this.village.getCenter())) {
            this.village.getBuildingsOfType("storage").forEach(building -> building.getBlocks().values().stream().flatMap(Collection::stream).forEach(p -> {
                if (this.village.hasStoredResource()) {
                    this.tryToPutIntoInventory(world, (BlockPos)p);
                }
            }));
        }
    }

    private void tryToPutIntoInventory(ServerLevel world, BlockPos p) {
        BlockEntity blockEntity;
        BlockState state = world.m_8055_(p);
        if (state.m_155947_() && (blockEntity = world.m_7702_(p)) instanceof Container) {
            ChestBlock chest;
            Container inventory = (Container)blockEntity;
            Block block = state.m_60734_();
            if (inventory instanceof ChestBlockEntity && block instanceof ChestBlock && (inventory = ChestBlock.m_51511_((ChestBlock)(chest = (ChestBlock)block), (BlockState)state, (Level)world, (BlockPos)p, (boolean)true)) != null) {
                this.putIntoInventory(inventory);
            }
        }
    }

    private void putIntoInventory(Container inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            boolean changes = true;
            while (changes) {
                changes = false;
                ItemStack stack = inventory.m_8020_(i);
                ItemStack tax = this.village.storageBuffer.get(0);
                if (stack.m_41720_() == tax.m_41720_()) {
                    int diff = Math.min(tax.m_41613_(), stack.m_41741_() - stack.m_41613_());
                    if (diff > 0) {
                        stack.m_41769_(diff);
                        tax.m_41774_(diff);
                        if (tax.m_41619_()) {
                            this.village.storageBuffer.remove(0);
                            changes = true;
                        }
                        inventory.m_6596_();
                    }
                } else if (stack.m_41619_()) {
                    inventory.m_6836_(i, tax);
                    inventory.m_6596_();
                    this.village.storageBuffer.remove(0);
                    changes = true;
                }
                if (this.village.hasStoredResource()) continue;
                return;
            }
        }
    }

    private static /* synthetic */ void lambda$taxes$1(Component msg, ServerPlayer player) {
        player.m_5661_(msg, true);
    }
}

