/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import quilt.net.mca.MCA;
import quilt.net.mca.client.gui.AbstractDynamicScreen;
import quilt.net.mca.client.gui.Button;
import quilt.net.mca.client.gui.FamilyTreeScreen;
import quilt.net.mca.cobalt.network.NetworkHandler;
import quilt.net.mca.entity.VillagerLike;
import quilt.net.mca.entity.ai.Genetics;
import quilt.net.mca.entity.ai.Memories;
import quilt.net.mca.entity.ai.Traits;
import quilt.net.mca.entity.ai.brain.VillagerBrain;
import quilt.net.mca.entity.ai.relationship.CompassionateEntity;
import quilt.net.mca.entity.ai.relationship.RelationshipState;
import quilt.net.mca.network.c2s.GetInteractDataRequest;
import quilt.net.mca.network.c2s.InteractionCloseRequest;
import quilt.net.mca.network.c2s.InteractionDialogueInitMessage;
import quilt.net.mca.network.c2s.InteractionDialogueMessage;
import quilt.net.mca.network.c2s.InteractionVillagerMessage;
import quilt.net.mca.resources.data.analysis.Analysis;
import quilt.net.mca.resources.data.dialogue.Question;

public class InteractScreen
extends AbstractDynamicScreen {
    public static final class_2960 ICON_TEXTURES = MCA.locate("textures/gui.png");
    private final VillagerLike<?> villager;
    private final class_1657 player;
    private boolean inGiftMode;
    private int timeSinceLastClick;
    private String father;
    private String mother;
    private RelationshipState marriageState;
    private class_2561 spouse;
    private List<String> dialogAnswers;
    private String dialogAnswerHover;
    private List<class_5481> dialogQuestionText;
    private String dialogQuestionId;
    private static Analysis<?> analysis;

    public InteractScreen(VillagerLike<?> villager) {
        super((class_2561)class_2561.method_43470((String)"Interact"));
        this.player = (class_1657)Objects.requireNonNull(class_310.method_1551().field_1724);
        this.villager = villager;
    }

    public void setParents(String father, String mother) {
        this.father = father;
        this.mother = mother;
    }

    public void setSpouse(RelationshipState marriageState, String spouse) {
        this.marriageState = marriageState;
        this.spouse = spouse == null ? class_2561.method_43471((String)"gui.interact.label.parentUnknown") : class_2561.method_43470((String)spouse);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        Objects.requireNonNull(this.field_22787).method_1507(null);
        NetworkHandler.sendToServer(new InteractionCloseRequest(this.villager.asEntity().method_5667()));
    }

    public void method_25426() {
        NetworkHandler.sendToServer(new GetInteractDataRequest(this.villager.asEntity().method_5667()));
    }

    public void method_25393() {
        ++this.timeSinceLastClick;
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float tickDelta) {
        super.method_25394(matrices, mouseX, mouseY, tickDelta);
        this.drawIcons(matrices);
        this.drawTextPopups(matrices);
    }

    public boolean method_25401(double x, double y, double d) {
        if (d < 0.0) {
            this.player.method_31548().field_7545 = this.player.method_31548().field_7545 == 8 ? 0 : this.player.method_31548().field_7545 + 1;
        } else if (d > 0.0) {
            this.player.method_31548().field_7545 = this.player.method_31548().field_7545 == 0 ? 8 : this.player.method_31548().field_7545 - 1;
        }
        return super.method_25401(x, y, d);
    }

    public boolean method_25402(double posX, double posY, int button) {
        super.method_25402(posX, posY, button);
        if (button == 0 && this.dialogAnswerHover != null && this.dialogQuestionText != null) {
            NetworkHandler.sendToServer(new InteractionDialogueMessage(this.villager.asEntity().method_5667(), this.dialogQuestionId, this.dialogAnswerHover));
        }
        if (this.inGiftMode && button == 1) {
            NetworkHandler.sendToServer(new InteractionVillagerMessage("gui.button.gift", this.villager.asEntity().method_5667()));
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyChar, int keyCode, int unknown) {
        if (keyChar == 256) {
            if (this.inGiftMode) {
                this.inGiftMode = false;
                this.setLayout("interact");
            } else {
                this.method_25419();
            }
            return true;
        }
        return false;
    }

    private void drawIcons(class_4587 transform) {
        Memories memory = this.villager.getVillagerBrain().getMemoriesForPlayer(this.player);
        transform.method_22903();
        transform.method_22905(1.5f, 1.5f, 1.5f);
        RenderSystem.setShaderTexture((int)0, (class_2960)ICON_TEXTURES);
        if (this.marriageState != null) {
            this.drawIcon(transform, this.marriageState.getIcon());
        }
        this.drawIcon(transform, memory.getHearts() < 0 ? "blackHeart" : (memory.getHearts() >= 100 ? "goldHeart" : "redHeart"));
        this.drawIcon(transform, "genes");
        if (this.canDrawParentsIcon()) {
            this.drawIcon(transform, "parents");
        }
        if (this.canDrawGiftIcon()) {
            this.drawIcon(transform, "gift");
        }
        if (analysis != null) {
            this.drawIcon(transform, "analysis");
        }
        transform.method_22909();
    }

    private void drawTextPopups(class_4587 transform) {
        int h = 17;
        if (this.inGiftMode) {
            this.method_25424(transform, (class_2561)class_2561.method_43471((String)"gui.interact.label.giveGift"), 10, 28);
        } else {
            this.method_25424(transform, this.villager.asEntity().method_5477(), 10, 28);
        }
        this.method_25424(transform, (class_2561)(this.villager.asEntity().method_6109() ? this.villager.getAgeState().getName() : this.villager.getProfessionText()), 10, 30 + h);
        VillagerBrain<?> brain = this.villager.getVillagerBrain();
        this.method_25424(transform, (class_2561)class_2561.method_43469((String)"gui.interact.label.mood", (Object[])new Object[]{brain.getMood().getText()}).method_27692(brain.getMood().getColor()), 10, 30 + h * 2);
        if (this.hoveringOverText(10, 30 + h * 3, 128)) {
            this.method_25424(transform, brain.getPersonality().getDescription(), 10, 30 + h * 3);
        } else {
            this.method_25424(transform, (class_2561)class_2561.method_43469((String)"gui.interact.label.personality", (Object[])new Object[]{brain.getPersonality().getName()}).method_27692(class_124.field_1068), 10, 30 + h * 3);
        }
        Set<Traits.Trait> traits = this.villager.getTraits().getTraits();
        if (traits.size() > 0) {
            if (this.hoveringOverText(10, 30 + h * 4, 128)) {
                traitText = traits.stream().map(Traits.Trait::getDescription).collect(Collectors.toList());
                traitText.add(0, class_2561.method_43471((String)"traits.title"));
                this.method_30901(transform, (List)traitText, 10, 30 + h * 4);
            } else {
                traitText = class_2561.method_43471((String)"traits.title");
                traits.stream().map(Traits.Trait::getName).forEach(arg_0 -> InteractScreen.lambda$drawTextPopups$0((class_5250)traitText, arg_0));
                this.method_25424(transform, (class_2561)traitText, 10, 30 + h * 4);
            }
        }
        if (this.hoveringOverIcon("redHeart")) {
            int hearts = brain.getMemoriesForPlayer(this.player).getHearts();
            this.drawHoveringIconText(transform, (class_2561)class_2561.method_43470((String)(hearts + " hearts")), "redHeart");
        }
        if (this.marriageState != null && this.hoveringOverIcon("married") && this.villager instanceof CompassionateEntity) {
            String ms = this.marriageState.base().getIcon().toLowerCase(Locale.ENGLISH);
            this.drawHoveringIconText(transform, (class_2561)class_2561.method_43469((String)("gui.interact.label." + ms), (Object[])new Object[]{this.spouse}), "married");
        }
        if (this.canDrawParentsIcon() && this.hoveringOverIcon("parents")) {
            this.drawHoveringIconText(transform, (class_2561)class_2561.method_43469((String)"gui.interact.label.parents", (Object[])new Object[]{this.father == null ? class_2561.method_43471((String)"gui.interact.label.parentUnknown") : this.father, this.mother == null ? class_2561.method_43471((String)"gui.interact.label.parentUnknown") : this.mother}), "parents");
        }
        if (this.canDrawGiftIcon() && this.hoveringOverIcon("gift")) {
            this.drawHoveringIconText(transform, (class_2561)class_2561.method_43471((String)"gui.interact.label.gift"), "gift");
        }
        if (this.hoveringOverIcon("genes")) {
            LinkedList<class_2561> lines = new LinkedList<class_2561>();
            lines.add((class_2561)class_2561.method_43470((String)"Genes"));
            for (Genetics.Gene gene : this.villager.getGenetics()) {
                String key = gene.getType().getTranslationKey();
                int value = (int)(gene.get() * 100.0f);
                lines.add((class_2561)class_2561.method_43469((String)"gene.tooltip", (Object[])new Object[]{class_2561.method_43471((String)key), value}));
            }
            this.drawHoveringIconText(transform, lines, "genes");
        }
        if (this.hoveringOverIcon("analysis") && analysis != null) {
            LinkedList<class_2561> lines = new LinkedList<class_2561>();
            lines.add((class_2561)class_2561.method_43471((String)"analysis.title").method_27692(class_124.field_1080));
            for (Analysis.AnalysisElement d : analysis) {
                lines.add((class_2561)class_2561.method_43471((String)("analysis." + d.getKey())).method_10852((class_2561)class_2561.method_43470((String)(": " + (d.isPositive() ? "+" : "") + d.getValue()))).method_27692(d.isPositive() ? class_124.field_1060 : class_124.field_1061));
            }
            String chance = analysis.getTotalAsString();
            lines.add((class_2561)class_2561.method_43471((String)"analysis.total").method_27693(": " + (String)chance));
            this.drawHoveringIconText(transform, lines, "analysis");
        }
        if (this.dialogQuestionText != null) {
            InteractScreen.method_25294((class_4587)transform, (int)(this.field_22789 / 2 - 85), (int)(this.field_22790 / 2 - 50 - 10 * this.dialogQuestionText.size()), (int)(this.field_22789 / 2 + 85), (int)(this.field_22790 / 2 - 30 + 10 * this.dialogAnswers.size()), (int)0x77000000);
            int i = -this.dialogQuestionText.size();
            for (class_5481 t : this.dialogQuestionText) {
                this.field_22793.method_27517(transform, t, (float)this.field_22789 / 2.0f - (float)this.field_22793.method_30880(t) / 2.0f, (float)this.field_22790 / 2.0f - 50.0f + (float)(++i * 10), -1);
            }
            this.dialogAnswerHover = null;
            this.method_25292(transform, this.field_22789 / 2 - 75, this.field_22789 / 2 + 75, this.field_22790 / 2 - 40, -1426063361);
            int y = this.field_22790 / 2 - 35;
            for (String a : this.dialogAnswers) {
                boolean hover = this.hoveringOver(this.field_22789 / 2 - 100, y - 3, 200, 10);
                InteractScreen.method_27534((class_4587)transform, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)Question.getTranslationKey(this.dialogQuestionId, a)), (int)(this.field_22789 / 2), (int)y, (int)(hover ? -2631804 : -1426063361));
                if (hover) {
                    this.dialogAnswerHover = a;
                }
                y += 10;
            }
        }
    }

    private boolean hoveringOverText(int x, int y, int w) {
        return this.hoveringOver(x + 8, y - 16, w, 16);
    }

    private boolean canDrawParentsIcon() {
        return this.father != null || this.mother != null;
    }

    private boolean canDrawGiftIcon() {
        return false;
    }

    public void setDialogue(String dialogue, List<String> answers) {
        this.dialogQuestionId = dialogue;
        this.dialogAnswers = answers;
    }

    public void setLastPhrase(class_5250 questionText, boolean silent) {
        class_5250 text = !silent ? this.villager.sendChatMessage(questionText, (class_1297)this.player) : this.villager.transformMessage(questionText);
        this.dialogQuestionText = this.field_22793.method_1728((class_5348)text, 160);
    }

    @Override
    protected void buttonPressed(Button button) {
        String id = button.identifier();
        if (this.timeSinceLastClick <= 2) {
            return;
        }
        this.timeSinceLastClick = 0;
        if (id.equals("gui.button.interact")) {
            this.setLayout("interact");
        } else if (id.equals("gui.button.command")) {
            this.setLayout("command");
            this.disableButton("gui.button." + this.villager.getVillagerBrain().getMoveState().name().toLowerCase(Locale.ENGLISH));
        } else if (id.equals("gui.button.clothing")) {
            this.setLayout("clothing");
        } else if (id.equals("gui.button.familyTree")) {
            class_310.method_1551().method_1507((class_437)new FamilyTreeScreen(this.villager.asEntity().method_5667()));
        } else if (id.equals("gui.button.talk")) {
            this.method_37067();
            NetworkHandler.sendToServer(new InteractionDialogueInitMessage(this.villager.asEntity().method_5667()));
        } else if (id.equals("gui.button.work")) {
            this.setLayout("work");
            this.disableButton("gui.button." + this.villager.getVillagerBrain().getCurrentJob().name().toLowerCase(Locale.ENGLISH));
        } else if (id.equals("gui.button.professions")) {
            this.setLayout("professions");
        } else if (id.equals("gui.button.backarrow")) {
            if (this.inGiftMode) {
                this.inGiftMode = false;
                this.setLayout("interact");
            } else if (this.getActiveScreen().equals("locations")) {
                this.setLayout("interact");
            } else {
                this.setLayout("main");
            }
        } else if (id.equals("gui.button.locations")) {
            this.setLayout("locations");
        } else if (button.notifyServer()) {
            if (!button.targetServer()) {
                NetworkHandler.sendToServer(new InteractionVillagerMessage(id, this.villager.asEntity().method_5667()));
            }
        } else if (id.equals("gui.button.gift")) {
            this.inGiftMode = true;
            this.disableAllButtons();
        }
    }

    public static void setAnalysis(Analysis<?> analysis) {
        InteractScreen.analysis = analysis;
    }

    private static /* synthetic */ void lambda$drawTextPopups$0(class_5250 traitText, class_2561 t) {
        if (traitText.method_10855().size() > 0) {
            traitText.method_10852((class_2561)class_2561.method_43470((String)", "));
        }
        traitText.method_10852(t);
    }
}

