/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1314;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5532;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.ai.MemoryModuleTypeMCA;

public class ExtendedWalkTowardsTask
extends class_4097<VillagerEntityMCA> {
    private final class_4140<class_4208> destination;
    private final float speed;
    private final int completionRange;
    private final int maxRange;
    private final int maxRunTime;
    private static final long GAVE_UP_COOLDOWN = 1200L;
    private final Predicate<VillagerEntityMCA> canGiveUp;
    private final Consumer<VillagerEntityMCA> onGiveUp;

    public ExtendedWalkTowardsTask(class_4140<class_4208> destination, float speed, int completionRange, int maxRange, int maxRunTime, Predicate<VillagerEntityMCA> canGiveUp, Consumer<VillagerEntityMCA> onGiveUp) {
        super((Map)ImmutableMap.of((Object)class_4140.field_19293, (Object)class_4141.field_18458, (Object)class_4140.field_18445, (Object)class_4141.field_18457, destination, (Object)class_4141.field_18456));
        this.destination = destination;
        this.speed = speed;
        this.completionRange = completionRange;
        this.maxRange = maxRange;
        this.maxRunTime = maxRunTime;
        this.canGiveUp = canGiveUp;
        this.onGiveUp = onGiveUp;
    }

    protected boolean shouldRun(class_3218 world, VillagerEntityMCA villager) {
        boolean b = this.stillPissed(world, villager);
        return !b;
    }

    private void giveUp(VillagerEntityMCA villager, long time) {
        class_4095 brain = villager.method_18868();
        if (this.canGiveUp.test(villager)) {
            villager.method_19176(this.destination);
            brain.method_18875(this.destination);
            brain.method_18878(class_4140.field_19293, (Object)time);
            this.onGiveUp.accept(villager);
        } else {
            brain.method_18878((class_4140)MemoryModuleTypeMCA.LAST_CANT_FIND_HOME_PISSED_MOMENT.get(), (Object)time);
            brain.method_18878(class_4140.field_19293, (Object)time);
        }
    }

    protected void run(class_3218 serverWorld, VillagerEntityMCA villager, long time) {
        class_4095 brain = villager.method_18868();
        brain.method_18904(this.destination).ifPresent(pos -> {
            if (!this.dimensionMismatches(serverWorld, (class_4208)pos) && !this.shouldGiveUp(serverWorld, villager)) {
                if (this.exceedsMaxRange(villager, (class_4208)pos)) {
                    int attempt;
                    class_243 vec3d = null;
                    for (attempt = 0; attempt < 1000 && (vec3d == null || this.exceedsMaxRange(villager, class_4208.method_19443((class_5321)serverWorld.method_27983(), (class_2338)new class_2338(vec3d)))); ++attempt) {
                        vec3d = class_5532.method_31512((class_1314)villager, (int)15, (int)7, (class_243)class_243.method_24955((class_2382)pos.method_19446()), (double)1.5707963705062866);
                    }
                    if (attempt == 1000) {
                        this.giveUp(villager, time);
                        return;
                    }
                    assert (vec3d != null);
                    brain.method_18878(class_4140.field_18445, (Object)new class_4142(vec3d, this.speed, this.completionRange));
                } else if (!this.reachedDestination(serverWorld, villager, (class_4208)pos)) {
                    brain.method_18878(class_4140.field_18445, (Object)new class_4142(pos.method_19446(), this.speed, this.completionRange));
                }
            } else {
                this.giveUp(villager, time);
            }
        });
    }

    private boolean shouldGiveUp(class_3218 world, VillagerEntityMCA villager) {
        Optional optional = villager.method_18868().method_18904(class_4140.field_19293);
        return optional.filter(aLong -> world.method_8510() - aLong > (long)this.maxRunTime).isPresent();
    }

    private boolean stillPissed(class_3218 world, VillagerEntityMCA villager) {
        Optional optional = villager.method_18868().method_18904((class_4140)MemoryModuleTypeMCA.LAST_CANT_FIND_HOME_PISSED_MOMENT.get());
        return optional.filter(aLong -> world.method_8510() - aLong < 1200L).isPresent();
    }

    private boolean exceedsMaxRange(VillagerEntityMCA villager, class_4208 pos) {
        return pos.method_19446().method_19455((class_2382)villager.method_24515()) > this.maxRange;
    }

    private boolean dimensionMismatches(class_3218 world, class_4208 pos) {
        return pos.method_19442() != world.method_27983();
    }

    private boolean reachedDestination(class_3218 world, VillagerEntityMCA villager, class_4208 pos) {
        return pos.method_19442() == world.method_27983() && pos.method_19446().method_19455((class_2382)villager.method_24515()) <= this.completionRange;
    }
}

