/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_3852;
import net.minecraft.class_4309;
import org.jetbrains.annotations.Nullable;
import quilt.net.mca.Config;
import quilt.net.mca.MCA;
import quilt.net.mca.entity.VillagerLike;
import quilt.net.mca.entity.ai.relationship.AgeState;
import quilt.net.mca.entity.ai.relationship.Gender;
import quilt.net.mca.resources.Resources;
import quilt.net.mca.resources.WeightedPool;
import quilt.net.mca.resources.data.skin.Clothing;
import quilt.net.mca.server.world.data.CustomClothingManager;

public class ClothingList
extends class_4309 {
    protected static final class_2960 ID = MCA.locate("skins/clothing");
    public final HashMap<String, Clothing> clothing = new HashMap();
    private static ClothingList INSTANCE;

    public static ClothingList getInstance() {
        return INSTANCE;
    }

    public ClothingList() {
        super(Resources.GSON, "skins/clothing");
        INSTANCE = this;
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        this.clothing.clear();
        data.forEach((id, file) -> {
            Gender gender = Gender.byName(id.method_12832().split("\\.")[0]);
            if (gender == Gender.UNASSIGNED) {
                MCA.LOGGER.warn("Invalid gender for clothing pool: {}", id);
                return;
            }
            for (String key : file.getAsJsonObject().keySet()) {
                JsonObject object = file.getAsJsonObject().get(key).getAsJsonObject();
                for (int i = 0; i < class_3518.method_15282((JsonObject)object, (String)"count", (int)1); ++i) {
                    String identifier = String.format(key, i);
                    Clothing c = new Clothing(identifier, object);
                    c.gender = gender;
                    if (this.clothing.containsKey(identifier) && object.has("count")) continue;
                    this.clothing.put(identifier, c);
                }
            }
        });
    }

    public WeightedPool<String> getPool(VillagerLike<?> villager) {
        Gender gender = villager.getGenetics().getGender();
        return switch (villager.getAgeState()) {
            case AgeState.BABY -> this.getPool(gender, MCA.locate("baby").toString());
            case AgeState.TODDLER -> this.getPool(gender, MCA.locate("toddler").toString());
            case AgeState.CHILD, AgeState.TEEN -> this.getPool(gender, MCA.locate("child").toString());
            default -> {
                WeightedPool<String> pool = this.getPool(gender, villager.method_7231().method_16924());
                if (pool.entries.size() == 0) {
                    pool = this.getPool(gender, class_3852.field_17051);
                }
                yield pool;
            }
        };
    }

    public WeightedPool<String> getPool(Gender gender, @Nullable class_3852 profession) {
        Map<String, String> map = Config.getInstance().professionConversionsMap;
        String currentValue = profession == null ? "minecraft:none" : class_2378.field_17167.method_10221((Object)profession).toString();
        String identifier = map.getOrDefault(currentValue, map.getOrDefault("default", currentValue));
        return this.getPool(gender, identifier);
    }

    public WeightedPool<String> getPool(Gender gender, @Nullable String profession) {
        return Stream.concat(this.clothing.values().stream(), CustomClothingManager.getClothing().getEntries().values().stream()).filter(c -> c.gender == Gender.NEUTRAL || gender == Gender.NEUTRAL || c.gender == gender).filter(c -> c.profession == null || profession == null && !c.exclude || c.profession.equals(profession)).collect(() -> new WeightedPool.Mutable<String>("mca:missing"), (list, entry) -> list.add(entry.identifier, entry.chance), (a, b) -> a.entries.addAll(b.entries));
    }
}

