/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMPopup;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;

public class WindowSizePopup
extends FMPopup {
    private ActionType type;
    private LayoutEditorScreen parent;
    private AdvancedButton cancelButton;
    private AdvancedButton doneButton;
    private AdvancedTextField widthText;
    private AdvancedTextField heightText;

    public WindowSizePopup(LayoutEditorScreen parent, ActionType type) {
        super(240);
        this.type = type;
        this.parent = parent;
        this.cancelButton = new AdvancedButton(0, 0, 80, 20, Locals.localize((String)"popup.yesno.cancel", (String[])new String[0]), true, press -> this.setDisplayed(false));
        this.addButton(this.cancelButton);
        this.doneButton = new AdvancedButton(0, 0, 80, 20, Locals.localize((String)"popup.done", (String[])new String[0]), true, press -> this.onDoneButtonPressed());
        this.addButton(this.doneButton);
        this.widthText = new AdvancedTextField(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler());
        if (type == ActionType.BIGGERTHAN) {
            this.widthText.m_94144_("" + parent.biggerThanWidth);
        } else {
            this.widthText.m_94144_("" + parent.smallerThanWidth);
        }
        this.heightText = new AdvancedTextField(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler());
        if (type == ActionType.BIGGERTHAN) {
            this.heightText.m_94144_("" + parent.biggerThanHeight);
        } else {
            this.heightText.m_94144_("" + parent.smallerThanHeight);
        }
        KeyboardHandler.addKeyPressedListener(this::onEnterPressed);
        KeyboardHandler.addKeyPressedListener(this::onEscapePressed);
    }

    public void render(PoseStack matrix, int mouseX, int mouseY, Screen renderIn) {
        super.render(matrix, mouseX, mouseY, renderIn);
        float partial = Minecraft.m_91087_().m_91296_();
        Font font = Minecraft.m_91087_().f_91062_;
        if (this.type == ActionType.BIGGERTHAN) {
            GuiComponent.m_93208_((PoseStack)matrix, (Font)font, (String)("\u00a7l" + Locals.localize((String)"helper.creator.windowsize.biggerthan.desc", (String[])new String[0])), (int)(renderIn.f_96543_ / 2), (int)(renderIn.f_96544_ / 2 - 110), (int)Color.WHITE.getRGB());
        } else {
            GuiComponent.m_93208_((PoseStack)matrix, (Font)font, (String)("\u00a7l" + Locals.localize((String)"helper.creator.windowsize.smallerthan.desc", (String[])new String[0])), (int)(renderIn.f_96543_ / 2), (int)(renderIn.f_96544_ / 2 - 110), (int)Color.WHITE.getRGB());
        }
        GuiComponent.m_93208_((PoseStack)matrix, (Font)font, (String)Locals.localize((String)"general.width", (String[])new String[0]), (int)(renderIn.f_96543_ / 2), (int)(renderIn.f_96544_ / 2 - 80), (int)Color.WHITE.getRGB());
        this.widthText.f_93620_ = renderIn.f_96543_ / 2 - this.widthText.m_5711_() / 2;
        this.widthText.f_93621_ = renderIn.f_96544_ / 2 - 65;
        this.widthText.m_6305_(matrix, mouseX, mouseY, partial);
        GuiComponent.m_93208_((PoseStack)matrix, (Font)font, (String)Locals.localize((String)"general.height", (String[])new String[0]), (int)(renderIn.f_96543_ / 2), (int)(renderIn.f_96544_ / 2 - 37), (int)Color.WHITE.getRGB());
        this.heightText.f_93620_ = renderIn.f_96543_ / 2 - this.heightText.m_5711_() / 2;
        this.heightText.f_93621_ = renderIn.f_96544_ / 2 - 22;
        this.heightText.m_6305_(matrix, mouseX, mouseY, partial);
        GuiComponent.m_93208_((PoseStack)matrix, (Font)font, (String)(Locals.localize((String)"helper.creator.windowsize.currentwidth", (String[])new String[0]) + ": " + Minecraft.m_91087_().m_91268_().m_85443_()), (int)(renderIn.f_96543_ / 2), (int)(renderIn.f_96544_ / 2 + 15), (int)Color.WHITE.getRGB());
        GuiComponent.m_93208_((PoseStack)matrix, (Font)font, (String)(Locals.localize((String)"helper.creator.windowsize.currentheight", (String[])new String[0]) + ": " + Minecraft.m_91087_().m_91268_().m_85444_()), (int)(renderIn.f_96543_ / 2), (int)(renderIn.f_96544_ / 2 + 30), (int)Color.WHITE.getRGB());
        this.doneButton.f_93620_ = renderIn.f_96543_ / 2 - this.doneButton.m_5711_() - 5;
        this.doneButton.f_93621_ = renderIn.f_96544_ / 2 + 80;
        this.cancelButton.f_93620_ = renderIn.f_96543_ / 2 + 5;
        this.cancelButton.f_93621_ = renderIn.f_96544_ / 2 + 80;
        this.renderButtons(matrix, mouseX, mouseY);
    }

    private void onDoneButtonPressed() {
        try {
            if (MathUtils.isInteger((String)this.widthText.m_94155_()) && MathUtils.isInteger((String)this.heightText.m_94155_())) {
                int w = Integer.parseInt(this.widthText.m_94155_());
                int h = Integer.parseInt(this.heightText.m_94155_());
                if (this.type == ActionType.BIGGERTHAN) {
                    if (this.parent.biggerThanWidth != w || this.parent.biggerThanHeight != h) {
                        this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                    }
                    this.parent.biggerThanWidth = w;
                    this.parent.biggerThanHeight = h;
                } else {
                    if (this.parent.smallerThanWidth != w || this.parent.smallerThanHeight != h) {
                        this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                    }
                    this.parent.smallerThanWidth = w;
                    this.parent.smallerThanHeight = h;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDisplayed(false);
    }

    public void onEnterPressed(KeyboardData d) {
        if (d.keycode == 257 && this.isDisplayed() && this.doneButton != null && this.doneButton.f_93624_) {
            this.onDoneButtonPressed();
        }
    }

    public void onEscapePressed(KeyboardData d) {
        if (d.keycode == 256 && this.isDisplayed()) {
            this.setDisplayed(false);
        }
    }

    public static enum ActionType {
        BIGGERTHAN,
        SMALLERTHAN;

    }
}

