/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.roller;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterRenderer;
import com.simibubi.create.content.contraptions.actors.roller.RollerBlock;
import com.simibubi.create.content.contraptions.actors.roller.RollerBlockEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class RollerRenderer
extends SmartBlockEntityRenderer<RollerBlockEntity> {
    public RollerRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(RollerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        BlockState blockState = be.m_58900_();
        ms.m_85836_();
        ms.m_85837_(0.0, -0.25, 0.0);
        SuperByteBuffer superBuffer = CachedBufferer.partial(AllPartialModels.ROLLER_WHEEL, blockState);
        Direction facing = (Direction)blockState.m_61143_((Property)RollerBlock.f_54117_);
        superBuffer.translate(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(1.0625));
        HarvesterRenderer.transform(be.m_58904_(), facing, superBuffer, be.getAnimatedSpeed(), Vec3.f_82478_);
        ((SuperByteBuffer)superBuffer.translate(0.0, -0.5, 0.5).rotateY(90.0)).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
        ms.m_85849_();
        CachedBufferer.partial(AllPartialModels.ROLLER_FRAME, blockState).rotateCentered(Direction.UP, AngleHelper.rad(AngleHelper.horizontalAngle(facing) + 180.0f)).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffers) {
        float speed;
        BlockState blockState = context.state;
        Direction facing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        SuperByteBuffer superBuffer = CachedBufferer.partial(AllPartialModels.ROLLER_WHEEL, blockState);
        float f = speed = !VecHelper.isVecPointingTowards(context.relativeMotion, facing.m_122424_()) ? context.getAnimationSpeed() : -context.getAnimationSpeed();
        if (context.contraption.stalled) {
            speed = 0.0f;
        }
        superBuffer.transform(matrices.getModel()).translate(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(1.0625));
        HarvesterRenderer.transform(context.world, facing, superBuffer, speed, Vec3.f_82478_);
        PoseStack viewProjection = matrices.getViewProjection();
        viewProjection.m_85836_();
        viewProjection.m_85837_(0.0, -0.25, 0.0);
        int contraptionWorldLight = ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld);
        ((SuperByteBuffer)superBuffer.translate(0.0, -0.5, 0.5).rotateY(90.0)).light(matrices.getWorld(), contraptionWorldLight).renderInto(viewProjection, buffers.m_6299_(RenderType.m_110457_()));
        viewProjection.m_85849_();
        CachedBufferer.partial(AllPartialModels.ROLLER_FRAME, blockState).transform(matrices.getModel()).rotateCentered(Direction.UP, AngleHelper.rad(AngleHelper.horizontalAngle(facing) + 180.0f)).light(matrices.getWorld(), contraptionWorldLight).renderInto(viewProjection, buffers.m_6299_(RenderType.m_110457_()));
    }
}

