/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crafter;

import com.google.common.base.Predicates;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.crafter.CrafterHelper;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.simibubi.create.content.kinetics.crafter.MechanicalCraftingInventory;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pointing;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.FireworkRocketRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeGridHandler {
    public static List<MechanicalCrafterBlockEntity> getAllCraftersOfChain(MechanicalCrafterBlockEntity root) {
        return RecipeGridHandler.getAllCraftersOfChainIf(root, (Predicate<MechanicalCrafterBlockEntity>)Predicates.alwaysTrue());
    }

    public static List<MechanicalCrafterBlockEntity> getAllCraftersOfChainIf(MechanicalCrafterBlockEntity root, Predicate<MechanicalCrafterBlockEntity> test) {
        return RecipeGridHandler.getAllCraftersOfChainIf(root, test, false);
    }

    public static List<MechanicalCrafterBlockEntity> getAllCraftersOfChainIf(MechanicalCrafterBlockEntity root, Predicate<MechanicalCrafterBlockEntity> test, boolean poweredStart) {
        ArrayList<MechanicalCrafterBlockEntity> crafters = new ArrayList<MechanicalCrafterBlockEntity>();
        ArrayList<Pair> frontier = new ArrayList<Pair>();
        HashSet<MechanicalCrafterBlockEntity> visited = new HashSet<MechanicalCrafterBlockEntity>();
        frontier.add(Pair.of((Object)root, null));
        boolean powered = false;
        boolean empty = false;
        boolean allEmpty = true;
        while (!frontier.isEmpty()) {
            Pair pair = (Pair)frontier.remove(0);
            MechanicalCrafterBlockEntity current = (MechanicalCrafterBlockEntity)pair.getKey();
            MechanicalCrafterBlockEntity last = (MechanicalCrafterBlockEntity)pair.getValue();
            if (visited.contains(current)) {
                return null;
            }
            if (!test.test(current)) {
                empty = true;
            } else {
                allEmpty = false;
            }
            if (poweredStart && current.m_58904_().m_46753_(current.m_58899_())) {
                powered = true;
            }
            crafters.add(current);
            visited.add(current);
            MechanicalCrafterBlockEntity target = RecipeGridHandler.getTargetingCrafter(current);
            if (target != last && target != null) {
                frontier.add(Pair.of((Object)target, (Object)current));
            }
            for (MechanicalCrafterBlockEntity preceding : RecipeGridHandler.getPrecedingCrafters(current)) {
                if (preceding == last) continue;
                frontier.add(Pair.of((Object)preceding, (Object)current));
            }
        }
        return empty && !powered || allEmpty ? null : crafters;
    }

    public static MechanicalCrafterBlockEntity getTargetingCrafter(MechanicalCrafterBlockEntity crafter) {
        BlockState state = crafter.m_58900_();
        if (!RecipeGridHandler.isCrafter(state)) {
            return null;
        }
        BlockPos targetPos = crafter.m_58899_().m_121945_(MechanicalCrafterBlock.getTargetDirection(state));
        MechanicalCrafterBlockEntity targetBE = CrafterHelper.getCrafter((BlockAndTintGetter)crafter.m_58904_(), targetPos);
        if (targetBE == null) {
            return null;
        }
        BlockState targetState = targetBE.m_58900_();
        if (!RecipeGridHandler.isCrafter(targetState)) {
            return null;
        }
        if (state.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING) != targetState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)) {
            return null;
        }
        return targetBE;
    }

    public static List<MechanicalCrafterBlockEntity> getPrecedingCrafters(MechanicalCrafterBlockEntity crafter) {
        BlockPos pos = crafter.m_58899_();
        Level world = crafter.m_58904_();
        ArrayList<MechanicalCrafterBlockEntity> crafters = new ArrayList<MechanicalCrafterBlockEntity>();
        BlockState blockState = crafter.m_58900_();
        if (!RecipeGridHandler.isCrafter(blockState)) {
            return crafters;
        }
        Direction blockFacing = (Direction)blockState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        Direction blockPointing = MechanicalCrafterBlock.getTargetDirection(blockState);
        for (Direction facing : Iterate.directions) {
            MechanicalCrafterBlockEntity be;
            BlockPos neighbourPos;
            BlockState neighbourState;
            if (blockFacing.m_122434_() == facing.m_122434_() || blockPointing == facing || !RecipeGridHandler.isCrafter(neighbourState = world.m_8055_(neighbourPos = pos.m_121945_(facing))) || MechanicalCrafterBlock.getTargetDirection(neighbourState) != facing.m_122424_() || blockFacing != neighbourState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING) || (be = CrafterHelper.getCrafter((BlockAndTintGetter)world, neighbourPos)) == null) continue;
            crafters.add(be);
        }
        return crafters;
    }

    private static boolean isCrafter(BlockState state) {
        return AllBlocks.MECHANICAL_CRAFTER.has(state);
    }

    public static ItemStack tryToApplyRecipe(Level world, GroupedItems items) {
        items.calcStats();
        MechanicalCraftingInventory craftinginventory = new MechanicalCraftingInventory(items);
        ItemStack result = null;
        if (((Boolean)AllConfigs.server().recipes.allowRegularCraftingInCrafter.get()).booleanValue()) {
            result = world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftinginventory, world).filter(r -> RecipeGridHandler.isRecipeAllowed(r, craftinginventory)).map(r -> r.m_5874_((Container)craftinginventory)).orElse(null);
        }
        if (result == null) {
            result = AllRecipeTypes.MECHANICAL_CRAFTING.find(craftinginventory, world).map(r -> r.m_5874_((Container)craftinginventory)).orElse(null);
        }
        return result;
    }

    public static boolean isRecipeAllowed(CraftingRecipe recipe, CraftingContainer inventory) {
        if (recipe instanceof FireworkRocketRecipe) {
            int numItems = 0;
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                if (inventory.m_8020_(i).m_41619_()) continue;
                ++numItems;
            }
            if (numItems > (Integer)AllConfigs.server().recipes.maxFireworkIngredientsInCrafter.get()) {
                return false;
            }
        }
        return !AllRecipeTypes.shouldIgnoreInAutomation(recipe);
    }

    public static class GroupedItems {
        Map<Pair<Integer, Integer>, ItemStack> grid = new HashMap<Pair<Integer, Integer>, ItemStack>();
        int minX;
        int minY;
        int maxX;
        int maxY;
        int width;
        int height;
        boolean statsReady;

        public GroupedItems() {
        }

        public GroupedItems(ItemStack stack) {
            this.grid.put((Pair<Integer, Integer>)Pair.of((Object)0, (Object)0), stack);
        }

        public void mergeOnto(GroupedItems other, Pointing pointing) {
            int xOffset;
            int n = pointing == Pointing.LEFT ? 1 : (xOffset = pointing == Pointing.RIGHT ? -1 : 0);
            int yOffset = pointing == Pointing.DOWN ? 1 : (pointing == Pointing.UP ? -1 : 0);
            this.grid.forEach((pair, stack) -> other.grid.put((Pair<Integer, Integer>)Pair.of((Object)((Integer)pair.getKey() + xOffset), (Object)((Integer)pair.getValue() + yOffset)), (ItemStack)stack));
            other.statsReady = false;
        }

        public void write(CompoundTag nbt) {
            ListTag gridNBT = new ListTag();
            this.grid.forEach((pair, stack) -> {
                CompoundTag entry = new CompoundTag();
                entry.m_128405_("x", ((Integer)pair.getKey()).intValue());
                entry.m_128405_("y", ((Integer)pair.getValue()).intValue());
                entry.m_128365_("item", (Tag)stack.serializeNBT());
                gridNBT.add((Object)entry);
            });
            nbt.m_128365_("Grid", (Tag)gridNBT);
        }

        public static GroupedItems read(CompoundTag nbt) {
            GroupedItems items = new GroupedItems();
            ListTag gridNBT = nbt.m_128437_("Grid", 10);
            gridNBT.forEach(inbt -> {
                CompoundTag entry = (CompoundTag)inbt;
                int x = entry.m_128451_("x");
                int y = entry.m_128451_("y");
                ItemStack stack = ItemStack.m_41712_((CompoundTag)entry.m_128469_("item"));
                items.grid.put((Pair<Integer, Integer>)Pair.of((Object)x, (Object)y), stack);
            });
            return items;
        }

        public void calcStats() {
            if (this.statsReady) {
                return;
            }
            this.statsReady = true;
            this.minX = 0;
            this.minY = 0;
            this.maxX = 0;
            this.maxY = 0;
            for (Pair<Integer, Integer> pair : this.grid.keySet()) {
                int x = (Integer)pair.getKey();
                int y = (Integer)pair.getValue();
                this.minX = Math.min(this.minX, x);
                this.minY = Math.min(this.minY, y);
                this.maxX = Math.max(this.maxX, x);
                this.maxY = Math.max(this.maxY, y);
            }
            this.width = this.maxX - this.minX + 1;
            this.height = this.maxY - this.minY + 1;
        }
    }
}

