/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RedstoneLinkCondition
extends ScheduleWaitCondition {
    public Couple<RedstoneLinkNetworkHandler.Frequency> freq = Couple.create(() -> RedstoneLinkNetworkHandler.Frequency.EMPTY);

    @Override
    public int slotsTargeted() {
        return 2;
    }

    @Override
    public Pair<ItemStack, Component> getSummary() {
        return Pair.of(AllBlocks.REDSTONE_LINK.asStack(), this.lowActivation() ? Lang.translateDirect("schedule.condition.redstone_link_off", new Object[0]) : Lang.translateDirect("schedule.condition.redstone_link_on", new Object[0]));
    }

    @Override
    public List<Component> getSecondLineTooltip(int slot) {
        return ImmutableList.of((Object)Lang.translateDirect(slot == 0 ? "logistics.firstFrequency" : "logistics.secondFrequency", new Object[0]).m_130940_(ChatFormatting.RED));
    }

    @Override
    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)Lang.translateDirect("schedule.condition.redstone_link.frequency_" + (this.lowActivation() ? "unpowered" : "powered"), new Object[0]), (Object)Components.literal(" #1 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)((RedstoneLinkNetworkHandler.Frequency)this.freq.getFirst()).getStack().m_41786_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA)), (Object)Components.literal(" #2 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)((RedstoneLinkNetworkHandler.Frequency)this.freq.getSecond()).getStack().m_41786_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA)));
    }

    @Override
    public boolean tickCompletion(Level level, Train train, CompoundTag context) {
        int lastChecked = context.m_128441_("LastChecked") ? context.m_128451_("LastChecked") : -1;
        int status = Create.REDSTONE_LINK_NETWORK_HANDLER.globalPowerVersion.get();
        if (status == lastChecked) {
            return false;
        }
        context.m_128405_("LastChecked", status);
        return Create.REDSTONE_LINK_NETWORK_HANDLER.hasAnyLoadedPower(this.freq) != this.lowActivation();
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        this.freq.set(slot == 0, RedstoneLinkNetworkHandler.Frequency.of(stack));
        super.setItem(slot, stack);
    }

    @Override
    public ItemStack getItem(int slot) {
        return this.freq.get(slot == 0).getStack();
    }

    @Override
    public ResourceLocation getId() {
        return Create.asResource("redstone_link");
    }

    @Override
    protected void writeAdditional(CompoundTag tag) {
        tag.m_128365_("Frequency", (Tag)this.freq.serializeEach(f -> f.getStack().serializeNBT()));
    }

    public boolean lowActivation() {
        return this.intData("Inverted") == 1;
    }

    @Override
    protected void readAdditional(CompoundTag tag) {
        if (tag.m_128441_("Frequency")) {
            this.freq = Couple.deserializeEach(tag.m_128437_("Frequency", 10), c -> RedstoneLinkNetworkHandler.Frequency.of(ItemStack.m_41712_((CompoundTag)c)));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        builder.addSelectionScrollInput(20, 101, (i, l) -> i.forOptions(Lang.translatedOptions("schedule.condition.redstone_link", "powered", "unpowered")).titled(Lang.translateDirect("schedule.condition.redstone_link.frequency_state", new Object[0])), "Inverted");
    }

    @Override
    public MutableComponent getWaitingStatus(Level level, Train train, CompoundTag tag) {
        return Lang.translateDirect("schedule.condition.redstone_link.status", new Object[0]);
    }
}

