/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.trains.track.TrackBlockEntityTilt;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackRenderer;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BezierConnection
implements Iterable<Segment> {
    public Couple<BlockPos> tePositions;
    public Couple<Vec3> starts;
    public Couple<Vec3> axes;
    public Couple<Vec3> normals;
    public Couple<Integer> smoothing;
    public boolean primary;
    public boolean hasGirder;
    protected TrackMaterial trackMaterial;
    Vec3 finish1;
    Vec3 finish2;
    private boolean resolved;
    private double length;
    private float[] stepLUT;
    private int segments;
    private double radius;
    private double handleLength;
    private AABB bounds;
    private SegmentAngles[] bakedSegments;
    private GirderAngles[] bakedGirders;

    public BezierConnection(Couple<BlockPos> positions, Couple<Vec3> starts, Couple<Vec3> axes, Couple<Vec3> normals, boolean primary, boolean girder, TrackMaterial material) {
        this.tePositions = positions;
        this.starts = starts;
        this.axes = axes;
        this.normals = normals;
        this.primary = primary;
        this.hasGirder = girder;
        this.trackMaterial = material;
        this.resolved = false;
    }

    public BezierConnection secondary() {
        BezierConnection bezierConnection = new BezierConnection((Couple<BlockPos>)this.tePositions.swap(), (Couple<Vec3>)this.starts.swap(), (Couple<Vec3>)this.axes.swap(), (Couple<Vec3>)this.normals.swap(), !this.primary, this.hasGirder, this.trackMaterial);
        if (this.smoothing != null) {
            bezierConnection.smoothing = this.smoothing.swap();
        }
        return bezierConnection;
    }

    public BezierConnection clone() {
        return this.secondary().secondary();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean coupleEquals(Couple<?> a, Couple<?> b) {
        Object f;
        if (a.getFirst().equals(b.getFirst())) {
            if (a.getSecond().equals(b.getSecond())) return true;
        }
        if (!((f = a.getFirst()) instanceof Vec3)) return false;
        Vec3 aFirst = (Vec3)f;
        Object s = a.getSecond();
        if (!(s instanceof Vec3)) return false;
        Vec3 aSecond = (Vec3)s;
        Object f2 = b.getFirst();
        if (!(f2 instanceof Vec3)) return false;
        Vec3 bFirst = (Vec3)f2;
        Object s2 = b.getSecond();
        if (!(s2 instanceof Vec3)) return false;
        Vec3 bSecond = (Vec3)s2;
        if (!aFirst.m_82509_((Position)bFirst, 1.0E-6)) return false;
        if (!aSecond.m_82509_((Position)bSecond, 1.0E-6)) return false;
        return true;
    }

    public boolean equalsSansMaterial(BezierConnection other) {
        return this.equalsSansMaterialInner(other) || this.equalsSansMaterialInner(other.secondary());
    }

    private boolean equalsSansMaterialInner(BezierConnection other) {
        return this == other || other != null && BezierConnection.coupleEquals(this.tePositions, other.tePositions) && BezierConnection.coupleEquals(this.starts, other.starts) && BezierConnection.coupleEquals(this.axes, other.axes) && BezierConnection.coupleEquals(this.normals, other.normals) && this.hasGirder == other.hasGirder;
    }

    public BezierConnection(CompoundTag compound, BlockPos localTo) {
        this(Couple.deserializeEach(compound.m_128437_("Positions", 10), NbtUtils::m_129239_).map(b -> b.m_121955_((Vec3i)localTo)), Couple.deserializeEach(compound.m_128437_("Starts", 10), VecHelper::readNBTCompound).map(v -> v.m_82549_(Vec3.m_82528_((Vec3i)localTo))), Couple.deserializeEach(compound.m_128437_("Axes", 10), VecHelper::readNBTCompound), Couple.deserializeEach(compound.m_128437_("Normals", 10), VecHelper::readNBTCompound), compound.m_128471_("Primary"), compound.m_128471_("Girder"), TrackMaterial.deserialize(compound.m_128461_("Material")));
        if (compound.m_128441_("Smoothing")) {
            this.smoothing = Couple.deserializeEach(compound.m_128437_("Smoothing", 10), NBTHelper::intFromCompound);
        }
    }

    public CompoundTag write(BlockPos localTo) {
        Couple<BlockPos> tePositions = this.tePositions.map(b -> b.m_121996_((Vec3i)localTo));
        Couple<Vec3> starts = this.starts.map(v -> v.m_82546_(Vec3.m_82528_((Vec3i)localTo)));
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("Girder", this.hasGirder);
        compound.m_128379_("Primary", this.primary);
        compound.m_128365_("Positions", (Tag)tePositions.serializeEach(NbtUtils::m_129224_));
        compound.m_128365_("Starts", (Tag)starts.serializeEach(VecHelper::writeNBTCompound));
        compound.m_128365_("Axes", (Tag)this.axes.serializeEach(VecHelper::writeNBTCompound));
        compound.m_128365_("Normals", (Tag)this.normals.serializeEach(VecHelper::writeNBTCompound));
        compound.m_128359_("Material", this.getMaterial().id.toString());
        if (this.smoothing != null) {
            compound.m_128365_("Smoothing", (Tag)this.smoothing.serializeEach(NBTHelper::intToCompound));
        }
        return compound;
    }

    public BezierConnection(FriendlyByteBuf buffer) {
        this(Couple.create(() -> ((FriendlyByteBuf)buffer).m_130135_()), Couple.create(() -> VecHelper.read(buffer)), Couple.create(() -> VecHelper.read(buffer)), Couple.create(() -> VecHelper.read(buffer)), buffer.readBoolean(), buffer.readBoolean(), TrackMaterial.deserialize(buffer.m_130277_()));
        if (buffer.readBoolean()) {
            this.smoothing = Couple.create(() -> ((FriendlyByteBuf)buffer).m_130242_());
        }
    }

    public void write(FriendlyByteBuf buffer) {
        this.tePositions.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130064_(arg_0));
        this.starts.forEach(v -> VecHelper.write(v, buffer));
        this.axes.forEach(v -> VecHelper.write(v, buffer));
        this.normals.forEach(v -> VecHelper.write(v, buffer));
        buffer.writeBoolean(this.primary);
        buffer.writeBoolean(this.hasGirder);
        buffer.m_130070_(this.getMaterial().id.toString());
        buffer.writeBoolean(this.smoothing != null);
        if (this.smoothing != null) {
            this.smoothing.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130130_(arg_0));
        }
    }

    public BlockPos getKey() {
        return (BlockPos)this.tePositions.getSecond();
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public int yOffsetAt(Vec3 end) {
        if (this.smoothing == null) {
            return 0;
        }
        if (TrackBlockEntityTilt.compareHandles((Vec3)this.starts.getFirst(), end)) {
            return (Integer)this.smoothing.getFirst();
        }
        if (TrackBlockEntityTilt.compareHandles((Vec3)this.starts.getSecond(), end)) {
            return (Integer)this.smoothing.getSecond();
        }
        return 0;
    }

    public double getLength() {
        this.resolve();
        return this.length;
    }

    public float[] getStepLUT() {
        this.resolve();
        return this.stepLUT;
    }

    public int getSegmentCount() {
        this.resolve();
        return this.segments;
    }

    public Vec3 getPosition(double t) {
        this.resolve();
        return VecHelper.bezier((Vec3)this.starts.getFirst(), (Vec3)this.starts.getSecond(), this.finish1, this.finish2, (float)t);
    }

    public double getRadius() {
        this.resolve();
        return this.radius;
    }

    public double getHandleLength() {
        this.resolve();
        return this.handleLength;
    }

    public float getSegmentT(int index) {
        return index == this.segments ? 1.0f : (float)index * this.stepLUT[index] / (float)this.segments;
    }

    public double incrementT(double currentT, double distance) {
        this.resolve();
        double dx = VecHelper.bezierDerivative((Vec3)this.starts.getFirst(), (Vec3)this.starts.getSecond(), this.finish1, this.finish2, (float)currentT).m_82553_() / this.getLength();
        return currentT + distance / dx;
    }

    public AABB getBounds() {
        this.resolve();
        return this.bounds;
    }

    public Vec3 getNormal(double t) {
        this.resolve();
        Vec3 end1 = (Vec3)this.starts.getFirst();
        Vec3 end2 = (Vec3)this.starts.getSecond();
        Vec3 fn1 = (Vec3)this.normals.getFirst();
        Vec3 fn2 = (Vec3)this.normals.getSecond();
        Vec3 derivative = VecHelper.bezierDerivative(end1, end2, this.finish1, this.finish2, (float)t).m_82541_();
        Vec3 faceNormal = fn1.equals((Object)fn2) ? fn1 : VecHelper.slerp((float)t, fn1, fn2);
        Vec3 normal = faceNormal.m_82537_(derivative).m_82541_();
        return derivative.m_82537_(normal);
    }

    private void resolve() {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        Vec3 end1 = (Vec3)this.starts.getFirst();
        Vec3 end2 = (Vec3)this.starts.getSecond();
        Vec3 axis1 = ((Vec3)this.axes.getFirst()).m_82541_();
        Vec3 axis2 = ((Vec3)this.axes.getSecond()).m_82541_();
        this.determineHandles(end1, end2, axis1, axis2);
        this.finish1 = axis1.m_82490_(this.handleLength).m_82549_(end1);
        this.finish2 = axis2.m_82490_(this.handleLength).m_82549_(end2);
        int scanCount = 16;
        this.length = 0.0;
        Vec3 previous = end1;
        for (int i = 0; i <= scanCount; ++i) {
            float t = (float)i / (float)scanCount;
            Vec3 result = VecHelper.bezier(end1, end2, this.finish1, this.finish2, t);
            if (previous != null) {
                this.length += result.m_82554_(previous);
            }
            previous = result;
        }
        this.segments = (int)(this.length * 2.0);
        this.stepLUT = new float[this.segments + 1];
        this.stepLUT[0] = 1.0f;
        float combinedDistance = 0.0f;
        this.bounds = new AABB(end1, end2);
        Vec3 previous2 = end1;
        for (int i = 0; i <= this.segments; ++i) {
            float t = (float)i / (float)this.segments;
            Vec3 result = VecHelper.bezier(end1, end2, this.finish1, this.finish2, t);
            this.bounds = this.bounds.m_82367_(new AABB(result, result));
            if (i > 0) {
                combinedDistance = (float)((double)combinedDistance + result.m_82554_(previous2) / this.length);
                this.stepLUT[i] = t / combinedDistance;
            }
            previous2 = result;
        }
        this.bounds = this.bounds.m_82400_(1.375);
    }

    private void determineHandles(Vec3 end1, Vec3 end2, Vec3 axis1, Vec3 axis2) {
        Vec3 cross1 = axis1.m_82537_(new Vec3(0.0, 1.0, 0.0));
        Vec3 cross2 = axis2.m_82537_(new Vec3(0.0, 1.0, 0.0));
        this.radius = 0.0;
        double a1 = Mth.m_14136_((double)(-axis2.f_82481_), (double)(-axis2.f_82479_));
        double a2 = Mth.m_14136_((double)axis1.f_82481_, (double)axis1.f_82479_);
        double angle = a1 - a2;
        float circle = (float)Math.PI * 2;
        if (Math.abs((double)circle - (angle = (angle + (double)circle) % (double)circle)) < Math.abs(angle)) {
            angle = (double)circle - angle;
        }
        if (Mth.m_14082_((double)angle, (double)0.0)) {
            double[] intersect = VecHelper.intersect(end1, end2, axis1, cross2, Direction.Axis.Y);
            if (intersect != null) {
                double t = Math.abs(intersect[0]);
                double u = Math.abs(intersect[1]);
                double min = Math.min(t, u);
                double max = Math.max(t, u);
                if (min > 1.2 && max / min > 1.0 && max / min < 3.0) {
                    this.handleLength = max - min;
                    return;
                }
            }
            this.handleLength = end2.m_82554_(end1) / 3.0;
            return;
        }
        double n = (double)circle / angle;
        double factor = 1.3333333333333333 * Math.tan(Math.PI / (2.0 * n));
        double[] intersect = VecHelper.intersect(end1, end2, cross1, cross2, Direction.Axis.Y);
        if (intersect == null) {
            this.handleLength = end2.m_82554_(end1) / 3.0;
            return;
        }
        this.radius = Math.abs(intersect[1]);
        this.handleLength = this.radius * factor;
        if (Mth.m_14082_((double)this.handleLength, (double)0.0)) {
            this.handleLength = 1.0;
        }
    }

    @Override
    public Iterator<Segment> iterator() {
        this.resolve();
        Vec3 offset = Vec3.m_82528_((Vec3i)((Vec3i)this.tePositions.getFirst())).m_82490_(-1.0).m_82520_(0.0, 0.1875, 0.0);
        return new Bezierator(this, offset);
    }

    public void addItemsToPlayer(Player player) {
        Inventory inv = player.m_150109_();
        for (int tracks = this.getTrackItemCost(); tracks > 0; tracks -= 64) {
            inv.m_150079_(new ItemStack((ItemLike)this.getMaterial().getBlock(), Math.min(64, tracks)));
        }
        for (int girders = this.getGirderItemCost(); girders > 0; girders -= 64) {
            inv.m_150079_(AllBlocks.METAL_GIRDER.asStack(Math.min(64, girders)));
        }
    }

    public int getGirderItemCost() {
        return this.hasGirder ? this.getTrackItemCost() * 2 : 0;
    }

    public int getTrackItemCost() {
        return (this.getSegmentCount() + 1) / 2;
    }

    public void spawnItems(Level level) {
        if (!level.m_46469_().m_46207_(GameRules.f_46136_)) {
            return;
        }
        Vec3 origin = Vec3.m_82528_((Vec3i)((Vec3i)this.tePositions.getFirst()));
        for (Segment segment : this) {
            if (segment.index % 2 != 0 || segment.index == this.getSegmentCount()) continue;
            Vec3 v = VecHelper.offsetRandomly(segment.position, level.f_46441_, 0.125f).m_82549_(origin);
            ItemEntity entity = new ItemEntity(level, v.f_82479_, v.f_82480_, v.f_82481_, this.getMaterial().asStack());
            entity.m_32060_();
            level.m_7967_((Entity)entity);
            if (!this.hasGirder) continue;
            for (int i = 0; i < 2; ++i) {
                entity = new ItemEntity(level, v.f_82479_, v.f_82480_, v.f_82481_, AllBlocks.METAL_GIRDER.asStack());
                entity.m_32060_();
                level.m_7967_((Entity)entity);
            }
        }
    }

    public void spawnDestroyParticles(Level level) {
        BlockParticleOption data = new BlockParticleOption(ParticleTypes.f_123794_, this.getMaterial().getBlock().m_49966_());
        BlockParticleOption girderData = new BlockParticleOption(ParticleTypes.f_123794_, AllBlocks.METAL_GIRDER.getDefaultState());
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel slevel = (ServerLevel)level;
        Vec3 origin = Vec3.m_82528_((Vec3i)((Vec3i)this.tePositions.getFirst()));
        for (Segment segment : this) {
            for (int offset : Iterate.positiveAndNegative) {
                Vec3 v = segment.position.m_82549_(segment.normal.m_82490_((double)(0.875f * (float)offset))).m_82549_(origin);
                slevel.m_8767_((ParticleOptions)data, v.f_82479_, v.f_82480_, v.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                if (!this.hasGirder) continue;
                slevel.m_8767_((ParticleOptions)girderData, v.f_82479_, v.f_82480_ - 0.5, v.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public TrackMaterial getMaterial() {
        return this.trackMaterial;
    }

    public void setMaterial(TrackMaterial material) {
        this.trackMaterial = material;
    }

    @OnlyIn(value=Dist.CLIENT)
    public SegmentAngles[] getBakedSegments() {
        if (this.bakedSegments != null) {
            return this.bakedSegments;
        }
        int segmentCount = this.getSegmentCount();
        this.bakedSegments = new SegmentAngles[segmentCount + 1];
        Couple<Vec3> previousOffsets = null;
        for (Segment segment : this) {
            int i = segment.index;
            boolean end = i == 0 || i == segmentCount;
            SegmentAngles angles = this.bakedSegments[i] = new SegmentAngles();
            Couple<Vec3> railOffsets = Couple.create(segment.position.m_82549_(segment.normal.m_82490_((double)0.965f)), segment.position.m_82546_(segment.normal.m_82490_((double)0.965f)));
            Vec3 railMiddle = ((Vec3)railOffsets.getFirst()).m_82549_((Vec3)railOffsets.getSecond()).m_82490_(0.5);
            if (previousOffsets == null) {
                previousOffsets = railOffsets;
                continue;
            }
            Vec3 prevMiddle = ((Vec3)previousOffsets.getFirst()).m_82549_((Vec3)previousOffsets.getSecond()).m_82490_(0.5);
            Vec3 tieAngles = TrackRenderer.getModelAngles(segment.normal, railMiddle.m_82546_(prevMiddle));
            angles.lightPosition = new BlockPos(railMiddle);
            angles.railTransforms = Couple.create(null, null);
            PoseStack poseStack = new PoseStack();
            ((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)poseStack).translate(prevMiddle)).rotateYRadians(tieAngles.f_82480_)).rotateXRadians(tieAngles.f_82479_)).rotateZRadians(tieAngles.f_82481_)).translate(-0.5, -0.12890625, 0.0);
            angles.tieTransform = poseStack.m_85850_();
            float scale = end ? 2.2f : 2.1f;
            for (boolean first : Iterate.trueAndFalse) {
                Vec3 railI = railOffsets.get(first);
                Vec3 prevI = previousOffsets.get(first);
                Vec3 diff = railI.m_82546_(prevI);
                Vec3 anglesI = TrackRenderer.getModelAngles(segment.normal, diff);
                poseStack = new PoseStack();
                ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)poseStack).translate(prevI)).rotateYRadians(anglesI.f_82480_)).rotateXRadians(anglesI.f_82479_)).rotateZRadians(anglesI.f_82481_)).translate(0.0, -0.12890625, -0.03125)).scale(1.0f, 1.0f, (float)diff.m_82553_() * scale);
                angles.railTransforms.set(first, poseStack.m_85850_());
            }
            previousOffsets = railOffsets;
        }
        return this.bakedSegments;
    }

    @OnlyIn(value=Dist.CLIENT)
    public GirderAngles[] getBakedGirders() {
        if (this.bakedGirders != null) {
            return this.bakedGirders;
        }
        int segmentCount = this.getSegmentCount();
        this.bakedGirders = new GirderAngles[segmentCount + 1];
        Couple<Couple<Vec3>> previousOffsets = null;
        for (Segment segment : this) {
            int i = segment.index;
            boolean end = i == 0 || i == segmentCount;
            GirderAngles angles = this.bakedGirders[i] = new GirderAngles();
            Vec3 leftGirder = segment.position.m_82549_(segment.normal.m_82490_((double)0.965f));
            Vec3 rightGirder = segment.position.m_82546_(segment.normal.m_82490_((double)0.965f));
            Vec3 upNormal = segment.derivative.m_82541_().m_82537_(segment.normal);
            Vec3 firstGirderOffset = upNormal.m_82490_(-0.5);
            Vec3 secondGirderOffset = upNormal.m_82490_(-0.625);
            Vec3 leftTop = segment.position.m_82549_(segment.normal.m_82490_(1.0)).m_82549_(firstGirderOffset);
            Vec3 rightTop = segment.position.m_82546_(segment.normal.m_82490_(1.0)).m_82549_(firstGirderOffset);
            Vec3 leftBottom = leftTop.m_82549_(secondGirderOffset);
            Vec3 rightBottom = rightTop.m_82549_(secondGirderOffset);
            angles.lightPosition = new BlockPos(leftGirder.m_82549_(rightGirder).m_82490_(0.5));
            Couple<Couple<Vec3>> offsets = Couple.create(Couple.create(leftTop, rightTop), Couple.create(leftBottom, rightBottom));
            if (previousOffsets == null) {
                previousOffsets = offsets;
                continue;
            }
            angles.beams = Couple.create(null, null);
            angles.beamCaps = Couple.create(Couple.create(null, null), Couple.create(null, null));
            float scale = end ? 2.3f : 2.2f;
            for (boolean first : Iterate.trueAndFalse) {
                Vec3 currentBeam = ((Vec3)((Couple)offsets.getFirst()).get(first)).m_82549_((Vec3)((Couple)offsets.getSecond()).get(first)).m_82490_(0.5);
                Vec3 previousBeam = ((Vec3)((Couple)previousOffsets.getFirst()).get(first)).m_82549_((Vec3)((Couple)previousOffsets.getSecond()).get(first)).m_82490_(0.5);
                Vec3 beamDiff = currentBeam.m_82546_(previousBeam);
                Vec3 beamAngles = TrackRenderer.getModelAngles(segment.normal, beamDiff);
                PoseStack poseStack = new PoseStack();
                ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)poseStack).translate(previousBeam)).rotateYRadians(beamAngles.f_82480_)).rotateXRadians(beamAngles.f_82479_)).rotateZRadians(beamAngles.f_82481_)).translate(0.0, (double)(0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f), -0.03125)).scale(1.0f, 1.0f, (float)beamDiff.m_82553_() * scale);
                angles.beams.set(first, poseStack.m_85850_());
                for (boolean top : Iterate.trueAndFalse) {
                    Vec3 current = offsets.get(top).get(first);
                    Vec3 previous = previousOffsets.get(top).get(first);
                    Vec3 diff = current.m_82546_(previous);
                    Vec3 capAngles = TrackRenderer.getModelAngles(segment.normal, diff);
                    poseStack = new PoseStack();
                    ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)poseStack).translate(previous)).rotateYRadians(capAngles.f_82480_)).rotateXRadians(capAngles.f_82479_)).rotateZRadians(capAngles.f_82481_)).translate(0.0, (double)(0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f), -0.03125)).rotateZ(top ? 0.0 : 0.0)).scale(1.0f, 1.0f, (float)diff.m_82553_() * scale);
                    angles.beamCaps.get(top).set(first, poseStack.m_85850_());
                }
            }
            previousOffsets = offsets;
        }
        return this.bakedGirders;
    }

    private static class Bezierator
    implements Iterator<Segment> {
        private final BezierConnection bc;
        private final Segment segment;
        private final Vec3 end1;
        private final Vec3 end2;
        private final Vec3 finish1;
        private final Vec3 finish2;
        private final Vec3 faceNormal1;
        private final Vec3 faceNormal2;

        private Bezierator(BezierConnection bc, Vec3 offset) {
            bc.resolve();
            this.bc = bc;
            this.end1 = ((Vec3)bc.starts.getFirst()).m_82549_(offset);
            this.end2 = ((Vec3)bc.starts.getSecond()).m_82549_(offset);
            this.finish1 = ((Vec3)bc.axes.getFirst()).m_82490_(bc.handleLength).m_82549_(this.end1);
            this.finish2 = ((Vec3)bc.axes.getSecond()).m_82490_(bc.handleLength).m_82549_(this.end2);
            this.faceNormal1 = (Vec3)bc.normals.getFirst();
            this.faceNormal2 = (Vec3)bc.normals.getSecond();
            this.segment = new Segment();
            this.segment.index = -1;
        }

        @Override
        public boolean hasNext() {
            return this.segment.index + 1 <= this.bc.segments;
        }

        @Override
        public Segment next() {
            ++this.segment.index;
            float t = this.bc.getSegmentT(this.segment.index);
            this.segment.position = VecHelper.bezier(this.end1, this.end2, this.finish1, this.finish2, t);
            this.segment.derivative = VecHelper.bezierDerivative(this.end1, this.end2, this.finish1, this.finish2, t).m_82541_();
            this.segment.faceNormal = this.faceNormal1.equals((Object)this.faceNormal2) ? this.faceNormal1 : VecHelper.slerp(t, this.faceNormal1, this.faceNormal2);
            this.segment.normal = this.segment.faceNormal.m_82537_(this.segment.derivative).m_82541_();
            return this.segment;
        }
    }

    public static class Segment {
        public int index;
        public Vec3 position;
        public Vec3 derivative;
        public Vec3 faceNormal;
        public Vec3 normal;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SegmentAngles {
        public PoseStack.Pose tieTransform;
        public Couple<PoseStack.Pose> railTransforms;
        public BlockPos lightPosition;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GirderAngles {
        public Couple<PoseStack.Pose> beams;
        public Couple<Couple<PoseStack.Pose>> beamCaps;
        public BlockPos lightPosition;
    }
}

