/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.IrisLogging;
import net.coderbot.iris.shaderpack.ConstDirectiveParser;
import net.coderbot.iris.shaderpack.DirectiveHolder;
import net.coderbot.iris.vendored.joml.Vector4f;

public class DispatchingDirectiveHolder
implements DirectiveHolder {
    private final Map<String, BooleanConsumer> booleanConstVariables = new HashMap<String, BooleanConsumer>();
    private final Map<String, Consumer<String>> stringConstVariables = new HashMap<String, Consumer<String>>();
    private final Map<String, IntConsumer> intConstVariables = new HashMap<String, IntConsumer>();
    private final Map<String, FloatConsumer> floatConstVariables = new HashMap<String, FloatConsumer>();
    private final Map<String, Consumer<Vector4f>> vec4ConstVariables = new HashMap<String, Consumer<Vector4f>>();

    public void processDirective(ConstDirectiveParser.ConstDirective directive) {
        ConstDirectiveParser.Type type = directive.getType();
        String key = directive.getKey();
        String value = directive.getValue();
        if (type == ConstDirectiveParser.Type.BOOL) {
            BooleanConsumer consumer = this.booleanConstVariables.get(key);
            if (consumer != null) {
                if ("true".equals(value)) {
                    consumer.accept(true);
                } else if ("false".equals(value)) {
                    consumer.accept(false);
                } else {
                    Iris.logger.error("Failed to process " + directive + ": " + value + " is not a valid boolean value");
                }
                return;
            }
            if (IrisLogging.ENABLE_SPAM) {
                Iris.logger.info("Found potential unhandled directive: " + directive);
            }
            this.typeCheckHelper("int", this.intConstVariables, directive);
            this.typeCheckHelper("int", this.stringConstVariables, directive);
            this.typeCheckHelper("float", this.floatConstVariables, directive);
            this.typeCheckHelper("vec4", this.vec4ConstVariables, directive);
        } else if (type == ConstDirectiveParser.Type.INT) {
            Consumer<String> stringConsumer = this.stringConstVariables.get(key);
            if (stringConsumer != null) {
                stringConsumer.accept(value);
                return;
            }
            IntConsumer intConsumer = this.intConstVariables.get(key);
            if (intConsumer != null) {
                try {
                    intConsumer.accept(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    Iris.logger.error("Failed to process " + directive, e);
                }
                return;
            }
            if (IrisLogging.ENABLE_SPAM) {
                Iris.logger.info("Found potential unhandled directive: " + directive);
            }
            this.typeCheckHelper("bool", this.booleanConstVariables, directive);
            this.typeCheckHelper("float", this.floatConstVariables, directive);
            this.typeCheckHelper("vec4", this.vec4ConstVariables, directive);
        } else if (type == ConstDirectiveParser.Type.FLOAT) {
            FloatConsumer consumer = this.floatConstVariables.get(key);
            if (consumer != null) {
                try {
                    consumer.accept(Float.parseFloat(value));
                }
                catch (NumberFormatException e) {
                    Iris.logger.error("Failed to process " + directive, e);
                }
                return;
            }
            if (IrisLogging.ENABLE_SPAM) {
                Iris.logger.info("Found potential unhandled directive: " + directive);
            }
            this.typeCheckHelper("bool", this.booleanConstVariables, directive);
            this.typeCheckHelper("int", this.intConstVariables, directive);
            this.typeCheckHelper("int", this.stringConstVariables, directive);
            this.typeCheckHelper("vec4", this.vec4ConstVariables, directive);
        } else if (type == ConstDirectiveParser.Type.VEC4) {
            Consumer<Vector4f> consumer = this.vec4ConstVariables.get(key);
            if (consumer != null) {
                String vec4Args;
                if (!value.startsWith("vec4")) {
                    Iris.logger.error("Failed to process " + directive + ": value was not a valid vec4 constructor");
                }
                if (!(vec4Args = value.substring("vec4".length()).trim()).startsWith("(") || !vec4Args.endsWith(")")) {
                    Iris.logger.error("Failed to process " + directive + ": value was not a valid vec4 constructor");
                }
                vec4Args = vec4Args.substring(1, vec4Args.length() - 1);
                String[] parts = vec4Args.split(",");
                for (int i = 0; i < parts.length; ++i) {
                    parts[i] = parts[i].trim();
                }
                if (parts.length != 4) {
                    Iris.logger.error("Failed to process " + directive + ": expected 4 arguments to a vec4 constructor, got " + parts.length);
                }
                try {
                    consumer.accept(new Vector4f(Float.parseFloat(parts[0]), Float.parseFloat(parts[1]), Float.parseFloat(parts[2]), Float.parseFloat(parts[3])));
                }
                catch (NumberFormatException e) {
                    Iris.logger.error("Failed to process " + directive, e);
                }
                return;
            }
            this.typeCheckHelper("bool", this.booleanConstVariables, directive);
            this.typeCheckHelper("int", this.intConstVariables, directive);
            this.typeCheckHelper("int", this.stringConstVariables, directive);
            this.typeCheckHelper("float", this.floatConstVariables, directive);
        }
    }

    private void typeCheckHelper(String expected, Map<String, ? extends Object> candidates, ConstDirectiveParser.ConstDirective directive) {
        if (candidates.containsKey(directive.getKey())) {
            Iris.logger.warn("Ignoring " + directive + " because it is of the wrong type, a type of " + expected + " is expected.");
        }
    }

    @Override
    public void acceptUniformDirective(String name, Runnable onDetected) {
        if (IrisLogging.ENABLE_SPAM) {
            Iris.logger.warn("Not looking for a uniform directive with the name " + name + " since this type of directive is not currently supported.");
        }
    }

    @Override
    public void acceptCommentStringDirective(String name, Consumer<String> consumer) {
        if (IrisLogging.ENABLE_SPAM) {
            Iris.logger.warn("Not looking for a comment string directive with the name " + name + " since this type of directive is not currently supported.");
        }
    }

    @Override
    public void acceptCommentIntDirective(String name, IntConsumer consumer) {
        if (IrisLogging.ENABLE_SPAM) {
            Iris.logger.warn("Not looking for a comment int directive with the name " + name + " since this type of directive is not currently supported.");
        }
    }

    @Override
    public void acceptCommentFloatDirective(String name, FloatConsumer consumer) {
        if (IrisLogging.ENABLE_SPAM) {
            Iris.logger.warn("Not looking for a comment float directive with the name " + name + " since this type of directive is not currently supported.");
        }
    }

    @Override
    public void acceptConstBooleanDirective(String name, BooleanConsumer consumer) {
        this.booleanConstVariables.put(name, consumer);
    }

    @Override
    public void acceptConstStringDirective(String name, Consumer<String> consumer) {
        this.stringConstVariables.put(name, consumer);
    }

    @Override
    public void acceptConstIntDirective(String name, IntConsumer consumer) {
        this.intConstVariables.put(name, consumer);
    }

    @Override
    public void acceptConstFloatDirective(String name, FloatConsumer consumer) {
        this.floatConstVariables.put(name, consumer);
    }

    @Override
    public void acceptConstVec4Directive(String name, Consumer<Vector4f> consumer) {
        this.vec4ConstVariables.put(name, consumer);
    }
}

