/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.dynamic_resources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.math.Transformation;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.ClientPackSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ExtendedBlockModelDeserializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.resource.DelegatingPackResources;
import net.minecraftforge.resource.PathPackResources;
import org.apache.commons.lang3.tuple.Triple;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.duck.IExtendedModelBakery;
import org.embeddedt.modernfix.dynamicresources.DynamicBakedModelProvider;
import org.embeddedt.modernfix.dynamicresources.ModelBakeryHelpers;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelBakery.class}, priority=600)
@ClientOnlyMixin
public abstract class ModelBakeryMixin
implements IExtendedModelBakery {
    private static final boolean debugDynamicModelLoading = Boolean.getBoolean("modernfix.debugDynamicModelLoading");
    @Shadow
    @Final
    @Mutable
    public Map<ResourceLocation, UnbakedModel> f_119212_;
    @Shadow
    @Final
    public static ModelResourceLocation f_119230_;
    @Shadow
    @Final
    protected ResourceManager f_119243_;
    @Shadow
    @javax.annotation.Nullable
    private AtlasSet f_119244_;
    @Shadow
    @Final
    private Set<ResourceLocation> f_119210_;
    @Shadow
    @Final
    @Mutable
    private Map<ResourceLocation, BakedModel> f_119215_;
    @Shadow
    @Final
    @Mutable
    private Map<Triple<ResourceLocation, Transformation, Boolean>, BakedModel> f_119213_;
    @Shadow
    @Final
    public static BlockModel f_119232_;
    @Shadow
    @Final
    private static ItemModelGenerator f_119241_;
    @Shadow
    @Final
    @Mutable
    private BlockColors f_119209_;
    @Shadow
    @Final
    private static Logger f_119235_;
    private Cache<Triple<ResourceLocation, Transformation, Boolean>, BakedModel> loadedBakedModels;
    private Cache<ResourceLocation, UnbakedModel> loadedModels;
    private HashMap<ResourceLocation, UnbakedModel> smallLoadingCache = new HashMap();
    private UnbakedModel missingModel;
    private Set<ResourceLocation> blockStateFiles;
    private Set<ResourceLocation> modelFiles;
    private BakedModel bakedMissingModel = null;

    @Shadow
    protected abstract BlockModel m_119364_(ResourceLocation var1) throws IOException;

    @Shadow
    protected abstract void m_119362_(ResourceLocation var1) throws Exception;

    @Shadow
    public abstract UnbakedModel m_119341_(ResourceLocation var1);

    @Shadow
    @javax.annotation.Nullable
    public abstract BakedModel bake(ResourceLocation var1, ModelState var2, Function<Material, TextureAtlasSprite> var3);

    @Shadow
    @Nullable
    public abstract BakedModel m_119349_(ResourceLocation var1, ModelState var2);

    @Redirect(method={"<init>"}, at=@At(value="FIELD", opcode=181, target="Lnet/minecraft/client/resources/model/ModelBakery;blockColors:Lnet/minecraft/client/color/block/BlockColors;"))
    private void replaceTopLevelBakedModels(ModelBakery bakery, BlockColors val) {
        this.f_119209_ = val;
        this.loadedBakedModels = CacheBuilder.newBuilder().expireAfterAccess(300L, TimeUnit.SECONDS).maximumSize(10000L).concurrencyLevel(8).removalListener(this::onModelRemoved).softValues().build();
        this.loadedModels = CacheBuilder.newBuilder().expireAfterAccess(300L, TimeUnit.SECONDS).maximumSize(10000L).concurrencyLevel(8).removalListener(this::onModelRemoved).softValues().build();
        this.f_119213_ = this.loadedBakedModels.asMap();
        this.f_119212_ = this.loadedModels.asMap();
        this.f_119215_ = new DynamicBakedModelProvider((ModelBakery)this, this.f_119213_);
    }

    private <K, V> void onModelRemoved(RemovalNotification<K, V> notification) {
        ResourceLocation rl;
        if (!debugDynamicModelLoading) {
            return;
        }
        Object k = notification.getKey();
        if (k == null) {
            return;
        }
        boolean baked = false;
        if (k instanceof ResourceLocation) {
            rl = (ResourceLocation)k;
        } else {
            rl = (ResourceLocation)((Triple)k).getLeft();
            baked = true;
        }
        ModernFix.LOGGER.warn("Evicted {} model {}", (Object)(baked ? "baked" : "unbaked"), (Object)rl);
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/model/ModelBakery;loadBlockModel(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/block/model/BlockModel;", ordinal=0))
    private BlockModel captureMissingModel(ModelBakery bakery, ResourceLocation location) throws IOException {
        this.missingModel = this.m_119364_(location);
        this.blockStateFiles = new HashSet<ResourceLocation>();
        this.modelFiles = new HashSet<ResourceLocation>();
        return (BlockModel)this.missingModel;
    }

    @Inject(method={"loadTopLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void addTopLevelFile(ModelResourceLocation location, CallbackInfo ci) {
        ci.cancel();
        if (Objects.equals(location.m_119448_(), "inventory")) {
            this.modelFiles.add(new ResourceLocation(location.m_135827_(), "item/" + location.m_135815_()));
        } else {
            this.blockStateFiles.add(new ResourceLocation(location.m_135827_(), location.m_135815_()));
        }
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/client/ForgeHooksClient;gatherFluidTextures(Ljava/util/Set;)V", remap=false), remap=false)
    private void gatherModelTextures(Set<Material> materialSet) {
        ForgeHooksClient.gatherFluidTextures(materialSet);
        this.gatherModelMaterials(materialSet);
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V", ordinal=0))
    private void fetchStaticDefinitions(Map<ResourceLocation, StateDefinition<Block, BlockState>> map, BiConsumer<ResourceLocation, StateDefinition<Block, BlockState>> func) {
        map.forEach((loc, def) -> this.blockStateFiles.add((ResourceLocation)loc));
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/StateDefinition;getPossibleStates()Lcom/google/common/collect/ImmutableList;", ordinal=0))
    private ImmutableList<BlockState> fetchBlocks(StateDefinition<Block, BlockState> def) {
        this.blockStateFiles.add(ForgeRegistries.BLOCKS.getKey((Object)((BlockState)def.m_61090_()).m_60734_()));
        return ImmutableList.of();
    }

    private boolean trustedResourcePack(PackResources pack) {
        return pack instanceof VanillaPackResources || pack instanceof PathPackResources || pack instanceof ClientPackSource || pack instanceof DelegatingPackResources || pack instanceof FolderPackResources || pack instanceof FilePackResources;
    }

    private void gatherModelMaterials(Set<Material> materialSet) {
        Function<JsonElement, BlockModel> modelDeserializer = model -> (BlockModel)ExtendedBlockModelDeserializer.INSTANCE.fromJson(model, BlockModel.class);
        ModelBakeryHelpers.gatherModelMaterials(this.f_119243_, this::trustedResourcePack, materialSet, this.blockStateFiles, this.modelFiles, this.missingModel, modelDeserializer, this::m_119341_);
        this.loadedModels.invalidateAll();
        this.loadedModels.put((Object)f_119230_, (Object)this.missingModel);
    }

    @Inject(method={"uploadTextures"}, at={@At(value="FIELD", target="Lnet/minecraft/client/resources/model/ModelBakery;topLevelModels:Ljava/util/Map;", ordinal=0)}, cancellable=true)
    private void skipBake(TextureManager resourceManager, ProfilerFiller profiler, CallbackInfoReturnable<AtlasSet> cir) {
        profiler.m_7238_();
        this.f_119215_.put((ResourceLocation)f_119230_, this.bake((ResourceLocation)f_119230_, (ModelState)BlockModelRotation.X0_Y0, arg_0 -> ((AtlasSet)this.f_119244_).m_117971_(arg_0)));
        cir.setReturnValue((Object)this.f_119244_);
    }

    @Redirect(method={"loadModel"}, at=@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;", ordinal=1))
    private Object getMissingModel(Map map, Object rl) {
        if (rl == f_119230_ && map == this.f_119212_) {
            return this.missingModel;
        }
        return this.f_119212_.get(rl);
    }

    @ModifyVariable(method={"cacheAndQueueDependencies"}, at=@At(value="HEAD"), argsOnly=true)
    private UnbakedModel fireUnbakedEvent(UnbakedModel model, ResourceLocation location) {
        for (ModernFixClientIntegration integration : ModernFixClient.CLIENT_INTEGRATIONS) {
            try {
                model = integration.onUnbakedModelLoad(location, model, (ModelBakery)this);
            }
            catch (RuntimeException e) {
                ModernFix.LOGGER.error("Exception firing model load event for {}", (Object)location, (Object)e);
            }
        }
        return model;
    }

    @Inject(method={"cacheAndQueueDependencies"}, at={@At(value="RETURN")})
    private void addToSmallLoadingCache(ResourceLocation location, UnbakedModel model, CallbackInfo ci) {
        this.smallLoadingCache.put(location, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getModel"}, at={@At(value="HEAD")}, cancellable=true)
    public void getOrLoadModelDynamic(ResourceLocation modelLocation, CallbackInfoReturnable<UnbakedModel> cir) {
        if (modelLocation.equals((Object)f_119230_)) {
            cir.setReturnValue((Object)this.missingModel);
            return;
        }
        UnbakedModel existing = this.f_119212_.get(modelLocation);
        if (existing != null) {
            cir.setReturnValue((Object)existing);
        } else {
            ModelBakeryMixin modelBakeryMixin = this;
            synchronized (modelBakeryMixin) {
                if (this.f_119210_.contains(modelLocation)) {
                    throw new IllegalStateException("Circular reference while loading " + modelLocation);
                }
                this.f_119210_.add(modelLocation);
                UnbakedModel iunbakedmodel = this.missingModel;
                while (!this.f_119210_.isEmpty()) {
                    ResourceLocation resourcelocation = this.f_119210_.iterator().next();
                    try {
                        existing = this.f_119212_.get(resourcelocation);
                        if (existing == null) {
                            if (debugDynamicModelLoading) {
                                f_119235_.info("Loading {}", (Object)resourcelocation);
                            }
                            this.m_119362_(resourcelocation);
                            continue;
                        }
                        this.smallLoadingCache.put(resourcelocation, existing);
                    }
                    catch (ModelBakery.BlockStateDefinitionException var9) {
                        f_119235_.warn(var9.getMessage());
                        this.f_119212_.put(resourcelocation, iunbakedmodel);
                        this.smallLoadingCache.put(resourcelocation, iunbakedmodel);
                    }
                    catch (Exception var10) {
                        f_119235_.warn("Unable to load model: '{}' referenced from: {}: {}", new Object[]{resourcelocation, modelLocation, var10});
                        this.f_119212_.put(resourcelocation, iunbakedmodel);
                        this.smallLoadingCache.put(resourcelocation, iunbakedmodel);
                    }
                    finally {
                        this.f_119210_.remove(resourcelocation);
                    }
                }
                UnbakedModel result = this.smallLoadingCache.getOrDefault(modelLocation, iunbakedmodel);
                this.smallLoadingCache.clear();
                cir.setReturnValue((Object)result);
            }
        }
    }

    private <T extends Comparable<T>, V extends T> BlockState setPropertyGeneric(BlockState state, Property<T> prop, Object o) {
        return (BlockState)state.m_61124_(prop, (Comparable)o);
    }

    @Redirect(method={"loadModel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/StateDefinition;getPossibleStates()Lcom/google/common/collect/ImmutableList;"))
    private ImmutableList<BlockState> loadOnlyRelevantBlockState(StateDefinition<Block, BlockState> stateDefinition, ResourceLocation location) {
        return ModelBakeryHelpers.getBlockStatesForMRL(stateDefinition, (ModelResourceLocation)location);
    }

    @Override
    public ImmutableList<BlockState> getBlockStatesForMRL(StateDefinition<Block, BlockState> stateDefinition, ModelResourceLocation location) {
        return this.loadOnlyRelevantBlockState(stateDefinition, (ResourceLocation)location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"bake(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/resources/model/ModelState;Ljava/util/function/Function;)Lnet/minecraft/client/resources/model/BakedModel;"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void getOrLoadBakedModelDynamic(ResourceLocation arg, ModelState arg2, Function<Material, TextureAtlasSprite> textureGetter, CallbackInfoReturnable<BakedModel> cir) {
        Triple triple = Triple.of((Object)arg, (Object)arg2.m_6189_(), (Object)arg2.m_7538_());
        BakedModel existing = this.f_119213_.get(triple);
        if (existing != null) {
            cir.setReturnValue((Object)existing);
        } else {
            if (this.f_119244_ == null) {
                throw new IllegalStateException("bake called too early");
            }
            ModelBakeryMixin modelBakeryMixin = this;
            synchronized (modelBakeryMixin) {
                BlockModel blockmodel;
                if (debugDynamicModelLoading) {
                    f_119235_.info("Baking {}", (Object)arg);
                }
                UnbakedModel iunbakedmodel = this.m_119341_(arg);
                iunbakedmodel.m_5500_(this::m_119341_, new HashSet());
                if (iunbakedmodel == this.missingModel && debugDynamicModelLoading) {
                    f_119235_.warn("Model {} not present", (Object)arg);
                }
                if (iunbakedmodel != this.missingModel) {
                    for (ModernFixClientIntegration integration : ModernFixClient.CLIENT_INTEGRATIONS) {
                        try {
                            iunbakedmodel = integration.onUnbakedModelPreBake(arg, iunbakedmodel, (ModelBakery)this);
                        }
                        catch (RuntimeException e) {
                            ModernFix.LOGGER.error("Exception encountered firing bake event for {}", (Object)arg, (Object)e);
                        }
                    }
                }
                BakedModel ibakedmodel = null;
                if (iunbakedmodel instanceof BlockModel && (blockmodel = (BlockModel)iunbakedmodel).m_111490_() == f_119232_) {
                    ibakedmodel = f_119241_.m_111670_(textureGetter, blockmodel).m_111449_((ModelBakery)this, blockmodel, arg_0 -> ((AtlasSet)this.f_119244_).m_117971_(arg_0), arg2, arg, false);
                }
                if (ibakedmodel == null) {
                    if (iunbakedmodel == this.missingModel) {
                        if (this.bakedMissingModel == null) {
                            this.bakedMissingModel = iunbakedmodel.m_7611_((ModelBakery)this, textureGetter, arg2, arg);
                            ((DynamicBakedModelProvider)this.f_119215_).setMissingModel(this.bakedMissingModel);
                        }
                        ibakedmodel = this.bakedMissingModel;
                    } else {
                        ibakedmodel = iunbakedmodel.m_7611_((ModelBakery)this, textureGetter, arg2, arg);
                    }
                }
                for (ModernFixClientIntegration integration : ModernFixClient.CLIENT_INTEGRATIONS) {
                    try {
                        ibakedmodel = integration.onBakedModelLoad(arg, iunbakedmodel, ibakedmodel, arg2, (ModelBakery)this);
                    }
                    catch (RuntimeException e) {
                        ModernFix.LOGGER.error("Exception encountered firing bake event for {}", (Object)arg, (Object)e);
                    }
                }
                this.f_119213_.put((Triple<ResourceLocation, Transformation, Boolean>)triple, ibakedmodel);
                cir.setReturnValue((Object)ibakedmodel);
            }
        }
    }
}

