/*
 * Decompiled with CFR 0.152.
 */
package dev.limonblaze.oriacs.common.item;

import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.Lazy;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public enum OriacsArmorMaterials implements ArmorMaterial
{
    DIVING(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151052_}), 9, new int[]{1, 4, 5, 2}, 1.0f, 0.0f, 9, SoundEvents.f_11677_),
    CHAINMEMBRANE(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42714_}), 25, new int[]{1, 4, 5, 2}, 4.0f, 0.0f, 15, SoundEvents.f_11672_);

    private final Lazy<Ingredient> repairIngredient;
    private final int[] durabilities;
    private final int[] armorValues;
    private final float toughness;
    private final float knockbackResistance;
    private final int enchantmentValue;
    private final SoundEvent equipSound;

    private OriacsArmorMaterials(Supplier<Ingredient> repairIngredient, int[] durabilities, int[] armorValues, float toughness, float knockbackResistance, int enchantmentValue, SoundEvent equipSound) {
        this.repairIngredient = Lazy.of(repairIngredient);
        this.durabilities = durabilities;
        this.armorValues = armorValues;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.enchantmentValue = enchantmentValue;
        this.equipSound = equipSound;
    }

    private OriacsArmorMaterials(Supplier<Ingredient> repairIngredient, int durabilityMultiplier, int[] armorValues, float toughness, float knockbackResistance, int enchantmentValue, SoundEvent equipSound) {
        this(repairIngredient, new int[]{13 * durabilityMultiplier, 15 * durabilityMultiplier, 16 * durabilityMultiplier, 11 * durabilityMultiplier}, armorValues, toughness, knockbackResistance, enchantmentValue, equipSound);
    }

    public int m_7366_(EquipmentSlot slot) {
        return this.durabilities[slot.m_20749_()];
    }

    public int m_7365_(EquipmentSlot slot) {
        return this.armorValues[slot.m_20749_()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.get();
    }

    public String m_6082_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }
}

