/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.render.BaseFallbackConsumer;
import link.infra.indium.renderer.render.BaseMeshConsumer;
import link.infra.indium.renderer.render.BlockRenderInfo;
import link.infra.indium.renderer.render.MatrixRenderContext;
import link.infra.indium.renderer.render.SingleBlockLightDataCache;
import link.infra.indium.renderer.render.VertexConsumerQuadBufferer;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class BlockRenderContext
extends MatrixRenderContext {
    private final BlockRenderInfo blockInfo = new BlockRenderInfo();
    private final SingleBlockLightDataCache lightCache = new SingleBlockLightDataCache();
    private final AoCalculator aoCalc = new AoCalculator(this.blockInfo, this.lightCache);
    private final BaseMeshConsumer meshConsumer = new BaseMeshConsumer(new QuadBufferer(this::outputBuffer), this.blockInfo, this.aoCalc, this::transform);
    private VertexConsumer bufferBuilder;
    private boolean didOutput = false;
    private RandomSource random;
    private long seed;
    private final Supplier<RandomSource> randomSupplier = () -> {
        this.random.m_188584_(this.seed);
        return this.random;
    };
    private final BaseFallbackConsumer fallbackConsumer = new BaseFallbackConsumer(new QuadBufferer(this::outputBuffer), this.blockInfo, this.aoCalc, this::transform);

    private VertexConsumer outputBuffer(RenderType renderLayer) {
        this.didOutput = true;
        return this.bufferBuilder;
    }

    public boolean render(BlockAndTintGetter blockView, BakedModel model, BlockState state, BlockPos pos, PoseStack matrixStack, VertexConsumer buffer, RandomSource random, long seed, int overlay, ModelData modelData, RenderType layer, boolean queryModelSpecificData) {
        this.bufferBuilder = buffer;
        this.matrix = matrixStack.m_85850_().m_85861_();
        this.normalMatrix = matrixStack.m_85850_().m_85864_();
        this.random = random;
        this.seed = seed;
        if (queryModelSpecificData) {
            modelData = model.getModelData(blockView, pos, state, modelData);
        }
        this.overlay = overlay;
        this.didOutput = false;
        this.aoCalc.clear();
        this.blockInfo.setBlockView(blockView);
        this.blockInfo.prepareForBlock((BlockGetter)blockView, state, pos, model.m_7541_(), modelData, layer);
        this.lightCache.reset(pos, blockView);
        ((FabricBakedModel)model).emitBlockQuads(blockView, state, pos, this.randomSupplier, this);
        this.blockInfo.release();
        this.bufferBuilder = null;
        this.random = null;
        this.seed = seed;
        return this.didOutput;
    }

    @Override
    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    @Override
    public RenderContext.BakedModelConsumer bakedModelConsumer() {
        return this.fallbackConsumer;
    }

    @Override
    public QuadEmitter getEmitter() {
        return this.meshConsumer.getEmitter();
    }

    private class QuadBufferer
    extends VertexConsumerQuadBufferer {
        QuadBufferer(Function<RenderType, VertexConsumer> bufferFunc) {
            super(bufferFunc);
        }

        @Override
        protected Matrix4f matrix() {
            return BlockRenderContext.this.matrix;
        }

        @Override
        protected Matrix3f normalMatrix() {
            return BlockRenderContext.this.normalMatrix;
        }

        @Override
        protected int overlay() {
            return BlockRenderContext.this.overlay;
        }
    }
}

