/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import link.infra.indium.renderer.render.BlockRenderInfo;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class TerrainBlockRenderInfo
extends BlockRenderInfo {
    protected final BlockOcclusionCache blockOcclusionCache;
    private int cullCompletionFlags;
    private int cullResultFlags;

    public TerrainBlockRenderInfo(BlockOcclusionCache blockOcclusionCache) {
        this.blockOcclusionCache = blockOcclusionCache;
    }

    @Override
    public void prepareForBlock(BlockGetter level, BlockState blockState, BlockPos blockPos, boolean modelAO, ModelData modelData, RenderType layer) {
        super.prepareForBlock(level, blockState, blockPos, modelAO, modelData, layer);
        this.cullCompletionFlags = 0;
        this.cullResultFlags = 0;
    }

    @Override
    boolean shouldDrawFace(Direction face) {
        if (face == null) {
            return true;
        }
        int mask = 1 << face.m_122411_();
        if ((this.cullCompletionFlags & mask) == 0) {
            this.cullCompletionFlags |= mask;
            if (this.blockOcclusionCache.shouldDrawSide(this.blockState, (BlockGetter)this.blockView, this.blockPos, face)) {
                this.cullResultFlags |= mask;
                return true;
            }
            return false;
        }
        return (this.cullResultFlags & mask) != 0;
    }
}

