/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.renderer.v1.mesh;

import com.mojang.math.Vector3f;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec2;

public interface QuadEmitter
extends MutableQuadView {
    public static final float CULL_FACE_EPSILON = 1.0E-5f;

    @Override
    public QuadEmitter material(RenderMaterial var1);

    @Override
    public QuadEmitter cullFace(Direction var1);

    @Override
    public QuadEmitter nominalFace(Direction var1);

    @Override
    public QuadEmitter colorIndex(int var1);

    @Override
    public QuadEmitter fromVanilla(int[] var1, int var2, boolean var3);

    @Override
    public QuadEmitter tag(int var1);

    @Override
    public QuadEmitter pos(int var1, float var2, float var3, float var4);

    @Override
    default public QuadEmitter pos(int vertexIndex, Vector3f vec) {
        MutableQuadView.super.pos(vertexIndex, vec);
        return this;
    }

    @Override
    default public QuadEmitter normal(int vertexIndex, Vector3f vec) {
        MutableQuadView.super.normal(vertexIndex, vec);
        return this;
    }

    @Override
    public QuadEmitter lightmap(int var1, int var2);

    @Override
    default public QuadEmitter lightmap(int b0, int b1, int b2, int b3) {
        MutableQuadView.super.lightmap(b0, b1, b2, b3);
        return this;
    }

    @Override
    public QuadEmitter spriteColor(int var1, int var2, int var3);

    @Override
    default public QuadEmitter spriteColor(int spriteIndex, int c0, int c1, int c2, int c3) {
        MutableQuadView.super.spriteColor(spriteIndex, c0, c1, c2, c3);
        return this;
    }

    @Override
    public QuadEmitter sprite(int var1, int var2, float var3, float var4);

    @Override
    default public QuadEmitter sprite(int vertexIndex, int spriteIndex, Vec2 uv) {
        return this.sprite(vertexIndex, spriteIndex, uv.f_82470_, uv.f_82471_);
    }

    default public QuadEmitter spriteUnitSquare(int spriteIndex) {
        this.sprite(0, spriteIndex, 0.0f, 0.0f);
        this.sprite(1, spriteIndex, 0.0f, 1.0f);
        this.sprite(2, spriteIndex, 1.0f, 1.0f);
        this.sprite(3, spriteIndex, 1.0f, 0.0f);
        return this;
    }

    @Override
    public QuadEmitter spriteBake(int var1, TextureAtlasSprite var2, int var3);

    default public QuadEmitter square(Direction nominalFace, float left, float bottom, float right, float top, float depth) {
        if (Math.abs(depth) < 1.0E-5f) {
            this.cullFace(nominalFace);
            depth = 0.0f;
        } else {
            this.cullFace(null);
        }
        this.nominalFace(nominalFace);
        switch (nominalFace) {
            case UP: {
                depth = 1.0f - depth;
                top = 1.0f - top;
                bottom = 1.0f - bottom;
            }
            case DOWN: {
                this.pos(0, left, depth, top);
                this.pos(1, left, depth, bottom);
                this.pos(2, right, depth, bottom);
                this.pos(3, right, depth, top);
                break;
            }
            case EAST: {
                depth = 1.0f - depth;
                left = 1.0f - left;
                right = 1.0f - right;
            }
            case WEST: {
                this.pos(0, depth, top, left);
                this.pos(1, depth, bottom, left);
                this.pos(2, depth, bottom, right);
                this.pos(3, depth, top, right);
                break;
            }
            case SOUTH: {
                depth = 1.0f - depth;
                left = 1.0f - left;
                right = 1.0f - right;
            }
            case NORTH: {
                this.pos(0, 1.0f - left, top, depth);
                this.pos(1, 1.0f - left, bottom, depth);
                this.pos(2, 1.0f - right, bottom, depth);
                this.pos(3, 1.0f - right, top, depth);
            }
        }
        return this;
    }

    public QuadEmitter emit();
}

