/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractMeshConsumer;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.ChunkRenderInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.TerrainFallbackConsumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class TerrainRenderContext
extends AbstractRenderContext {
    public static final ThreadLocal<TerrainRenderContext> POOL = ThreadLocal.withInitial(TerrainRenderContext::new);
    private final BlockRenderInfo blockInfo = new BlockRenderInfo();
    private final ChunkRenderInfo chunkInfo = new ChunkRenderInfo();
    private final AoCalculator aoCalc = new AoCalculator(this.blockInfo){

        @Override
        public int light(BlockPos pos, BlockState state) {
            return TerrainRenderContext.this.chunkInfo.cachedBrightness(pos, state);
        }

        @Override
        public float ao(BlockPos pos, BlockState state) {
            return TerrainRenderContext.this.chunkInfo.cachedAoLevel(pos, state);
        }
    };
    private final AbstractMeshConsumer meshConsumer = new AbstractMeshConsumer(this.blockInfo, this.chunkInfo::getInitializedBuffer, this.aoCalc, this::transform){

        @Override
        protected int overlay() {
            return TerrainRenderContext.this.overlay;
        }

        @Override
        protected Matrix4f matrix() {
            return TerrainRenderContext.this.matrix;
        }

        @Override
        protected Matrix3f normalMatrix() {
            return TerrainRenderContext.this.normalMatrix;
        }
    };
    private final TerrainFallbackConsumer fallbackConsumer = new TerrainFallbackConsumer(this.blockInfo, this.chunkInfo::getInitializedBuffer, this.aoCalc, this::transform){

        @Override
        protected int overlay() {
            return TerrainRenderContext.this.overlay;
        }

        @Override
        protected Matrix4f matrix() {
            return TerrainRenderContext.this.matrix;
        }

        @Override
        protected Matrix3f normalMatrix() {
            return TerrainRenderContext.this.normalMatrix;
        }
    };

    public void prepare(RenderChunkRegion blockView, ChunkRenderDispatcher.RenderChunk chunkRenderer, ChunkRenderDispatcher.RenderChunk.RebuildTask.CompileResults renderData, ChunkBufferBuilderPack builders, Set<RenderType> initializedLayers) {
        this.blockInfo.prepareForWorld((BlockAndTintGetter)blockView, true);
        this.chunkInfo.prepare(blockView, chunkRenderer, renderData, builders, initializedLayers);
    }

    public void release() {
        this.chunkInfo.release();
        this.blockInfo.release();
    }

    public void tessellateBlock(BlockAndTintGetter blockView, BlockState blockState, BlockPos blockPos, BakedModel model, PoseStack matrixStack, ModelData data, RenderType layer, boolean queryModelSpecificData) {
        this.matrix = matrixStack.m_85850_().m_85861_();
        this.normalMatrix = matrixStack.m_85850_().m_85864_();
        if (queryModelSpecificData) {
            data = model.getModelData(blockView, blockPos, blockState, data);
        }
        try {
            this.aoCalc.clear();
            this.blockInfo.prepareForBlock(blockView, blockState, blockPos, model.m_7541_(), data, layer);
            ((FabricBakedModel)model).emitBlockQuads(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, this.blockInfo.randomSupplier, this);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)throwable, (String)"Tessellating block in world - Indigo Renderer");
            CrashReportCategory crashReportSection = crashReport.m_127514_("Block being tessellated");
            CrashReportCategory.m_178950_((CrashReportCategory)crashReportSection, (LevelHeightAccessor)this.chunkInfo.blockView, (BlockPos)blockPos, (BlockState)blockState);
            throw new ReportedException(crashReport);
        }
    }

    @Override
    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    @Override
    public RenderContext.BakedModelConsumer bakedModelConsumer() {
        return this.fallbackConsumer;
    }

    @Override
    public QuadEmitter getEmitter() {
        return this.meshConsumer.getEmitter();
    }
}

