/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Deprecated
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LegacyChunkLoadingCapability {
    private static final UUID LEGACY_GLOBAL_UUID = UUID.fromString("399cf0ed-1eb4-4e3d-92ca-856f579aac86");
    public static Capability<ChunkTracker> TRACKER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ChunkTracker>(){});

    @SubscribeEvent
    public static void register(RegisterCapabilitiesEvent e) {
        e.register(ChunkTracker.class);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Level> e) {
        Level world = (Level)e.getObject();
        if (world.f_46443_ || !(world instanceof ServerLevel)) {
            return;
        }
        final LazyOptional tracker = LazyOptional.of(() -> new ChunkTracker((ServerLevel)world));
        e.addCapability(new ResourceLocation("chunkloaders", "chunk_tracker"), (ICapabilityProvider)new ICapabilitySerializable<Tag>(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == TRACKER_CAPABILITY ? tracker.cast() : LazyOptional.empty();
            }

            public Tag serializeNBT() {
                return tracker.map(ChunkTracker::write).orElse(null);
            }

            public void deserializeNBT(Tag nbt) {
                tracker.ifPresent(cap -> cap.read((CompoundTag)nbt));
            }
        });
        e.addListener(() -> ((LazyOptional)tracker).invalidate());
    }

    public static class ChunkTracker {
        private final ServerLevel world;
        private final Map<ChunkPos, List<BlockPos>> chunks = new HashMap<ChunkPos, List<BlockPos>>();

        public ChunkTracker(ServerLevel world) {
            this.world = world;
        }

        public void remove(BlockPos loader) {
            ArrayList<ChunkPos> toBeRemoved = new ArrayList<ChunkPos>();
            for (Map.Entry<ChunkPos, List<BlockPos>> entry : this.chunks.entrySet()) {
                if (!entry.getValue().remove(loader) || !entry.getValue().isEmpty()) continue;
                toBeRemoved.add(entry.getKey());
            }
            for (ChunkPos chunkPos : toBeRemoved) {
                this.chunks.remove(chunkPos);
                this.world.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, false);
            }
        }

        public CompoundTag write() {
            CompoundTag compound = new CompoundTag();
            for (Map.Entry<ChunkPos, List<BlockPos>> entry : this.chunks.entrySet()) {
                CompoundTag chunkTag = new CompoundTag();
                chunkTag.m_128356_("chunk", entry.getKey().m_45588_());
                LongArrayTag blocks = new LongArrayTag(entry.getValue().stream().map(BlockPos::m_121878_).collect(Collectors.toList()));
                chunkTag.m_128365_("blocks", (Tag)blocks);
                compound.m_128365_(entry.getKey().f_45578_ + ";" + entry.getKey().f_45579_ + ";old", (Tag)chunkTag);
            }
            return compound;
        }

        public void read(CompoundTag compound) {
            for (String key : compound.m_128431_()) {
                CompoundTag chunkTag = compound.m_128469_(key);
                ChunkPos chunk = new ChunkPos(chunkTag.m_128454_("chunk"));
                LongArrayTag blocks = (LongArrayTag)chunkTag.m_128423_("blocks");
                ArrayList blockList = new ArrayList();
                Arrays.stream(blocks.m_128851_()).mapToObj(BlockPos::m_122022_).forEach(blockList::add);
                this.chunks.put(chunk, blockList);
                if (key.endsWith(";old")) continue;
                this.world.m_7654_().m_129946_(() -> this.world.m_8602_(chunk.f_45578_, chunk.f_45579_, false));
            }
        }

        public void onLoadLevel(ForgeChunkManager.TicketHelper ticketHelper) {
            ticketHelper.removeAllTickets(LEGACY_GLOBAL_UUID);
            if (ChunkLoadersConfig.allowLegacyLoadedChunks.get().booleanValue()) {
                for (ChunkPos pos : this.chunks.keySet()) {
                    ForgeChunkManager.forceChunk((ServerLevel)this.world, (String)"chunkloaders", (UUID)LEGACY_GLOBAL_UUID, (int)pos.f_45578_, (int)pos.f_45579_, (boolean)true, (boolean)true);
                }
            }
        }
    }
}

