/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.EnumMap;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class SyncLaserSideConfig {
    private BlockPos pos;
    private CompoundTag sideConfig;

    public SyncLaserSideConfig() {
    }

    public SyncLaserSideConfig(BlockPos pos, EnumMap<Direction, Boolean> sideConfig) {
        this.pos = pos;
        this.sideConfig = LaserBlockBlockEntity.saveSideConfig(sideConfig);
    }

    public static void encode(SyncLaserSideConfig message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130079_(message.sideConfig);
    }

    public static SyncLaserSideConfig decode(FriendlyByteBuf buf) {
        SyncLaserSideConfig message = new SyncLaserSideConfig();
        message.pos = buf.m_130135_();
        message.sideConfig = buf.m_130260_();
        return message;
    }

    public static void onMessage(SyncLaserSideConfig message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LaserBlockBlockEntity be;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level level = player.f_19853_;
            BlockPos pos = message.pos;
            BlockEntity patt1532$temp = level.m_7702_(pos);
            if (patt1532$temp instanceof LaserBlockBlockEntity && (be = (LaserBlockBlockEntity)patt1532$temp).isOwnedBy((Player)player)) {
                BlockState state = level.m_8055_(pos);
                be.applyNewSideConfig(LaserBlockBlockEntity.loadSideConfig(message.sideConfig), (Player)player);
                level.m_7260_(pos, state, state, 2);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

