/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.highlights.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.util.Mth;

public record HighlightLine(Vector3f start, Vector3f end, Vector3f normal) {
    public static final Codec<HighlightLine> CODEC = Codec.FLOAT.listOf().comapFlatMap(floats -> Util.m_143795_((List)floats, (int)6).map(HighlightLine::new), HighlightLine::getAsList);

    public HighlightLine(Vector3f start, Vector3f end) {
        this(start, end, HighlightLine.normal(start, end));
    }

    public HighlightLine(List<Float> list) {
        this(new Vector3f(list.get(0).floatValue(), list.get(1).floatValue(), list.get(2).floatValue()), new Vector3f(list.get(3).floatValue(), list.get(4).floatValue(), list.get(5).floatValue()));
    }

    public List<Float> getAsList() {
        return List.of(Float.valueOf(this.start.m_122239_()), Float.valueOf(this.start.m_122260_()), Float.valueOf(this.start.m_122269_()), Float.valueOf(this.end.m_122239_()), Float.valueOf(this.end.m_122260_()), Float.valueOf(this.end.m_122269_()));
    }

    public HighlightLine copy() {
        return new HighlightLine(this.start.m_122281_(), this.end.m_122281_());
    }

    public void recalculateNormal() {
        Vector3f normal = HighlightLine.normal(this.start, this.end);
        this.normal.m_122245_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
    }

    public void render(PoseStack poseStack, VertexConsumer consumer, float x, float y, float z) {
        PoseStack.Pose last = poseStack.m_85850_();
        consumer.m_85982_(last.m_85861_(), x + this.start.m_122239_(), y + this.start.m_122260_(), z + this.start.m_122269_()).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_85977_(last.m_85864_(), this.normal.m_122239_(), this.normal.m_122260_(), this.normal.m_122269_()).m_5752_();
        consumer.m_85982_(last.m_85861_(), x + this.end.m_122239_(), y + this.end.m_122260_(), z + this.end.m_122269_()).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_85977_(last.m_85864_(), this.normal.m_122239_(), this.normal.m_122260_(), this.normal.m_122269_()).m_5752_();
    }

    private static Vector3f normal(Vector3f start, Vector3f end) {
        Vector3f diff = new Vector3f(start.m_122239_() - end.m_122239_(), start.m_122260_() - end.m_122260_(), start.m_122269_() - end.m_122269_());
        float sqrt = Mth.m_14116_((float)(diff.m_122239_() * diff.m_122239_() + diff.m_122260_() * diff.m_122260_() + diff.m_122269_() * diff.m_122269_()));
        return new Vector3f(diff.m_122239_() / sqrt, diff.m_122260_() / sqrt, diff.m_122269_() / sqrt);
    }
}

