/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities;

import foundationgames.enhancedblockentities.EnhancedBlockEntityRegistry;
import foundationgames.enhancedblockentities.client.model.DynamicModelEffects;
import foundationgames.enhancedblockentities.client.model.DynamicModelProvider;
import foundationgames.enhancedblockentities.client.model.DynamicUnbakedModel;
import foundationgames.enhancedblockentities.client.model.ModelIdentifiers;
import foundationgames.enhancedblockentities.client.model.ModelSelector;
import foundationgames.enhancedblockentities.client.render.BlockEntityRenderCondition;
import foundationgames.enhancedblockentities.client.render.BlockEntityRendererOverride;
import foundationgames.enhancedblockentities.client.render.entity.BellBlockEntityRendererOverride;
import foundationgames.enhancedblockentities.client.render.entity.ChestBlockEntityRendererOverride;
import foundationgames.enhancedblockentities.client.render.entity.ShulkerBoxBlockEntityRendererOverride;
import foundationgames.enhancedblockentities.client.render.entity.SignBlockEntityRendererOverride;
import foundationgames.enhancedblockentities.util.DateUtil;
import foundationgames.enhancedblockentities.util.EBEUtil;
import foundationgames.enhancedblockentities.util.ResourceUtil;
import foundationgames.enhancedblockentities.util.duck.BakedModelManagerAccess;
import foundationgames.enhancedblockentities.util.resource_provider.ResourceProviderHolder;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.models.JModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public final class EBESetup
extends Enum<EBESetup> {
    private static final /* synthetic */ EBESetup[] $VALUES;

    public static EBESetup[] values() {
        return (EBESetup[])$VALUES.clone();
    }

    public static EBESetup valueOf(String name) {
        return Enum.valueOf(EBESetup.class, name);
    }

    public static void setupRRPChests() {
        RuntimeResourcePack p = ResourceUtil.getPack();
        ResourceUtil.addChestBlockStates("chest", p);
        ResourceUtil.addChestBlockStates("trapped_chest", p);
        ResourceUtil.addChestBlockStates("christmas_chest", p);
        ResourceUtil.addSingleChestOnlyBlockStates("ender_chest", p);
        ResourceUtil.addSingleChestModels("entity/chest/normal", "chest", p);
        ResourceUtil.addDoubleChestModels("entity/chest/normal_left", "entity/chest/normal_right", "chest", p);
        ResourceUtil.addSingleChestModels("entity/chest/trapped", "trapped_chest", p);
        ResourceUtil.addDoubleChestModels("entity/chest/trapped_left", "entity/chest/trapped_right", "trapped_chest", p);
        ResourceUtil.addSingleChestModels("entity/chest/christmas", "christmas_chest", p);
        ResourceUtil.addDoubleChestModels("entity/chest/christmas_left", "entity/chest/christmas_right", "christmas_chest", p);
        ResourceUtil.addSingleChestModels("entity/chest/ender", "ender_chest", p);
        p.addResource(PackType.CLIENT_RESOURCES, new ResourceLocation("models/item/chest.json"), "{\"parent\":\"block/chest_center\",\"overrides\":[{\"predicate\":{\"is_christmas\":1},\"model\": \"item/christmas_chest\"}]}".getBytes());
        p.addModel(JModel.model((String)"block/trapped_chest_center"), new ResourceLocation("item/trapped_chest"));
        p.addModel(JModel.model((String)"block/ender_chest_center"), new ResourceLocation("item/ender_chest"));
    }

    public static void setupRRPSigns() {
        RuntimeResourcePack p = ResourceUtil.getPack();
        ResourceUtil.addSignBlockStates("oak_sign", "oak_wall_sign", p);
        ResourceUtil.addSignBlockStates("birch_sign", "birch_wall_sign", p);
        ResourceUtil.addSignBlockStates("spruce_sign", "spruce_wall_sign", p);
        ResourceUtil.addSignBlockStates("jungle_sign", "jungle_wall_sign", p);
        ResourceUtil.addSignBlockStates("acacia_sign", "acacia_wall_sign", p);
        ResourceUtil.addSignBlockStates("dark_oak_sign", "dark_oak_wall_sign", p);
        ResourceUtil.addSignBlockStates("mangrove_sign", "mangrove_wall_sign", p);
        ResourceUtil.addSignBlockStates("crimson_sign", "crimson_wall_sign", p);
        ResourceUtil.addSignBlockStates("warped_sign", "warped_wall_sign", p);
        ResourceUtil.addSignModels("entity/signs/oak", "oak_sign", "oak_wall_sign", p);
        ResourceUtil.addSignModels("entity/signs/birch", "birch_sign", "birch_wall_sign", p);
        ResourceUtil.addSignModels("entity/signs/spruce", "spruce_sign", "spruce_wall_sign", p);
        ResourceUtil.addSignModels("entity/signs/jungle", "jungle_sign", "jungle_wall_sign", p);
        ResourceUtil.addSignModels("entity/signs/acacia", "acacia_sign", "acacia_wall_sign", p);
        ResourceUtil.addSignModels("entity/signs/dark_oak", "dark_oak_sign", "dark_oak_wall_sign", p);
        ResourceUtil.addSignModels("entity/signs/mangrove", "mangrove_sign", "mangrove_wall_sign", p);
        ResourceUtil.addSignModels("entity/signs/crimson", "crimson_sign", "crimson_wall_sign", p);
        ResourceUtil.addSignModels("entity/signs/warped", "warped_sign", "warped_wall_sign", p);
    }

    public static void setupRRPBells() {
        ResourceUtil.addBellBlockState(ResourceUtil.getPack());
    }

    public static void setupRRPBeds() {
        RuntimeResourcePack p = ResourceUtil.getPack();
        for (DyeColor color : DyeColor.values()) {
            ResourceUtil.addBedBlockState(color, p);
            ResourceUtil.addBedModels(color, p);
        }
    }

    public static void setupRRPShulkerBoxes() {
        RuntimeResourcePack p = ResourceUtil.getPack();
        for (DyeColor color : EBEUtil.DEFAULTED_DYE_COLORS) {
            String id = color != null ? color.m_41065_() + "_shulker_box" : "shulker_box";
            ResourceUtil.addShulkerBoxBlockStates(color, p);
            ResourceUtil.addShulkerBoxModels(color, p);
            p.addModel(JModel.model((String)("block/" + id)), new ResourceLocation("item/" + id));
        }
    }

    public static void setupResourceProviders() {
        ResourceProviderHolder.INSTANCE.registerResourceProvider(() -> new DynamicModelProvider(new ResourceLocation("builtin", "chest_center"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.CHEST_CENTER, ModelIdentifiers.CHEST_CENTER_TRUNK, ModelIdentifiers.CHRISTMAS_CHEST_CENTER, ModelIdentifiers.CHRISTMAS_CHEST_CENTER_TRUNK}, ModelSelector.CHEST_WITH_CHRISTMAS, DynamicModelEffects.CHEST)));
        ResourceProviderHolder.INSTANCE.registerResourceProvider(() -> new DynamicModelProvider(new ResourceLocation("builtin", "chest_left"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.CHEST_LEFT, ModelIdentifiers.CHEST_LEFT_TRUNK, ModelIdentifiers.CHRISTMAS_CHEST_LEFT, ModelIdentifiers.CHRISTMAS_CHEST_LEFT_TRUNK}, ModelSelector.CHEST_WITH_CHRISTMAS, DynamicModelEffects.CHEST)));
        ResourceProviderHolder.INSTANCE.registerResourceProvider(() -> new DynamicModelProvider(new ResourceLocation("builtin", "chest_right"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.CHEST_RIGHT, ModelIdentifiers.CHEST_RIGHT_TRUNK, ModelIdentifiers.CHRISTMAS_CHEST_RIGHT, ModelIdentifiers.CHRISTMAS_CHEST_RIGHT_TRUNK}, ModelSelector.CHEST_WITH_CHRISTMAS, DynamicModelEffects.CHEST)));
        ResourceProviderHolder.INSTANCE.registerResourceProvider(() -> new DynamicModelProvider(new ResourceLocation("builtin", "trapped_chest_center"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.TRAPPED_CHEST_CENTER, ModelIdentifiers.TRAPPED_CHEST_CENTER_TRUNK}, ModelSelector.CHEST, DynamicModelEffects.CHEST)));
        ResourceProviderHolder.INSTANCE.registerResourceProvider(() -> new DynamicModelProvider(new ResourceLocation("builtin", "trapped_chest_left"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.TRAPPED_CHEST_LEFT, ModelIdentifiers.TRAPPED_CHEST_LEFT_TRUNK}, ModelSelector.CHEST, DynamicModelEffects.CHEST)));
        ResourceProviderHolder.INSTANCE.registerResourceProvider(() -> new DynamicModelProvider(new ResourceLocation("builtin", "trapped_chest_right"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.TRAPPED_CHEST_RIGHT, ModelIdentifiers.TRAPPED_CHEST_RIGHT_TRUNK}, ModelSelector.CHEST, DynamicModelEffects.CHEST)));
        ResourceProviderHolder.INSTANCE.registerResourceProvider(() -> new DynamicModelProvider(new ResourceLocation("builtin", "ender_chest_center"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.ENDER_CHEST_CENTER, ModelIdentifiers.ENDER_CHEST_CENTER_TRUNK}, ModelSelector.CHEST, DynamicModelEffects.CHEST)));
        ResourceProviderHolder.INSTANCE.registerResourceProvider(() -> new DynamicModelProvider(new ResourceLocation("builtin", "bell_between_walls"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.BELL_BETWEEN_WALLS_WITH_BELL, ModelIdentifiers.BELL_BETWEEN_WALLS}, ModelSelector.BELL, DynamicModelEffects.BELL)));
        ResourceProviderHolder.INSTANCE.registerResourceProvider(() -> new DynamicModelProvider(new ResourceLocation("builtin", "bell_ceiling"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.BELL_CEILING_WITH_BELL, ModelIdentifiers.BELL_CEILING}, ModelSelector.BELL, DynamicModelEffects.BELL)));
        ResourceProviderHolder.INSTANCE.registerResourceProvider(() -> new DynamicModelProvider(new ResourceLocation("builtin", "bell_floor"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.BELL_FLOOR_WITH_BELL, ModelIdentifiers.BELL_FLOOR}, ModelSelector.BELL, DynamicModelEffects.BELL)));
        ResourceProviderHolder.INSTANCE.registerResourceProvider(() -> new DynamicModelProvider(new ResourceLocation("builtin", "bell_wall"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.BELL_WALL_WITH_BELL, ModelIdentifiers.BELL_WALL}, ModelSelector.BELL, DynamicModelEffects.BELL)));
        for (DyeColor color : EBEUtil.DEFAULTED_DYE_COLORS) {
            ResourceProviderHolder.INSTANCE.registerResourceProvider(() -> new DynamicModelProvider(new ResourceLocation("builtin", (String)(color != null ? color.m_41065_() + "_shulker_box" : "shulker_box")), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.SHULKER_BOXES.get(color), ModelIdentifiers.SHULKER_BOX_BOTTOMS.get(color)}, ModelSelector.SHULKER_BOX, DynamicModelEffects.CHEST)));
        }
    }

    public static void setupChests() {
        ItemBlockRenderTypes.setRenderLayer((Block)Blocks.f_50087_, (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)Blocks.f_50325_, (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)Blocks.f_50265_, (RenderType)RenderType.m_110457_());
        EnhancedBlockEntityRegistry.register(Blocks.f_50087_, BlockEntityType.f_58918_, BlockEntityRenderCondition.CHEST, new ChestBlockEntityRendererOverride(() -> {
            ModelManager manager = Minecraft.m_91087_().m_91304_();
            return new BakedModel[]{manager.getModel(ModelIdentifiers.CHEST_CENTER_LID), manager.getModel(ModelIdentifiers.CHEST_LEFT_LID), manager.getModel(ModelIdentifiers.CHEST_RIGHT_LID), manager.getModel(ModelIdentifiers.CHRISTMAS_CHEST_CENTER_LID), manager.getModel(ModelIdentifiers.CHRISTMAS_CHEST_LEFT_LID), manager.getModel(ModelIdentifiers.CHRISTMAS_CHEST_RIGHT_LID)};
        }, entity -> {
            int os = DateUtil.isChristmas() ? 3 : 0;
            ChestType type = (ChestType)entity.m_58900_().m_61143_((Property)BlockStateProperties.f_61392_);
            return type == ChestType.RIGHT ? 2 + os : (type == ChestType.LEFT ? 1 + os : os);
        }));
        EnhancedBlockEntityRegistry.register(Blocks.f_50325_, BlockEntityType.f_58919_, BlockEntityRenderCondition.CHEST, new ChestBlockEntityRendererOverride(() -> {
            BakedModelManagerAccess manager = (BakedModelManagerAccess)Minecraft.m_91087_().m_91304_();
            return new BakedModel[]{manager.getModel(ModelIdentifiers.TRAPPED_CHEST_CENTER_LID), manager.getModel(ModelIdentifiers.TRAPPED_CHEST_LEFT_LID), manager.getModel(ModelIdentifiers.TRAPPED_CHEST_RIGHT_LID)};
        }, entity -> {
            ChestType type = (ChestType)entity.m_58900_().m_61143_((Property)BlockStateProperties.f_61392_);
            return type == ChestType.RIGHT ? 2 : (type == ChestType.LEFT ? 1 : 0);
        }));
        EnhancedBlockEntityRegistry.register(Blocks.f_50265_, BlockEntityType.f_58920_, BlockEntityRenderCondition.CHEST, new ChestBlockEntityRendererOverride(() -> {
            BakedModelManagerAccess manager = (BakedModelManagerAccess)Minecraft.m_91087_().m_91304_();
            return new BakedModel[]{manager.getModel(ModelIdentifiers.ENDER_CHEST_CENTER_LID)};
        }, entity -> 0));
    }

    public static void setupSigns() {
        EnhancedBlockEntityRegistry.register(Blocks.f_50095_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_50158_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_50150_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_50160_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_50149_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_50159_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_50152_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_50162_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_50151_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_50161_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_50153_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_50163_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_220841_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_220839_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_50673_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_50675_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_50674_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        EnhancedBlockEntityRegistry.register(Blocks.f_50676_, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
    }

    public static void setupBells() {
        EnhancedBlockEntityRegistry.register(Blocks.f_50680_, BlockEntityType.f_58909_, BlockEntityRenderCondition.BELL, new BellBlockEntityRendererOverride());
    }

    public static void setupBeds() {
        EnhancedBlockEntityRegistry.register(Blocks.f_50029_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50025_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50026_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50023_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50021_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50027_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50017_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50022_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50019_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50068_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50067_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50020_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50024_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50028_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50066_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50018_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
    }

    public static void setupShulkerBoxes() {
        for (DyeColor color : EBEUtil.DEFAULTED_DYE_COLORS) {
            Block block = ShulkerBoxBlock.m_56190_((DyeColor)color);
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_());
            EnhancedBlockEntityRegistry.register(block, BlockEntityType.f_58939_, BlockEntityRenderCondition.SHULKER_BOX, new ShulkerBoxBlockEntityRendererOverride(map -> {
                BakedModelManagerAccess models = (BakedModelManagerAccess)Minecraft.m_91087_().m_91304_();
                for (DyeColor dc : EBEUtil.DEFAULTED_DYE_COLORS) {
                    map.put(dc, models.getModel(ModelIdentifiers.SHULKER_BOX_LIDS.get(dc)));
                }
            }));
        }
    }

    private static /* synthetic */ EBESetup[] $values() {
        return new EBESetup[0];
    }

    static {
        $VALUES = EBESetup.$values();
    }
}

