/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.rendering.animation.AnimationRenderer;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SimpleLoadingScreen
extends Screen {
    private static ResourceLocation MOJANG_LOGO_TEXTURE = new ResourceLocation("textures/gui/title/mojangstudios.png");
    private final Minecraft mc;
    private LoadingAnimationRenderer loading = new LoadingAnimationRenderer("keksuccino/animations/loading", 15, true, 0, 0, 16, 16, "konkrete", null);
    private String status = "";
    private boolean darkmode = false;

    public SimpleLoadingScreen(Minecraft mc) {
        super((Component)Component.m_237113_((String)""));
        this.mc = mc;
    }

    public void m_6305_(PoseStack matrix, int p_render_1_, int p_render_2_, float p_render_3_) {
        int color = new Color(239, 50, 61).getRGB();
        if (this.darkmode) {
            color = new Color(26, 26, 26).getRGB();
        }
        SimpleLoadingScreen.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)color);
        int j2 = (int)((double)this.mc.m_91268_().m_85445_() * 0.5);
        int i1 = (int)((double)this.mc.m_91268_().m_85446_() * 0.5);
        double d0 = Math.min((double)this.mc.m_91268_().m_85445_() * 0.75, (double)this.mc.m_91268_().m_85446_()) * 0.25;
        int j1 = (int)(d0 * 0.5);
        double d1 = d0 * 4.0;
        int k1 = (int)(d1 * 0.5);
        RenderUtils.bindTexture(MOJANG_LOGO_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SimpleLoadingScreen.m_93160_((PoseStack)matrix, (int)(j2 - k1), (int)(i1 - j1), (int)k1, (int)((int)d0), (float)-0.0625f, (float)0.0f, (int)120, (int)60, (int)120, (int)120);
        SimpleLoadingScreen.m_93160_((PoseStack)matrix, (int)j2, (int)(i1 - j1), (int)k1, (int)((int)d0), (float)0.0625f, (float)60.0f, (int)120, (int)60, (int)120, (int)120);
        this.loading.setPosX(this.f_96543_ / 2 - this.loading.getWidth() / 2);
        this.loading.setPosY(this.f_96544_ - 80);
        RenderSystem.m_157429_((float)0.0f, (float)0.733f, (float)1.0f, (float)1.0f);
        this.loading.render(matrix);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawStatus(this.status, matrix, this.f_96543_ / 2, this.loading.getPosY() + this.loading.getHeight() + 20);
        super.m_6305_(matrix, p_render_1_, p_render_2_, p_render_3_);
    }

    public boolean m_6913_() {
        return false;
    }

    public void setStatusText(String status) {
        this.status = status;
    }

    public void drawStatus(String text, PoseStack matrix, int width, int height) {
        this.mc.f_91062_.m_92883_(matrix, text, (float)(width - Minecraft.m_91087_().f_91062_.m_92895_(text) / 2), (float)height, Color.WHITE.getRGB());
    }

    public void setDarkmode(boolean b) {
        this.darkmode = b;
    }

    public void setLoadingAnimationColor(String hex) {
        this.loading.setHexColor(hex);
    }

    private static class LoadingAnimationRenderer
    extends AnimationRenderer {
        private String hex = "#ffffffff";

        public LoadingAnimationRenderer(String resourceDir, int fps, boolean loop, int posX, int posY, int width, int height, String modid, String hex) {
            super(resourceDir, fps, loop, posX, posY, width, height, modid);
            if (hex != null) {
                this.hex = hex;
            }
        }

        @Override
        protected void renderFrame(PoseStack matrix) {
            int h = this.getHeight();
            int w = this.getWidth();
            int x2 = this.getPosX();
            int y2 = this.getPosY();
            if (this.isStretchedToStreensize()) {
                h = Minecraft.m_91087_().f_91080_.f_96544_;
                w = Minecraft.m_91087_().f_91080_.f_96543_;
                x2 = 0;
                y2 = 0;
            }
            RenderUtils.bindTexture((ResourceLocation)this.resources.get(this.currentFrame()));
            RenderSystem.m_69478_();
            float[] colorf = RenderUtils.getColorFromHexString(this.hex).getComponents(new float[4]);
            if (colorf != null) {
                RenderSystem.m_157429_((float)colorf[0], (float)colorf[1], (float)colorf[2], (float)colorf[3]);
            } else {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
            }
            GuiComponent.m_93133_((PoseStack)matrix, (int)x2, (int)y2, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)w, (int)h);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69461_();
        }

        public void setHexColor(String hex) {
            this.hex = hex == null ? "#ffffffff" : hex;
        }
    }
}

