/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.end;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.block.BYGWoodTypes;
import potionstudios.byg.common.world.feature.gen.FeatureGenUtil;
import potionstudios.byg.common.world.math.OpenSimplexNoiseEnd;
import potionstudios.byg.util.BlockHelper;
import potionstudios.byg.util.MLBlockTags;
import potionstudios.byg.util.ModMathHelper;

public class EndLakeFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState END_STONE = Blocks.f_50259_.m_49966_();
    private static final OpenSimplexNoiseEnd NOISE = new OpenSimplexNoiseEnd(15152L);
    private static final BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();

    public EndLakeFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_225041_(), featurePlaceContext.m_159777_(), (NoneFeatureConfiguration)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator chunkGenerator_, RandomSource random, BlockPos blockPos, NoneFeatureConfiguration config) {
        BlockState state;
        double r;
        int y;
        int x;
        double radius = ModMathHelper.randRange(10.0, 20.0, random);
        double depth = radius * 0.5 * ModMathHelper.randRange(0.8, 1.2, random);
        int dist = ModMathHelper.floor(radius);
        int dist2 = ModMathHelper.floor(radius * 1.5);
        int bott = ModMathHelper.floor(depth);
        if ((blockPos = FeatureGenUtil.getPosOnSurfaceWG((LevelReader)world, blockPos)).m_123342_() < 10) {
            return false;
        }
        int waterLevel = blockPos.m_123342_();
        BlockPos pos = FeatureGenUtil.getPosOnSurfaceRaycast((LevelReader)world, blockPos.m_122013_(dist).m_6630_(10), 20);
        if (Math.abs(blockPos.m_123342_() - pos.m_123342_()) > 5) {
            return false;
        }
        waterLevel = ModMathHelper.min(pos.m_123342_(), waterLevel);
        pos = FeatureGenUtil.getPosOnSurfaceRaycast((LevelReader)world, blockPos.m_122020_(dist).m_6630_(10), 20);
        if (Math.abs(blockPos.m_123342_() - pos.m_123342_()) > 5) {
            return false;
        }
        waterLevel = ModMathHelper.min(pos.m_123342_(), waterLevel);
        pos = FeatureGenUtil.getPosOnSurfaceRaycast((LevelReader)world, blockPos.m_122030_(dist).m_6630_(10), 20);
        if (Math.abs(blockPos.m_123342_() - pos.m_123342_()) > 5) {
            return false;
        }
        waterLevel = ModMathHelper.min(pos.m_123342_(), waterLevel);
        pos = FeatureGenUtil.getPosOnSurfaceRaycast((LevelReader)world, blockPos.m_122025_(dist).m_6630_(10), 20);
        if (Math.abs(blockPos.m_123342_() - pos.m_123342_()) > 5) {
            return false;
        }
        waterLevel = ModMathHelper.min(pos.m_123342_(), waterLevel);
        int minX = blockPos.m_123341_() - dist2;
        int maxX = blockPos.m_123341_() + dist2;
        int minZ = blockPos.m_123343_() - dist2;
        int maxZ = blockPos.m_123343_() + dist2;
        int maskMinX = minX - 1;
        int maskMinZ = minZ - 1;
        boolean[][] mask = new boolean[maxX - minX + 3][maxZ - minZ + 3];
        for (x = minX; x <= maxX; ++x) {
            POS.m_142451_(x);
            int mx = x - maskMinX;
            block1: for (int z = minZ; z <= maxZ; ++z) {
                POS.m_142443_(z);
                int mz = z - maskMinZ;
                if (mask[mx][mz]) continue;
                for (int y2 = waterLevel + 1; y2 <= waterLevel + 20; ++y2) {
                    POS.m_142448_(y2);
                    FluidState fluid = world.m_6425_((BlockPos)POS);
                    if (fluid.m_76178_()) continue;
                    for (int i = -1; i < 2; ++i) {
                        int px = mx + i;
                        for (int j = -1; j < 2; ++j) {
                            int pz = mz + j;
                            mask[px][pz] = true;
                        }
                    }
                    continue block1;
                }
            }
        }
        for (x = minX; x <= maxX; ++x) {
            POS.m_142451_(x);
            int x2 = x - blockPos.m_123341_();
            x2 *= x2;
            int mx = x - maskMinX;
            block6: for (int z = minZ; z <= maxZ; ++z) {
                POS.m_142443_(z);
                int z2 = z - blockPos.m_123343_();
                z2 *= z2;
                int mz = z - maskMinZ;
                if (mask[mx][mz]) continue;
                double size = 1.0;
                for (y = blockPos.m_123342_(); y <= blockPos.m_123342_() + 20; ++y) {
                    POS.m_142448_(y);
                    double add = y - blockPos.m_123342_();
                    if (add > 5.0) {
                        size *= 0.8;
                        add = 5.0;
                    }
                    if (!((r = add * 1.8 + radius * (NOISE.eval((double)x * 0.2, (double)y * 0.2, (double)z * 0.2) * 0.25 + 0.75) - 1.0 / size) > 0.0)) continue block6;
                    if (!((double)(x2 + z2) <= (r *= r))) continue;
                    state = world.m_8055_((BlockPos)POS);
                    if (state.m_204336_(MLBlockTags.END_STONES)) {
                        BlockHelper.setWithoutUpdate((LevelWriter)world, (BlockPos)POS, Blocks.f_50016_.m_49966_());
                    }
                    if (!world.m_8055_(pos = POS.m_7495_()).m_204336_(MLBlockTags.END_STONES)) continue;
                    if (y > waterLevel + 1) {
                        BlockHelper.setWithoutUpdate((LevelWriter)world, pos, state);
                        continue;
                    }
                    if (y > waterLevel) {
                        BlockHelper.setWithoutUpdate((LevelWriter)world, pos, random.m_188499_() ? state : BYGBlocks.END_SAND.defaultBlockState());
                        continue;
                    }
                    BlockHelper.setWithoutUpdate((LevelWriter)world, pos, BYGBlocks.END_SAND.defaultBlockState());
                }
            }
        }
        double aspect = radius / depth;
        for (int x2 = blockPos.m_123341_() - dist; x2 <= blockPos.m_123341_() + dist; ++x2) {
            POS.m_142451_(x2);
            int x22 = x2 - blockPos.m_123341_();
            x22 *= x22;
            int mx = x2 - maskMinX;
            for (int z = blockPos.m_123343_() - dist; z <= blockPos.m_123343_() + dist; ++z) {
                POS.m_142443_(z);
                int z2 = z - blockPos.m_123343_();
                z2 *= z2;
                int mz = z - maskMinZ;
                if (mask[mx][mz]) continue;
                for (y = blockPos.m_123342_() - bott; y < blockPos.m_123342_(); ++y) {
                    POS.m_142448_(y);
                    double y2 = (double)(y - blockPos.m_123342_()) * aspect;
                    y2 *= y2;
                    r = radius * (NOISE.eval((double)x2 * 0.2, (double)y * 0.2, (double)z * 0.2) * 0.25 + 0.75);
                    double rb = r * 1.2;
                    r *= r;
                    rb *= rb;
                    if (y2 + (double)x22 + (double)z2 <= r) {
                        state = world.m_8055_((BlockPos)POS);
                        if (this.canReplace(state)) {
                            state = world.m_8055_(POS.m_7494_());
                            state = this.canReplace(state) ? (y < waterLevel ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_()) : state;
                            BlockHelper.setWithoutUpdate((LevelWriter)world, (BlockPos)POS, state);
                        }
                        if (world.m_8055_(pos = POS.m_7495_()).m_204336_(MLBlockTags.END_STONES)) {
                            BlockHelper.setWithoutUpdate((LevelWriter)world, pos, BYGBlocks.END_SAND.defaultBlockState());
                        }
                        pos = POS.m_7494_();
                        while (this.canReplace(state = world.m_8055_(pos)) && !state.m_60795_() && state.m_60819_().m_76178_()) {
                            BlockHelper.setWithoutUpdate((LevelWriter)world, pos, pos.m_123342_() < waterLevel ? Blocks.f_49990_ : Blocks.f_50016_);
                            pos = pos.m_7494_();
                        }
                        continue;
                    }
                    if (y >= waterLevel || !(y2 + (double)x22 + (double)z2 <= rb)) continue;
                    if (world.m_46859_(POS.m_7494_())) {
                        state = Blocks.f_50259_.m_49966_();
                        BlockHelper.setWithoutUpdate((LevelWriter)world, (BlockPos)POS, random.m_188499_() ? state : BYGBlocks.END_SAND.defaultBlockState());
                        BlockHelper.setWithoutUpdate((LevelWriter)world, POS.m_7495_(), END_STONE);
                        continue;
                    }
                    BlockHelper.setWithoutUpdate((LevelWriter)world, (BlockPos)POS, BYGBlocks.END_SAND.defaultBlockState());
                    BlockHelper.setWithoutUpdate((LevelWriter)world, POS.m_7495_(), END_STONE);
                }
            }
        }
        BlockHelper.fixBlocks((LevelAccessor)world, new BlockPos(minX - 2, waterLevel - 2, minZ - 2), new BlockPos(maxX + 2, blockPos.m_123342_() + 20, maxZ + 2));
        return true;
    }

    private boolean canReplace(BlockState state) {
        return state.m_60767_().m_76336_() || state.m_204336_(MLBlockTags.END_STONES) || state.m_204336_(MLBlockTags.ORES) || state.m_60713_((Block)BYGBlocks.IMPARIUS_BUSH.get()) || state.m_60713_((Block)BYGWoodTypes.IMPARIUS.growerItem().get()) || state.m_60713_((Block)BYGBlocks.FUNGAL_IMPARIUS.get()) || state.m_60713_((Block)BYGBlocks.END_SAND.get()) || state.m_60767_().equals(Material.f_76300_) || state.m_60767_().equals(Material.f_76301_) || state.m_60767_().equals(Material.f_76304_);
    }
}

