/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.framebuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.texture.TextureInfoCache;

public class GlFramebuffer
extends GlResource {
    private final Int2IntMap attachments = new Int2IntArrayMap();
    private final int maxDrawBuffers = GlStateManager._getInteger((int)34852);
    private final int maxColorAttachments = GlStateManager._getInteger((int)36063);
    private boolean hasDepthAttachment = false;

    public GlFramebuffer() {
        super(IrisRenderSystem.createFramebuffer());
    }

    public void addDepthAttachment(int n) {
        int n2 = TextureInfoCache.INSTANCE.getInfo(n).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(n2);
        int n3 = this.getGlId();
        if (depthBufferFormat.isCombinedStencil()) {
            IrisRenderSystem.framebufferTexture2D(n3, 36160, 33306, 3553, n, 0);
        } else {
            IrisRenderSystem.framebufferTexture2D(n3, 36160, 36096, 3553, n, 0);
        }
        this.hasDepthAttachment = true;
    }

    public void addColorAttachment(int n, int n2) {
        int n3 = this.getGlId();
        IrisRenderSystem.framebufferTexture2D(n3, 36160, 36064 + n, 3553, n2, 0);
        this.attachments.put(n, n2);
    }

    public void noDrawBuffers() {
        IrisRenderSystem.drawBuffers(this.getGlId(), new int[]{0});
    }

    public void drawBuffers(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        if (nArray.length > this.maxDrawBuffers) {
            throw new IllegalArgumentException("Cannot write to more than " + this.maxDrawBuffers + " draw buffers on this GPU");
        }
        for (int n2 : nArray) {
            if (n2 >= this.maxColorAttachments) {
                throw new IllegalArgumentException("Only " + this.maxColorAttachments + " color attachments are supported on this GPU, but an attempt was made to write to a color attachment with index " + n2);
            }
            nArray2[n++] = 36064 + n2;
        }
        IrisRenderSystem.drawBuffers(this.getGlId(), nArray2);
    }

    public void readBuffer(int n) {
        IrisRenderSystem.readBuffer(this.getGlId(), 36064 + n);
    }

    public int getColorAttachment(int n) {
        return this.attachments.get(n);
    }

    public boolean hasDepthAttachment() {
        return this.hasDepthAttachment;
    }

    public void bind() {
        GlStateManager._glBindFramebuffer((int)36160, (int)this.getGlId());
    }

    public void bindAsReadBuffer() {
        GlStateManager._glBindFramebuffer((int)36008, (int)this.getGlId());
    }

    public void bindAsDrawBuffer() {
        GlStateManager._glBindFramebuffer((int)36009, (int)this.getGlId());
    }

    @Override
    protected void destroyInternal() {
        GlStateManager._glDeleteFramebuffers((int)this.getGlId());
    }

    public int getStatus() {
        this.bind();
        int n = GlStateManager.glCheckFramebufferStatus((int)36160);
        return n;
    }

    public int getId() {
        return this.getGlId();
    }
}

