/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.debug;

import java.util.Objects;
import net.coderbot.iris.gl.shader.ShaderCompileException;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7528;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_7940;

public class DebugTextWidget
extends class_7528 {
    private final class_327 font;
    private Content content;

    public DebugTextWidget(int n, int n2, int n3, int n4, class_327 class_3272, Exception exception) {
        super(n, n2, n3, n4, (class_2561)class_2561.method_43473());
        this.font = class_3272;
        this.content = this.buildContent(exception);
    }

    private Content buildContent(Exception exception) {
        if (exception instanceof ShaderCompileException) {
            ShaderCompileException shaderCompileException = (ShaderCompileException)exception;
            return this.buildContentShader(shaderCompileException);
        }
        ContentBuilder contentBuilder = new ContentBuilder(this.containerWidth());
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        contentBuilder.addHeader(this.font, (class_2561)class_2561.method_43470((String)"Error: "));
        Objects.requireNonNull(this.font);
        contentBuilder.addSpacer(9);
        if (exception.getMessage() != null) {
            contentBuilder.addLine(this.font, (class_2561)class_2561.method_43470((String)exception.getMessage()));
        }
        Objects.requireNonNull(this.font);
        contentBuilder.addSpacer(9);
        contentBuilder.addHeader(this.font, (class_2561)class_2561.method_43470((String)"Stack trace: "));
        Objects.requireNonNull(this.font);
        contentBuilder.addSpacer(9);
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            if (stackTraceElement == null) continue;
            contentBuilder.addLine(this.font, (class_2561)class_2561.method_43470((String)stackTraceElement.toString()));
            if (i >= stackTraceElementArray.length - 1) continue;
            Objects.requireNonNull(this.font);
            contentBuilder.addSpacer(9);
        }
        return contentBuilder.build();
    }

    private Content buildContentShader(ShaderCompileException shaderCompileException) {
        ContentBuilder contentBuilder = new ContentBuilder(this.containerWidth());
        contentBuilder.addHeader(this.font, (class_2561)class_2561.method_43470((String)("Shader compile error in " + shaderCompileException.getFilename() + ": ")));
        Objects.requireNonNull(this.font);
        contentBuilder.addSpacer(9);
        contentBuilder.addLine(this.font, (class_2561)class_2561.method_43470((String)shaderCompileException.getError()));
        return contentBuilder.build();
    }

    protected int method_44391() {
        return this.content.container().method_25364();
    }

    protected boolean method_44392() {
        return this.method_44391() > this.field_22759;
    }

    protected double method_44393() {
        Objects.requireNonNull(this.font);
        return 9.0;
    }

    protected void method_44389(class_4587 class_45872, int n, int n2, float f) {
        int n3 = this.method_46427() + this.method_44381();
        int n4 = this.method_46426() + this.method_44381();
        class_45872.method_22903();
        class_45872.method_22904((double)n4, (double)n3, 0.0);
        this.content.container().method_25394(class_45872, n, n2, f);
        class_45872.method_22909();
    }

    protected void method_47399(class_6382 class_63822) {
        class_63822.method_37034(class_6381.field_33788, this.content.narration());
    }

    private int containerWidth() {
        return this.field_22758 - this.method_44385();
    }

    record Content(class_7845 container, class_2561 narration) {
    }

    static class ContentBuilder {
        private final int width;
        private final class_7845 grid;
        private final class_7845.class_7939 helper;
        private final class_7847 alignHeader;
        private final class_5250 narration = class_2561.method_43473();

        public ContentBuilder(int n) {
            this.width = n;
            this.grid = new class_7845();
            this.grid.method_46458().method_46461();
            this.helper = this.grid.method_47610(1);
            this.helper.method_47612(class_7852.method_46512((int)n));
            this.alignHeader = this.helper.method_47611().method_46467().method_46477(32);
        }

        public void addLine(class_327 class_3272, class_2561 class_25612) {
            this.addLine(class_3272, class_25612, 0);
        }

        public void addLine(class_327 class_3272, class_2561 class_25612, int n) {
            this.helper.method_47615((class_339)class_7940.method_47618((int)this.width, (class_327)class_3272, (class_2561)class_25612), this.helper.method_47611().method_46475(n));
            this.narration.method_10852(class_25612).method_27693("\n");
        }

        public void addHeader(class_327 class_3272, class_2561 class_25612) {
            this.helper.method_47615((class_339)class_7940.method_47617((int)(this.width - 64), (class_327)class_3272, (class_2561)class_25612), this.alignHeader);
            this.narration.method_10852(class_25612).method_27693("\n");
        }

        public void addSpacer(int n) {
            this.helper.method_47612(class_7852.method_46513((int)n));
        }

        public Content build() {
            this.grid.method_46456();
            return new Content(this.grid, (class_2561)this.narration);
        }
    }
}

