/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import it.unimi.dsi.fastutil.ints.Int2ByteOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.concurrent.locks.StampedLock;
import net.caffeinemc.phosphor.common.chunk.light.IReadonly;
import net.caffeinemc.phosphor.common.chunk.light.LevelPropagatorAccess;
import net.caffeinemc.phosphor.common.chunk.light.LightProviderUpdateTracker;
import net.caffeinemc.phosphor.common.chunk.light.LightStorageAccess;
import net.caffeinemc.phosphor.common.util.chunk.light.EmptyChunkNibbleArray;
import net.caffeinemc.phosphor.common.util.math.ChunkSectionPosHelper;
import net.minecraft.class_156;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2804;
import net.minecraft.class_2823;
import net.minecraft.class_3556;
import net.minecraft.class_3558;
import net.minecraft.class_3560;
import net.minecraft.class_4076;
import net.minecraft.class_4079;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3560.class})
public abstract class MixinLightStorage
extends class_4079
implements LightStorageAccess {
    @Shadow
    @Final
    protected class_3556<?> field_15796;
    @Mutable
    @Shadow
    @Final
    protected LongSet field_15802;
    @Mutable
    @Shadow
    @Final
    protected LongSet field_16448;
    @Mutable
    @Shadow
    @Final
    protected LongSet field_15808;
    @Mutable
    @Shadow
    @Final
    protected LongSet field_15804;
    @Mutable
    @Shadow
    @Final
    protected LongSet field_15797;
    @Shadow
    protected volatile boolean field_15800;
    @Shadow
    protected volatile class_3556<?> field_15806;
    @Shadow
    @Final
    protected Long2ObjectMap<class_2804> field_15807;
    @Shadow
    @Final
    private static class_2350[] field_15799;
    @Shadow
    @Final
    private class_2823 field_15803;
    @Shadow
    @Final
    private class_1944 field_15805;
    @Shadow
    @Final
    private LongSet field_25621;
    @Unique
    private final Long2ObjectMap<Int2ByteMap> trackedSectionsByChunk = new Long2ObjectOpenHashMap();
    @Unique
    protected final StampedLock uncachedLightArraysLock = new StampedLock();
    @Unique
    protected final LongSet enabledChunks = new LongOpenHashSet();
    @Unique
    protected final Long2IntMap lightmapComplexities = (Long2IntMap)class_156.method_654((Object)new Long2IntOpenHashMap(), map -> map.defaultReturnValue(-1));
    @Unique
    private final LongSet markedEnabledChunks = new LongOpenHashSet();
    @Unique
    private final LongSet trivialLightmaps = new LongOpenHashSet();
    @Unique
    private final LongSet vanillaLightmapsToRemove = new LongOpenHashSet();
    @Unique
    protected final LongSet nonOptimizableSections = new LongOpenHashSet();

    protected MixinLightStorage() {
        super(0, 0, 0);
    }

    @Shadow
    protected abstract int method_15480(long var1);

    @Shadow
    protected abstract void method_15523(long var1);

    @Shadow
    protected abstract class_2804 method_15529(long var1);

    @Shadow
    protected abstract boolean method_15528();

    @Shadow
    protected abstract void method_15534(long var1);

    @Shadow
    protected abstract void method_15536(class_3558<?, ?> var1, long var2);

    @Shadow
    protected abstract class_2804 method_15522(long var1, boolean var3);

    @Unique
    protected void trackSection(long sectionPos) {
        this.trackSection(class_4076.method_18693((long)sectionPos), class_4076.method_18689((long)sectionPos));
    }

    @Unique
    protected void trackSection(long chunkPos, int y) {
        Int2ByteMap sections = (Int2ByteMap)this.trackedSectionsByChunk.computeIfAbsent(chunkPos, __ -> new Int2ByteOpenHashMap());
        sections.put(y, (byte)(sections.get(y) + 1));
    }

    @Unique
    protected void untrackSection(long sectionPos) {
        this.untrackSection(class_4076.method_18693((long)sectionPos), class_4076.method_18689((long)sectionPos));
    }

    @Unique
    protected void untrackSection(long chunkPos, int y) {
        Int2ByteMap sections = (Int2ByteMap)this.trackedSectionsByChunk.get(chunkPos);
        byte count = (byte)(sections.get(y) - 1);
        if (count == 0) {
            sections.remove(y);
            if (sections.isEmpty()) {
                this.trackedSectionsByChunk.remove(chunkPos);
            }
        } else {
            sections.put(y, count);
        }
    }

    @Unique
    protected IntIterator getTrackedSections(long chunkPos) {
        Int2ByteMap sections = (Int2ByteMap)this.trackedSectionsByChunk.get(chunkPos);
        return sections == null ? IntIterators.EMPTY_ITERATOR : IntIterators.wrap((int[])sections.keySet().toIntArray());
    }

    @Overwrite
    public int method_15537(long blockPos) {
        int x = class_2338.method_10061((long)blockPos);
        int y = class_2338.method_10071((long)blockPos);
        int z = class_2338.method_10083((long)blockPos);
        long chunk = class_4076.method_18685((int)class_4076.method_18675((int)x), (int)class_4076.method_18675((int)y), (int)class_4076.method_18675((int)z));
        class_2804 array = this.method_15522(chunk, true);
        if (array == null) {
            return this.getLightWithoutLightmap(blockPos);
        }
        return array.method_12139(class_4076.method_18684((int)x), class_4076.method_18684((int)y), class_4076.method_18684((int)z));
    }

    @Overwrite
    public void method_15525(long blockPos, int value) {
        int x = class_2338.method_10061((long)blockPos);
        int y = class_2338.method_10071((long)blockPos);
        int z = class_2338.method_10083((long)blockPos);
        long chunkPos = class_4076.method_18685((int)(x >> 4), (int)(y >> 4), (int)(z >> 4));
        class_2804 lightmap = this.getOrAddLightmap(chunkPos);
        int oldVal = lightmap.method_12139(x & 0xF, y & 0xF, z & 0xF);
        this.beforeLightChange(blockPos, oldVal, value, lightmap);
        this.changeLightmapComplexity(chunkPos, this.getLightmapComplexityChange(blockPos, oldVal, value, lightmap));
        if (this.field_15802.add(chunkPos)) {
            this.field_15796.method_15502(chunkPos);
        }
        class_2804 nibble = this.method_15522(chunkPos, true);
        nibble.method_12145(x & 0xF, y & 0xF, z & 0xF, value);
        for (int z2 = z - 1 >> 4; z2 <= z + 1 >> 4; ++z2) {
            for (int x2 = x - 1 >> 4; x2 <= x + 1 >> 4; ++x2) {
                for (int y2 = y - 1 >> 4; y2 <= y + 1 >> 4; ++y2) {
                    this.field_16448.add(class_4076.method_18685((int)x2, (int)y2, (int)z2));
                }
            }
        }
    }

    @Overwrite
    public void method_15485(long id, int level) {
        int oldLevel = this.method_15480(id);
        if (oldLevel != 0 && level == 0) {
            this.field_15808.add(id);
            this.field_15804.remove(id);
        }
        if (oldLevel == 0 && level != 0) {
            this.field_15808.remove(id);
            this.field_15797.remove(id);
            this.untrackSection(id);
        }
        if (oldLevel >= 2 && level < 2) {
            this.nonOptimizableSections.add(id);
            if (this.enabledChunks.contains(class_4076.method_18693((long)id))) {
                if (!this.vanillaLightmapsToRemove.remove(id)) {
                    if (this.method_15522(id, true) == null) {
                        this.field_15796.method_15499(id, this.createTrivialVanillaLightmap(id));
                        this.field_15802.add(id);
                        this.field_15796.method_15505();
                    }
                    this.trackSection(id);
                }
            } else {
                this.trackSection(id);
            }
        }
        if (oldLevel < 2 && level >= 2) {
            this.nonOptimizableSections.remove(id);
            if (this.enabledChunks.contains(class_4076.method_18693((long)id))) {
                class_2804 lightmap = this.method_15522(id, true);
                if (lightmap != null && ((IReadonly)lightmap).isReadonly()) {
                    this.vanillaLightmapsToRemove.add(id);
                    this.markForLightUpdates();
                } else {
                    this.untrackSection(id);
                }
            } else {
                this.untrackSection(id);
            }
        }
    }

    @Inject(method={"removeSection"}, at={@At(value="HEAD")}, cancellable=true)
    protected void preRemoveSection(class_3558<?, ?> provider, long pos, CallbackInfo ci) {
        if (provider instanceof LightProviderUpdateTracker) {
            ((LightProviderUpdateTracker)provider).cancelUpdatesForChunk(pos);
            ci.cancel();
        }
    }

    @Override
    public void runCleanups() {
        this.runCleanups(null);
    }

    @Unique
    protected void runCleanups(class_3558<?, ?> lightProvider) {
        if (!this.field_15800) {
            return;
        }
        this.removeTrivialLightmaps(lightProvider);
        this.removeVanillaLightmaps(lightProvider);
        if (lightProvider == null) {
            this.checkForUpdates();
        }
    }

    @Overwrite
    public void method_15527(class_3558<?, ?> lightProvider, boolean doSkylight, boolean skipEdgeLightPropagation) {
        if (!this.method_15528()) {
            return;
        }
        this.initializeChunks();
        this.addQueuedLightmaps(lightProvider);
        this.runCleanups(lightProvider);
        LongIterator it = !skipEdgeLightPropagation ? this.field_15807.keySet().iterator() : this.field_25621.iterator();
        while (it.hasNext()) {
            this.method_29967(lightProvider, it.nextLong());
        }
        this.field_25621.clear();
        this.field_15807.clear();
        this.field_15800 = false;
    }

    @Overwrite
    private void method_29967(class_3558<?, ?> chunkLightProvider, long pos) {
        if (this.method_15524(pos)) {
            LevelPropagatorAccess levelPropagator = (LevelPropagatorAccess)chunkLightProvider;
            int x = class_4076.method_18688((int)class_4076.method_18686((long)pos));
            int y = class_4076.method_18688((int)class_4076.method_18689((long)pos));
            int z = class_4076.method_18688((int)class_4076.method_18690((long)pos));
            for (class_2350 dir : field_15799) {
                long adjPos = class_4076.method_18679((long)pos, (class_2350)dir);
                if (this.field_15807.containsKey(adjPos) || !this.method_15524(adjPos)) continue;
                for (int u1 = 0; u1 < 16; ++u1) {
                    block10: for (int u2 = 0; u2 < 16; ++u2) {
                        long b;
                        long a;
                        switch (dir) {
                            case field_11033: {
                                a = class_2338.method_10064((int)(x + u2), (int)y, (int)(z + u1));
                                b = class_2338.method_10064((int)(x + u2), (int)(y - 1), (int)(z + u1));
                                break;
                            }
                            case field_11036: {
                                a = class_2338.method_10064((int)(x + u2), (int)(y + 15), (int)(z + u1));
                                b = class_2338.method_10064((int)(x + u2), (int)(y + 16), (int)(z + u1));
                                break;
                            }
                            case field_11043: {
                                a = class_2338.method_10064((int)(x + u1), (int)(y + u2), (int)z);
                                b = class_2338.method_10064((int)(x + u1), (int)(y + u2), (int)(z - 1));
                                break;
                            }
                            case field_11035: {
                                a = class_2338.method_10064((int)(x + u1), (int)(y + u2), (int)(z + 15));
                                b = class_2338.method_10064((int)(x + u1), (int)(y + u2), (int)(z + 16));
                                break;
                            }
                            case field_11039: {
                                a = class_2338.method_10064((int)x, (int)(y + u1), (int)(z + u2));
                                b = class_2338.method_10064((int)(x - 1), (int)(y + u1), (int)(z + u2));
                                break;
                            }
                            case field_11034: {
                                a = class_2338.method_10064((int)(x + 15), (int)(y + u1), (int)(z + u2));
                                b = class_2338.method_10064((int)(x + 16), (int)(y + u1), (int)(z + u2));
                                break;
                            }
                            default: {
                                continue block10;
                            }
                        }
                        levelPropagator.propagateLevel(a, b, false);
                        levelPropagator.propagateLevel(b, a, false);
                    }
                }
            }
            levelPropagator.checkForUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void method_15530() {
        if (!this.field_15802.isEmpty()) {
            long stamp = this.uncachedLightArraysLock.writeLock();
            try {
                class_3556 map = this.field_15796.method_15504();
                map.method_16188();
                this.field_15806 = map;
            }
            finally {
                this.uncachedLightArraysLock.unlockWrite(stamp);
            }
            this.field_15802.clear();
        }
        if (!this.field_16448.isEmpty()) {
            LongIterator it = this.field_16448.iterator();
            while (it.hasNext()) {
                long pos = it.nextLong();
                this.field_15803.method_12247(this.field_15805, class_4076.method_18677((long)pos));
            }
            this.field_16448.clear();
        }
    }

    @Unique
    protected int getLightWithoutLightmap(long blockPos) {
        return 0;
    }

    @Unique
    protected void beforeChunkEnabled(long chunkPos) {
        IntIterator it = this.getTrackedSections(chunkPos);
        while (it.hasNext()) {
            long sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, it.nextInt());
            if (!this.hasLightmap(sectionPos)) continue;
            this.method_15523(sectionPos);
        }
    }

    @Unique
    protected void afterChunkDisabled(long chunkPos, IntIterable removedLightmaps) {
        IntIterator it = removedLightmaps.iterator();
        while (it.hasNext()) {
            this.method_15534(ChunkSectionPosHelper.updateYLong(chunkPos, it.nextInt()));
        }
    }

    @Unique
    protected class_2804 getOrAddLightmap(long sectionPos) {
        class_2804 lightmap = this.method_15522(sectionPos, true);
        if (lightmap == null) {
            lightmap = this.method_15529(sectionPos);
        } else if (((IReadonly)lightmap).isReadonly()) {
            lightmap = lightmap.method_12144();
            if (this.vanillaLightmapsToRemove.remove(sectionPos)) {
                this.untrackSection(sectionPos);
            }
        } else {
            return lightmap;
        }
        this.field_15796.method_15499(sectionPos, lightmap);
        this.trackSection(sectionPos);
        this.field_15802.add(sectionPos);
        this.field_15796.method_15505();
        this.method_15523(sectionPos);
        this.setLightmapComplexity(sectionPos, 0);
        return lightmap;
    }

    @Unique
    protected void setLightmapComplexity(long sectionPos, int complexity) {
        int oldComplexity = this.lightmapComplexities.put(sectionPos, complexity);
        if (oldComplexity == 0) {
            this.trivialLightmaps.remove(sectionPos);
        }
        if (complexity == 0) {
            this.trivialLightmaps.add(sectionPos);
            this.markForLightUpdates();
        }
    }

    @Unique
    private void checkForUpdates() {
        this.field_15800 = !this.trivialLightmaps.isEmpty() || !this.vanillaLightmapsToRemove.isEmpty() || !this.markedEnabledChunks.isEmpty() || !this.field_15807.isEmpty();
    }

    @Unique
    private void markForLightUpdates() {
        if (!this.field_15800) {
            this.field_15800 = true;
        }
    }

    @Unique
    protected void changeLightmapComplexity(long sectionPos, int amount) {
        int complexity = this.lightmapComplexities.get(sectionPos);
        if (complexity == 0) {
            this.trivialLightmaps.remove(sectionPos);
        }
        this.lightmapComplexities.put(sectionPos, complexity += amount);
        if (complexity == 0) {
            this.trivialLightmaps.add(sectionPos);
            this.markForLightUpdates();
        }
    }

    @Unique
    protected class_2804 getLightmap(long sectionPos) {
        class_2804 lightmap = this.method_15522(sectionPos, true);
        return lightmap == null || ((IReadonly)lightmap).isReadonly() ? null : lightmap;
    }

    @Unique
    protected boolean hasLightmap(long sectionPos) {
        return this.getLightmap(sectionPos) != null;
    }

    @Unique
    protected void beforeLightChange(long blockPos, int oldVal, int newVal, class_2804 lightmap) {
    }

    @Unique
    protected int getLightmapComplexityChange(long blockPos, int oldVal, int newVal, class_2804 lightmap) {
        return 0;
    }

    @Unique
    protected void beforeLightmapChange(long sectionPos, class_2804 oldLightmap, class_2804 newLightmap) {
    }

    @Unique
    protected int getInitialLightmapComplexity(long sectionPos, class_2804 lightmap) {
        return 0;
    }

    @Override
    @Invoker(value="hasSection")
    public abstract boolean callHasSection(long var1);

    @Overwrite
    public boolean method_15524(long sectionPos) {
        return this.enabledChunks.contains(class_4076.method_18693((long)sectionPos));
    }

    @Shadow
    protected abstract void method_15535(long var1, boolean var3);

    @Overwrite
    public void method_15526(long sectionPos, boolean notReady) {
        if (notReady) {
            if (this.field_15804.remove(sectionPos)) {
                this.untrackSection(sectionPos);
            } else if (!this.field_15808.contains(sectionPos) || !this.field_15797.add(sectionPos)) {
                return;
            }
            this.method_15478(Long.MAX_VALUE, sectionPos, 2, false);
        } else {
            if (!this.field_15797.remove(sectionPos)) {
                if (this.field_15808.contains(sectionPos) || !this.field_15804.add(sectionPos)) {
                    return;
                }
                this.trackSection(sectionPos);
            }
            this.method_15478(Long.MAX_VALUE, sectionPos, 0, true);
        }
    }

    @Override
    @Invoker(value="setColumnEnabled")
    public abstract void invokeSetColumnEnabled(long var1, boolean var3);

    @Override
    public void enableLightUpdates(long chunkPos) {
        if (!this.enabledChunks.contains(chunkPos)) {
            this.markedEnabledChunks.add(chunkPos);
            this.markForLightUpdates();
        }
    }

    @Unique
    private void initializeChunks() {
        this.field_15796.method_15505();
        LongIterator cit = this.markedEnabledChunks.iterator();
        while (cit.hasNext()) {
            long sectionPos;
            long chunkPos = cit.nextLong();
            this.beforeChunkEnabled(chunkPos);
            IntIterator it = this.getTrackedSections(chunkPos);
            while (it.hasNext()) {
                sectionPos = class_4076.method_18685((int)class_4076.method_18686((long)chunkPos), (int)it.nextInt(), (int)class_4076.method_18690((long)chunkPos));
                if (!this.hasLightmap(sectionPos)) continue;
                this.setLightmapComplexity(sectionPos, this.getInitialLightmapComplexity(sectionPos, this.method_15522(sectionPos, true)));
            }
            it = this.getTrackedSections(chunkPos);
            while (it.hasNext()) {
                sectionPos = class_4076.method_18685((int)class_4076.method_18686((long)chunkPos), (int)it.nextInt(), (int)class_4076.method_18690((long)chunkPos));
                if (!this.nonOptimizableSections.contains(sectionPos) || this.method_15522(sectionPos, true) != null) continue;
                this.field_15796.method_15499(sectionPos, this.createInitialVanillaLightmap(sectionPos));
                this.field_15802.add(sectionPos);
            }
            this.enabledChunks.add(chunkPos);
        }
        this.field_15796.method_15505();
        this.markedEnabledChunks.clear();
    }

    @Unique
    protected class_2804 createInitialVanillaLightmap(long sectionPos) {
        return this.createTrivialVanillaLightmap(sectionPos);
    }

    @Unique
    protected class_2804 createTrivialVanillaLightmap(long sectionPos) {
        return new EmptyChunkNibbleArray();
    }

    @Override
    public void disableChunkLight(long chunkPos, class_3558<?, ?> lightProvider) {
        if (this.markedEnabledChunks.remove(chunkPos) || !this.enabledChunks.contains(chunkPos)) {
            IntIterator it = this.getTrackedSections(chunkPos);
            while (it.hasNext()) {
                int y = it.nextInt();
                long sectionPos2 = class_4076.method_18685((int)class_4076.method_18686((long)chunkPos), (int)y, (int)class_4076.method_18690((long)chunkPos));
                if (this.field_15796.method_15500(sectionPos2) == null) continue;
                this.untrackSection(chunkPos, y);
                this.field_15802.add(sectionPos2);
            }
            this.method_15535(chunkPos, false);
            this.removeBlockData(chunkPos);
        } else {
            IntIterator it = this.getTrackedSections(chunkPos);
            while (it.hasNext()) {
                long sectionPos3 = class_4076.method_18685((int)class_4076.method_18686((long)chunkPos), (int)it.nextInt(), (int)class_4076.method_18690((long)chunkPos));
                if (!this.method_15524(sectionPos3)) continue;
                this.method_15536(lightProvider, sectionPos3);
            }
            this.enabledChunks.remove(chunkPos);
            IntArrayList removedLightmaps = new IntArrayList();
            IntIterator it2 = this.getTrackedSections(chunkPos);
            while (it2.hasNext()) {
                int y = it2.nextInt();
                long sectionPos4 = ChunkSectionPosHelper.updateYLong(chunkPos, y);
                if (!this.removeLightmap(sectionPos4)) continue;
                removedLightmaps.add(y);
            }
            this.field_15807.keySet().removeIf(sectionPos -> class_4076.method_18693((long)sectionPos) == chunkPos);
            this.field_25621.removeIf(sectionPos -> class_4076.method_18693((long)sectionPos) == chunkPos);
            this.field_15796.method_15505();
            this.method_15535(chunkPos, false);
            this.afterChunkDisabled(chunkPos, (IntIterable)removedLightmaps);
            this.removeBlockData(chunkPos);
        }
    }

    @Unique
    protected boolean removeLightmap(long sectionPos) {
        if (this.field_15796.method_15500(sectionPos) == null) {
            return false;
        }
        this.field_15802.add(sectionPos);
        if (this.lightmapComplexities.remove(sectionPos) == -1) {
            if (this.vanillaLightmapsToRemove.remove(sectionPos)) {
                this.untrackSection(sectionPos);
            }
            return false;
        }
        this.trivialLightmaps.remove(sectionPos);
        this.untrackSection(sectionPos);
        return true;
    }

    @Unique
    private void removeBlockData(long chunkPos) {
        IntIterator it = this.getTrackedSections(chunkPos);
        while (it.hasNext()) {
            this.method_15526(ChunkSectionPosHelper.updateYLong(chunkPos, it.nextInt()), true);
        }
    }

    @Unique
    private void removeTrivialLightmaps(class_3558<?, ?> lightProvider) {
        long sectionPos;
        LongIterator it = this.trivialLightmaps.iterator();
        while (it.hasNext()) {
            sectionPos = it.nextLong();
            this.field_15796.method_15500(sectionPos);
            this.lightmapComplexities.remove(sectionPos);
            this.untrackSection(sectionPos);
            this.field_15802.add(sectionPos);
        }
        this.field_15796.method_15505();
        it = this.trivialLightmaps.iterator();
        while (it.hasNext()) {
            this.method_15534(it.nextLong());
        }
        it = this.trivialLightmaps.iterator();
        while (it.hasNext()) {
            sectionPos = it.nextLong();
            if (!this.nonOptimizableSections.contains(sectionPos)) continue;
            this.field_15796.method_15499(sectionPos, this.createTrivialVanillaLightmap(sectionPos));
        }
        this.field_15796.method_15505();
        if (lightProvider != null) {
            it = this.trivialLightmaps.iterator();
            while (it.hasNext()) {
                sectionPos = it.nextLong();
                if (this.method_15524(sectionPos)) continue;
                this.method_15536(lightProvider, sectionPos);
            }
        }
        this.trivialLightmaps.clear();
    }

    @Unique
    private void removeVanillaLightmaps(class_3558<?, ?> lightProvider) {
        long sectionPos;
        LongIterator it = this.vanillaLightmapsToRemove.iterator();
        while (it.hasNext()) {
            sectionPos = it.nextLong();
            this.field_15796.method_15500(sectionPos);
            this.untrackSection(sectionPos);
            this.field_15802.add(sectionPos);
        }
        this.field_15796.method_15505();
        if (lightProvider != null) {
            it = this.vanillaLightmapsToRemove.iterator();
            while (it.hasNext()) {
                sectionPos = it.nextLong();
                if (this.method_15524(sectionPos)) continue;
                this.method_15536(lightProvider, sectionPos);
            }
        }
        this.vanillaLightmapsToRemove.clear();
    }

    @Unique
    private void addQueuedLightmaps(class_3558<?, ?> lightProvider) {
        ObjectIterator it = Long2ObjectMaps.fastIterator(this.field_15807);
        while (it.hasNext()) {
            class_2804 oldLightmap;
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
            long sectionPos = entry.getLongKey();
            class_2804 lightmap = (class_2804)entry.getValue();
            if (lightmap == (oldLightmap = this.getLightmap(sectionPos))) continue;
            this.method_15536(lightProvider, sectionPos);
            this.beforeLightmapChange(sectionPos, oldLightmap, lightmap);
            this.field_15796.method_15499(sectionPos, lightmap);
            this.field_15796.method_15505();
            this.field_15802.add(sectionPos);
            if (oldLightmap == null) {
                this.trackSection(sectionPos);
                this.method_15523(sectionPos);
            }
            if (this.vanillaLightmapsToRemove.remove(sectionPos)) {
                this.untrackSection(sectionPos);
            }
            this.setLightmapComplexity(sectionPos, this.getInitialLightmapComplexity(sectionPos, lightmap));
        }
    }

    @Overwrite
    public void method_15532(long sectionPos, class_2804 array, boolean bl) {
        boolean chunkEnabled = this.enabledChunks.contains(class_4076.method_18693((long)sectionPos));
        if (array != null) {
            if (chunkEnabled) {
                this.field_15807.put(sectionPos, (Object)array);
                this.markForLightUpdates();
            } else {
                this.field_15796.method_15499(sectionPos, array);
                this.trackSection(sectionPos);
                this.field_15802.add(sectionPos);
            }
            if (!bl) {
                this.field_25621.add(sectionPos);
            }
        } else if (chunkEnabled) {
            this.field_15807.remove(sectionPos);
        } else if (this.field_15796.method_15500(sectionPos) != null) {
            this.untrackSection(sectionPos);
            this.field_15802.add(sectionPos);
        }
    }

    @Redirect(method={"createSection(J)Lnet/minecraft/world/chunk/ChunkNibbleArray;"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/chunk/light/LightStorage;queuedSections:Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", opcode=180)), at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;get(J)Ljava/lang/Object;", ordinal=0, remap=false))
    private Object cancelLightmapLookupFromQueue(Long2ObjectMap<class_2804> lightmapArray, long pos) {
        return null;
    }

    @Redirect(method={"getLevel(J)I"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/chunk/light/LightStorage;storage:Lnet/minecraft/world/chunk/ChunkToNibbleArrayMap;", opcode=180)), at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/ChunkToNibbleArrayMap;containsKey(J)Z", ordinal=0))
    private boolean isNonOptimizable(class_3556<?> lightmapArray, long sectionPos) {
        return this.nonOptimizableSections.contains(sectionPos);
    }
}

