/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.nearby_entity_tracking;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import me.jellysquid.mods.lithium.common.entity.tracker.EntityTrackerEngine;
import me.jellysquid.mods.lithium.common.entity.tracker.EntityTrackerSection;
import me.jellysquid.mods.lithium.common.entity.tracker.PositionedEntityTrackingSection;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.NearbyEntityListener;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.SectionedEntityMovementTracker;
import net.minecraft.class_1297;
import net.minecraft.class_3509;
import net.minecraft.class_5568;
import net.minecraft.class_5572;
import net.minecraft.class_5573;
import net.minecraft.class_5584;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_5572.class})
public abstract class EntityTrackingSectionMixin<T extends class_5568>
implements EntityTrackerSection,
PositionedEntityTrackingSection {
    @Shadow
    private class_5584 field_27249;
    @Shadow
    @Final
    private class_3509<T> field_27248;
    private final ReferenceOpenHashSet<NearbyEntityListener> nearbyEntityListeners = new ReferenceOpenHashSet(0);
    private final ReferenceOpenHashSet<SectionedEntityMovementTracker<?, ?>> sectionVisibilityListeners = new ReferenceOpenHashSet(0);
    private final ArrayList<SectionedEntityMovementTracker<?, ?>>[] entityMovementListenersByType = new ArrayList[EntityTrackerEngine.NUM_MOVEMENT_NOTIFYING_CLASSES];
    private final long[] lastEntityMovementByType = new long[EntityTrackerEngine.NUM_MOVEMENT_NOTIFYING_CLASSES];

    @Shadow
    public abstract boolean method_31761();

    @Override
    public void addListener(NearbyEntityListener listener) {
        this.nearbyEntityListeners.add((Object)listener);
        if (this.field_27249.method_31885()) {
            listener.onSectionEnteredRange(this, this.field_27248);
        }
    }

    @Override
    public void removeListener(class_5573<?> sectionedEntityCache, NearbyEntityListener listener) {
        boolean removed = this.nearbyEntityListeners.remove((Object)listener);
        if (this.field_27249.method_31885() && removed) {
            listener.onSectionLeftRange(this, this.field_27248);
        }
        if (this.method_31761()) {
            sectionedEntityCache.method_31786(this.getPos());
        }
    }

    @Override
    public void addListener(SectionedEntityMovementTracker<?, ?> listener) {
        this.sectionVisibilityListeners.add(listener);
        if (this.field_27249.method_31885()) {
            listener.onSectionEnteredRange(this);
        }
    }

    @Override
    public void removeListener(class_5573<?> sectionedEntityCache, SectionedEntityMovementTracker<?, ?> listener) {
        boolean removed = this.sectionVisibilityListeners.remove(listener);
        if (this.field_27249.method_31885() && removed) {
            listener.onSectionLeftRange(this);
        }
        if (this.method_31761()) {
            sectionedEntityCache.method_31786(this.getPos());
        }
    }

    @Override
    public void trackEntityMovement(int notificationMask, long time) {
        long[] lastEntityMovementByType = this.lastEntityMovementByType;
        int size = lastEntityMovementByType.length;
        int entityClassIndex = Integer.numberOfTrailingZeros(notificationMask);
        while (entityClassIndex < size) {
            lastEntityMovementByType[entityClassIndex] = time;
            ArrayList<SectionedEntityMovementTracker<?, ?>> entityMovementListeners = this.entityMovementListenersByType[entityClassIndex];
            if (entityMovementListeners != null) {
                for (int listIndex = entityMovementListeners.size() - 1; listIndex >= 0; --listIndex) {
                    SectionedEntityMovementTracker<?, ?> sectionedEntityMovementTracker = entityMovementListeners.remove(listIndex);
                    sectionedEntityMovementTracker.emitEntityMovement(notificationMask, this);
                }
            }
            int mask = -2 << entityClassIndex;
            entityClassIndex = Integer.numberOfTrailingZeros(notificationMask & mask);
        }
    }

    @Override
    public long[] getMovementTimestampArray() {
        return this.lastEntityMovementByType;
    }

    @Override
    public long getChangeTime(int trackedClass) {
        return this.lastEntityMovementByType[trackedClass];
    }

    @Inject(method={"isEmpty()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void isEmpty(CallbackInfoReturnable<Boolean> cir) {
        if (!this.nearbyEntityListeners.isEmpty() || !this.sectionVisibilityListeners.isEmpty()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"add(Lnet/minecraft/world/entity/EntityLike;)V"}, at={@At(value="RETURN")})
    private void onEntityAdded(T entityLike, CallbackInfo ci) {
        if (!this.field_27249.method_31885() || this.nearbyEntityListeners.isEmpty()) {
            return;
        }
        if (entityLike instanceof class_1297) {
            class_1297 entity = (class_1297)entityLike;
            for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                nearbyEntityListener.onEntityEnteredRange(entity);
            }
        }
    }

    @Inject(method={"remove(Lnet/minecraft/world/entity/EntityLike;)Z"}, at={@At(value="RETURN")})
    private void onEntityRemoved(T entityLike, CallbackInfoReturnable<Boolean> cir) {
        if (this.field_27249.method_31885() && !this.nearbyEntityListeners.isEmpty() && entityLike instanceof class_1297) {
            class_1297 entity = (class_1297)entityLike;
            for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                nearbyEntityListener.onEntityLeftRange(entity);
            }
        }
    }

    @ModifyVariable(method={"swapStatus(Lnet/minecraft/world/entity/EntityTrackingStatus;)Lnet/minecraft/world/entity/EntityTrackingStatus;"}, at=@At(value="HEAD"), argsOnly=true)
    public class_5584 swapStatus(class_5584 newStatus) {
        block7: {
            block8: {
                if (this.field_27249.method_31885() == newStatus.method_31885()) break block7;
                if (newStatus.method_31885()) break block8;
                if (!this.nearbyEntityListeners.isEmpty()) {
                    for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                        nearbyEntityListener.onSectionLeftRange(this, this.field_27248);
                    }
                }
                if (this.sectionVisibilityListeners.isEmpty()) break block7;
                for (SectionedEntityMovementTracker listener : this.sectionVisibilityListeners) {
                    listener.onSectionLeftRange(this);
                }
                break block7;
            }
            if (!this.nearbyEntityListeners.isEmpty()) {
                for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                    nearbyEntityListener.onSectionEnteredRange(this, this.field_27248);
                }
            }
            if (!this.sectionVisibilityListeners.isEmpty()) {
                for (SectionedEntityMovementTracker listener : this.sectionVisibilityListeners) {
                    listener.onSectionEnteredRange(this);
                }
            }
        }
        return newStatus;
    }

    @Override
    public <S, E extends class_5568> void listenToMovementOnce(SectionedEntityMovementTracker<E, S> listener, int trackedClass) {
        if (this.entityMovementListenersByType[trackedClass] == null) {
            this.entityMovementListenersByType[trackedClass] = new ArrayList();
        }
        this.entityMovementListenersByType[trackedClass].add(listener);
    }

    @Override
    public <S, E extends class_5568> void removeListenToMovementOnce(SectionedEntityMovementTracker<E, S> listener, int trackedClass) {
        if (this.entityMovementListenersByType[trackedClass] != null) {
            this.entityMovementListenersByType[trackedClass].remove(listener);
        }
    }
}

