/*
 * Decompiled with CFR 0.152.
 */
package io.github.quantizr.dungeonrooms.dungeons.catacombs;

import com.google.gson.JsonObject;
import io.github.quantizr.dungeonrooms.DungeonRooms;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.DungeonManager;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.Waypoints;
import io.github.quantizr.dungeonrooms.utils.MapUtils;
import io.github.quantizr.dungeonrooms.utils.RoomDetectionUtils;
import io.github.quantizr.dungeonrooms.utils.Utils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class RoomDetection {
    Minecraft mc = Minecraft.func_71410_x();
    static int stage2Ticks = 0;
    static ExecutorService stage2Executor;
    public static List<Point> currentMapSegments;
    public static List<Point> currentPhysicalSegments;
    public static String roomSize;
    public static String roomColor;
    public static String roomCategory;
    public static String roomName;
    public static String roomDirection;
    public static Point roomCorner;
    public static HashSet<BlockPos> currentScannedBlocks;
    public static HashMap<BlockPos, Integer> blocksToCheck;
    public static int totalBlocksAvailableToCheck;
    public static List<BlockPos> blocksUsed;
    static Future<HashMap<String, List<String>>> futureUpdatePossibleRooms;
    public static HashMap<String, List<String>> possibleRooms;
    static long incompleteScan;
    static long redoScan;
    static int entranceMapNullCount;

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!Utils.inCatacombs) {
            return;
        }
        EntityPlayerSP player = this.mc.field_71439_g;
        if (DungeonManager.gameStage == 2) {
            if (DungeonManager.mapId == null && RoomDetection.extractMapId() == null) {
                return;
            }
            if (++stage2Ticks == 10) {
                stage2Ticks = 0;
                if (stage2Executor == null || stage2Executor.isTerminated()) {
                    stage2Executor = Executors.newSingleThreadExecutor();
                    DungeonRooms.logger.debug("DungeonRooms: New Single Thread Executor Started");
                }
                if (DungeonManager.entranceMapCorners == null) {
                    DungeonManager.map = MapUtils.updatedMap();
                    DungeonManager.entranceMapCorners = MapUtils.entranceMapCorners(DungeonManager.map);
                    DungeonRooms.logger.info("DungeonRooms: Getting entrance map corners from map data...");
                } else if (DungeonManager.entranceMapCorners[0] == null || DungeonManager.entranceMapCorners[1] == null) {
                    DungeonRooms.logger.warn("DungeonRooms: Entrance room not found, map data possibly bugged");
                    DungeonManager.entranceMapCorners = null;
                    if (++entranceMapNullCount == 8) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Error with map data, perhaps your texture pack is interfering with room detection?"));
                        DungeonRooms.textToDisplay = new ArrayList<String>(Collections.singletonList("Dungeon Rooms: " + EnumChatFormatting.RED + "Entrance Room corner not found"));
                    }
                } else if (DungeonManager.entrancePhysicalNWCorner == null) {
                    DungeonRooms.logger.warn("DungeonRooms: Entrance Room coordinates not found");
                    Point playerMarkerPos = MapUtils.playerMarkerPos();
                    if (playerMarkerPos != null) {
                        Object closestNWMapCorner = MapUtils.getClosestNWMapCorner(playerMarkerPos, DungeonManager.entranceMapCorners[0], DungeonManager.entranceMapCorners[1]);
                        if (MapUtils.getMapColor(playerMarkerPos, DungeonManager.map).equals("green") && MapUtils.getMapColor((Point)closestNWMapCorner, DungeonManager.map).equals("green")) {
                            if (!player.func_174791_d().equals(new Vec3(0.0, 0.0, 0.0))) {
                                DungeonManager.entrancePhysicalNWCorner = MapUtils.getClosestNWPhysicalCorner(player.func_174791_d());
                                DungeonRooms.logger.info("DungeonRooms: entrancePhysicalNWCorner has been set to " + DungeonManager.entrancePhysicalNWCorner);
                            }
                        } else {
                            DungeonRooms.textToDisplay = new ArrayList<String>(Arrays.asList("Dungeon Rooms: " + EnumChatFormatting.RED + "Entrance Room coordinates not found", EnumChatFormatting.RED + "Please go back into the middle of the Green Entrance Room."));
                        }
                    }
                } else {
                    Point currentPhysicalCorner = MapUtils.getClosestNWPhysicalCorner(player.func_174791_d());
                    if (currentPhysicalSegments != null && !currentPhysicalSegments.contains(currentPhysicalCorner)) {
                        RoomDetection.resetCurrentRoom();
                    } else if (incompleteScan != 0L && System.currentTimeMillis() > incompleteScan) {
                        incompleteScan = 0L;
                        DungeonRooms.logger.info("DungeonRooms: Rescanning room...");
                        this.raytraceBlocks();
                    } else if (redoScan != 0L && System.currentTimeMillis() > redoScan) {
                        redoScan = 0L;
                        DungeonRooms.logger.info("DungeonRooms: Clearing data and rescanning room...");
                        possibleRooms = null;
                        this.raytraceBlocks();
                    }
                    if (currentPhysicalSegments == null || currentMapSegments == null || roomSize.equals("undefined") || roomColor.equals("undefined")) {
                        this.updateCurrentRoom();
                        if (roomColor.equals("undefined")) {
                            DungeonRooms.textToDisplay = new ArrayList<String>(Collections.singletonList("Dungeon Rooms: " + EnumChatFormatting.RED + "Waiting for map data to update..."));
                        } else {
                            switch (roomColor) {
                                case "brown": 
                                case "purple": 
                                case "orange": {
                                    this.raytraceBlocks();
                                    break;
                                }
                                case "yellow": {
                                    roomName = "Miniboss Room";
                                    RoomDetection.newRoom();
                                    break;
                                }
                                case "green": {
                                    roomName = "Entrance Room";
                                    RoomDetection.newRoom();
                                    break;
                                }
                                case "pink": {
                                    roomName = "Fairy Room";
                                    RoomDetection.newRoom();
                                    break;
                                }
                                case "red": {
                                    roomName = "Blood Room";
                                    RoomDetection.newRoom();
                                    break;
                                }
                                default: {
                                    roomName = "undefined";
                                }
                            }
                        }
                    }
                }
            }
            if (futureUpdatePossibleRooms != null && futureUpdatePossibleRooms.isDone()) {
                try {
                    possibleRooms = futureUpdatePossibleRooms.get();
                    futureUpdatePossibleRooms = null;
                    TreeSet<String> possibleRoomsSet = new TreeSet<String>();
                    String tempDirection = "undefined";
                    for (Map.Entry<String, List<String>> entry : possibleRooms.entrySet()) {
                        List<String> possibleRoomList = entry.getValue();
                        if (!possibleRoomList.isEmpty()) {
                            tempDirection = entry.getKey();
                        }
                        possibleRoomsSet.addAll(possibleRoomList);
                    }
                    if (possibleRoomsSet.size() == 0) {
                        DungeonRooms.textToDisplay = new ArrayList<String>(Arrays.asList("Dungeon Rooms: " + EnumChatFormatting.RED + "No Matching Rooms Detected", EnumChatFormatting.RED + "This mod might not have data for this room.", EnumChatFormatting.WHITE + "Retrying every 5 seconds..."));
                        redoScan = System.currentTimeMillis() + 5000L;
                    } else if (possibleRoomsSet.size() == 1) {
                        roomName = (String)possibleRoomsSet.first();
                        roomDirection = tempDirection;
                        roomCorner = MapUtils.getPhysicalCornerPos(roomDirection, currentPhysicalSegments);
                        DungeonRooms.logger.info("DungeonRooms: 576 raytrace vectors sent, returning " + currentScannedBlocks.size() + " unique line-of-sight blocks, filtered down to " + totalBlocksAvailableToCheck + " blocks, out of which " + blocksUsed.size() + " blocks were used to uniquely identify " + roomName + ".");
                        RoomDetection.newRoom();
                    } else {
                        DungeonRooms.textToDisplay = new ArrayList<String>(Arrays.asList("Dungeon Rooms: " + EnumChatFormatting.RED + "Unable to Determine Room Name", EnumChatFormatting.RED + "Not enough valid blocks were scanned, look at a more open area.", EnumChatFormatting.WHITE + "Retrying every second..."));
                        DungeonRooms.logger.debug("DungeonRooms: Possible rooms list = " + new ArrayList(possibleRoomsSet));
                        incompleteScan = System.currentTimeMillis() + 1000L;
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void updateCurrentRoom() {
        EntityPlayerSP player = this.mc.field_71439_g;
        DungeonManager.map = MapUtils.updatedMap();
        if (DungeonManager.map == null) {
            return;
        }
        Point currentPhysicalCorner = MapUtils.getClosestNWPhysicalCorner(player.func_174791_d());
        Point currentMapCorner = MapUtils.physicalToMapCorner(currentPhysicalCorner, DungeonManager.entrancePhysicalNWCorner, DungeonManager.entranceMapCorners[0], DungeonManager.entranceMapCorners[1]);
        roomColor = MapUtils.getMapColor(currentMapCorner, DungeonManager.map);
        if (roomColor.equals("undefined")) {
            return;
        }
        currentMapSegments = MapUtils.neighboringSegments(currentMapCorner, DungeonManager.map, DungeonManager.entranceMapCorners[0], DungeonManager.entranceMapCorners[1], new ArrayList<Point>());
        currentPhysicalSegments = new ArrayList<Point>();
        for (Point mapCorner : currentMapSegments) {
            currentPhysicalSegments.add(MapUtils.mapToPhysicalCorner(mapCorner, DungeonManager.entrancePhysicalNWCorner, DungeonManager.entranceMapCorners[0], DungeonManager.entranceMapCorners[1]));
        }
        roomSize = MapUtils.roomSize(currentMapSegments);
        roomCategory = MapUtils.roomCategory(roomSize, roomColor);
    }

    public static void resetCurrentRoom() {
        DungeonRooms.textToDisplay = null;
        Waypoints.allFound = false;
        currentPhysicalSegments = null;
        currentMapSegments = null;
        roomSize = "undefined";
        roomColor = "undefined";
        roomCategory = "undefined";
        roomName = "undefined";
        roomDirection = "undefined";
        roomCorner = null;
        currentScannedBlocks = new HashSet();
        blocksToCheck = new HashMap();
        totalBlocksAvailableToCheck = 0;
        blocksUsed = new ArrayList<BlockPos>();
        futureUpdatePossibleRooms = null;
        possibleRooms = null;
        incompleteScan = 0L;
        redoScan = 0L;
        Waypoints.secretNum = 0;
    }

    public static Integer extractMapId() {
        if (!MapUtils.mapExists()) {
            return null;
        }
        ItemStack mapSlot = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70301_a(8);
        DungeonRooms.logger.info("DungeonRooms: Extracting the map id");
        DungeonManager.mapId = mapSlot.func_77960_j();
        return DungeonManager.mapId;
    }

    public static void newRoom() {
        if (!roomName.equals("undefined") && !roomCategory.equals("undefined")) {
            if (DungeonRooms.roomsJson.get(roomName) != null) {
                Waypoints.secretNum = DungeonRooms.roomsJson.get(roomName).getAsJsonObject().get("secrets").getAsInt();
                Waypoints.allSecretsMap.putIfAbsent(roomName, new ArrayList<Boolean>(Collections.nCopies(Waypoints.secretNum, true)));
            } else {
                Waypoints.secretNum = 0;
                Waypoints.allSecretsMap.putIfAbsent(roomName, new ArrayList<Boolean>(Collections.nCopies(0, true)));
            }
            Waypoints.secretsList = Waypoints.allSecretsMap.get(roomName);
            if (DungeonManager.guiToggled) {
                ArrayList<String> lineList = new ArrayList<String>();
                String line = "Dungeon Rooms: You are in " + EnumChatFormatting.GREEN + roomCategory + EnumChatFormatting.WHITE + " - " + EnumChatFormatting.GREEN + roomName;
                if (DungeonRooms.roomsJson.get(roomName) != null) {
                    JsonObject roomJson = DungeonRooms.roomsJson.get(roomName).getAsJsonObject();
                    if (roomJson.get("fairysoul").getAsBoolean()) {
                        line = line + EnumChatFormatting.WHITE + " - " + EnumChatFormatting.LIGHT_PURPLE + "Fairy Soul";
                    }
                    lineList.add(line);
                    if (Waypoints.enabled && roomJson.get("secrets").getAsInt() != 0 && DungeonRooms.waypointsJson.get(roomName) == null) {
                        lineList.add(EnumChatFormatting.RED + "No waypoints available");
                        lineList.add(EnumChatFormatting.RED + "Press \"" + GameSettings.func_74298_c((int)DungeonRooms.keyBindings[0].func_151463_i()) + "\" to view images");
                    }
                }
                DungeonRooms.textToDisplay = lineList;
            }
        }
    }

    void raytraceBlocks() {
        DungeonRooms.logger.debug("DungeonRooms: Raytracing visible blocks");
        long timeStart = System.currentTimeMillis();
        EntityPlayerSP player = this.mc.field_71439_g;
        List<Vec3> vecList = RoomDetectionUtils.vectorsToRaytrace(24);
        Vec3 eyes = new Vec3(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        for (Vec3 vec : vecList) {
            IBlockState hitBlock;
            int identifier;
            BlockPos raytracedBlockPos;
            MovingObjectPosition raytraceResult = player.func_130014_f_().func_147447_a(eyes, vec, false, false, true);
            if (raytraceResult == null || raytraceResult.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || currentScannedBlocks.contains(raytracedBlockPos = raytraceResult.func_178782_a())) continue;
            currentScannedBlocks.add(raytracedBlockPos);
            if (!currentPhysicalSegments.contains(MapUtils.getClosestNWPhysicalCorner(raytracedBlockPos)) || RoomDetectionUtils.blockPartOfDoorway(raytracedBlockPos) || !RoomDetectionUtils.whitelistedBlocks.contains(identifier = Block.func_149682_b((Block)(hitBlock = this.mc.field_71441_e.func_180495_p(raytracedBlockPos)).func_177230_c()) * 100 + hitBlock.func_177230_c().func_180651_a(hitBlock))) continue;
            blocksToCheck.put(raytracedBlockPos, identifier);
        }
        DungeonRooms.logger.debug("DungeonRooms: Finished raytracing, amount of blocks to check = " + blocksToCheck.size());
        long timeFinish = System.currentTimeMillis();
        DungeonRooms.logger.debug("DungeonRooms: Time to raytrace and filter (in ms): " + (timeFinish - timeStart));
        if (futureUpdatePossibleRooms == null && stage2Executor != null && !stage2Executor.isTerminated()) {
            DungeonRooms.logger.debug("DungeonRooms: Initializing Room Comparison Executor");
            futureUpdatePossibleRooms = this.getPossibleRooms();
        }
    }

    Future<HashMap<String, List<String>>> getPossibleRooms() {
        return stage2Executor.submit(() -> {
            HashMap<String, List<String>> updatedPossibleRooms;
            List<String> possibleDirections;
            long timeStart = System.currentTimeMillis();
            if (possibleRooms == null) {
                DungeonRooms.logger.debug("DungeonRooms: No previous possible rooms list, creating new list...");
                possibleDirections = MapUtils.possibleDirections(roomSize, currentMapSegments);
                updatedPossibleRooms = new HashMap();
                for (String string : possibleDirections) {
                    updatedPossibleRooms.put(string, new ArrayList<String>(DungeonRooms.ROOM_DATA.get(roomCategory).keySet()));
                }
            } else {
                DungeonRooms.logger.debug("DungeonRooms: Loading possible rooms from previous room scan...");
                updatedPossibleRooms = possibleRooms;
                possibleDirections = new ArrayList<String>(possibleRooms.keySet());
            }
            HashMap<String, Point> directionCorners = new HashMap<String, Point>();
            for (String direction : possibleDirections) {
                directionCorners.put(direction, MapUtils.getPhysicalCornerPos(direction, currentPhysicalSegments));
            }
            DungeonRooms.logger.debug("DungeonRooms: directionCorners " + directionCorners.entrySet());
            ArrayList<BlockPos> arrayList = new ArrayList<BlockPos>();
            int doubleCheckedBlocks = 0;
            for (Map.Entry<BlockPos, Integer> entry : blocksToCheck.entrySet()) {
                BlockPos blockPos = entry.getKey();
                DungeonRooms.logger.debug("DungeonRooms: BlockPos being checked " + blockPos);
                int combinedMatchingRooms = 0;
                for (String direction : possibleDirections) {
                    BlockPos relative = MapUtils.actualToRelative(blockPos, direction, (Point)directionCorners.get(direction));
                    long idToCheck = Utils.shortToLong((short)relative.func_177958_n(), (short)relative.func_177956_o(), (short)relative.func_177952_p(), entry.getValue().shortValue());
                    ArrayList<String> matchingRooms = new ArrayList<String>();
                    for (String roomName : updatedPossibleRooms.get(direction)) {
                        int index = Arrays.binarySearch(DungeonRooms.ROOM_DATA.get(roomCategory).get(roomName), idToCheck);
                        if (index <= -1) continue;
                        matchingRooms.add(roomName);
                    }
                    combinedMatchingRooms += matchingRooms.size();
                    updatedPossibleRooms.put(direction, matchingRooms);
                    DungeonRooms.logger.debug("DungeonRooms: direction checked = " + direction + ", longID = " + idToCheck + ", relative = " + relative);
                    DungeonRooms.logger.debug("DungeonRooms: updatedPossibleRooms size = " + updatedPossibleRooms.get(direction).size() + " for direction " + direction);
                }
                arrayList.add(blockPos);
                if (combinedMatchingRooms == 0) {
                    DungeonRooms.logger.warn("DungeonRooms: No rooms match the input blocks after checking " + arrayList.size() + " blocks, returning");
                    break;
                }
                if (combinedMatchingRooms == 1) {
                    if (doubleCheckedBlocks >= 10) {
                        DungeonRooms.logger.debug("DungeonRooms: One room matches after checking " + arrayList.size() + " blocks");
                        break;
                    }
                    ++doubleCheckedBlocks;
                }
                DungeonRooms.logger.debug("DungeonRooms: " + combinedMatchingRooms + " possible rooms after checking " + arrayList.size() + " blocks");
            }
            if (arrayList.size() == blocksToCheck.size()) {
                DungeonRooms.logger.warn("DungeonRooms: Multiple rooms match after checking all " + arrayList.size() + " blocks");
            }
            blocksUsed.addAll(arrayList);
            totalBlocksAvailableToCheck += blocksToCheck.size();
            blocksToCheck = new HashMap();
            long timeFinish = System.currentTimeMillis();
            DungeonRooms.logger.debug("DungeonRooms: Time to check blocks using thread (in ms): " + (timeFinish - timeStart));
            return updatedPossibleRooms;
        });
    }

    static {
        roomSize = "undefined";
        roomColor = "undefined";
        roomCategory = "undefined";
        roomName = "undefined";
        roomDirection = "undefined";
        currentScannedBlocks = new HashSet();
        blocksToCheck = new HashMap();
        totalBlocksAvailableToCheck = 0;
        blocksUsed = new ArrayList<BlockPos>();
        incompleteScan = 0L;
        redoScan = 0L;
        entranceMapNullCount = 0;
    }
}

