/*
 * Decompiled with CFR 0.152.
 */
package codes.biscuit.skyblockaddons;

import codes.biscuit.skyblockaddons.asm.hooks.FontRendererHook;
import codes.biscuit.skyblockaddons.commands.SkyblockAddonsCommand;
import codes.biscuit.skyblockaddons.config.ConfigValues;
import codes.biscuit.skyblockaddons.config.PersistentValuesManager;
import codes.biscuit.skyblockaddons.core.Feature;
import codes.biscuit.skyblockaddons.core.OnlineData;
import codes.biscuit.skyblockaddons.core.Translations;
import codes.biscuit.skyblockaddons.core.dungeons.DungeonManager;
import codes.biscuit.skyblockaddons.features.EntityOutlines.EntityOutlineRenderer;
import codes.biscuit.skyblockaddons.features.EntityOutlines.FeatureDungeonTeammateOutlines;
import codes.biscuit.skyblockaddons.features.EntityOutlines.FeatureItemOutlines;
import codes.biscuit.skyblockaddons.features.EntityOutlines.FeatureTrackerQuest;
import codes.biscuit.skyblockaddons.features.SkillXpManager;
import codes.biscuit.skyblockaddons.features.discordrpc.DiscordRPCManager;
import codes.biscuit.skyblockaddons.gui.IslandWarpGui;
import codes.biscuit.skyblockaddons.gui.SkyblockAddonsGui;
import codes.biscuit.skyblockaddons.listeners.GuiScreenListener;
import codes.biscuit.skyblockaddons.listeners.NetworkListener;
import codes.biscuit.skyblockaddons.listeners.PlayerListener;
import codes.biscuit.skyblockaddons.listeners.RenderListener;
import codes.biscuit.skyblockaddons.listeners.ResourceManagerReloadListener;
import codes.biscuit.skyblockaddons.misc.SkyblockKeyBinding;
import codes.biscuit.skyblockaddons.misc.Updater;
import codes.biscuit.skyblockaddons.misc.scheduler.NewScheduler;
import codes.biscuit.skyblockaddons.misc.scheduler.Scheduler;
import codes.biscuit.skyblockaddons.newgui.GuiManager;
import codes.biscuit.skyblockaddons.utils.EnumUtils;
import codes.biscuit.skyblockaddons.utils.InventoryUtils;
import codes.biscuit.skyblockaddons.utils.SkyblockAddonsMessageFactory;
import codes.biscuit.skyblockaddons.utils.Utils;
import codes.biscuit.skyblockaddons.utils.data.DataUtils;
import codes.biscuit.skyblockaddons.utils.gson.GsonInitializableTypeAdapter;
import codes.biscuit.skyblockaddons.utils.gson.PatternAdapter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLModDisabledEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MessageFactory;

@Mod(modid="skyblockaddons", name="SkyblockAddons", version="1.7.3", clientSideOnly=true, acceptedMinecraftVersions="1.8.9")
public class SkyblockAddons {
    public static final String MOD_ID = "skyblockaddons";
    public static final String MOD_NAME = "SkyblockAddons";
    public static String VERSION = "1.7.3";
    public static final String BUILD_NUMBER = "7380";
    private static SkyblockAddons instance;
    private static boolean fullyInitialized;
    private static final Gson GSON;
    private static final Logger LOGGER;
    private static final ThreadPoolExecutor THREAD_EXECUTOR;
    private ConfigValues configValues;
    private PersistentValuesManager persistentValuesManager;
    private final PlayerListener playerListener;
    private final GuiScreenListener guiScreenListener;
    private final RenderListener renderListener;
    private final ResourceManagerReloadListener resourceManagerReloadListener;
    private final InventoryUtils inventoryUtils;
    private final Utils utils;
    private final Updater updater;
    private OnlineData onlineData;
    private final DiscordRPCManager discordRPCManager;
    private final Scheduler scheduler;
    private final NewScheduler newScheduler;
    private final DungeonManager dungeonManager;
    private final GuiManager guiManager;
    private final SkillXpManager skillXpManager;
    private boolean usingLabymod;
    private boolean usingOofModv1;
    private boolean usingPatcher;
    private boolean devMode;
    private final List<SkyblockKeyBinding> keyBindings = new LinkedList<SkyblockKeyBinding>();
    private final Set<Integer> registeredFeatureIDs = new HashSet<Integer>();

    public SkyblockAddons() {
        instance = this;
        this.playerListener = new PlayerListener();
        this.guiScreenListener = new GuiScreenListener();
        this.renderListener = new RenderListener();
        this.resourceManagerReloadListener = new ResourceManagerReloadListener();
        this.inventoryUtils = new InventoryUtils();
        this.utils = new Utils();
        this.updater = new Updater();
        this.scheduler = new Scheduler();
        this.newScheduler = new NewScheduler();
        this.dungeonManager = new DungeonManager();
        this.discordRPCManager = new DiscordRPCManager();
        this.guiManager = new GuiManager();
        this.skillXpManager = new SkillXpManager();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        this.configValues = new ConfigValues(e.getSuggestedConfigurationFile());
        this.persistentValuesManager = new PersistentValuesManager(e.getModConfigurationDirectory());
        this.configValues.loadValues();
        DataUtils.readLocalAndFetchOnline();
        this.persistentValuesManager.loadValues();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        if (DataUtils.USE_ONLINE_DATA) {
            DataUtils.loadOnlineData();
        }
        MinecraftForge.EVENT_BUS.register((Object)new NetworkListener());
        MinecraftForge.EVENT_BUS.register((Object)this.playerListener);
        MinecraftForge.EVENT_BUS.register((Object)this.guiScreenListener);
        MinecraftForge.EVENT_BUS.register((Object)this.renderListener);
        MinecraftForge.EVENT_BUS.register((Object)this.scheduler);
        MinecraftForge.EVENT_BUS.register((Object)this.newScheduler);
        MinecraftForge.EVENT_BUS.register((Object)new FeatureItemOutlines());
        MinecraftForge.EVENT_BUS.register((Object)new FeatureDungeonTeammateOutlines());
        MinecraftForge.EVENT_BUS.register((Object)new EntityOutlineRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new FeatureTrackerQuest());
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this.resourceManagerReloadListener);
        ClientCommandHandler.instance.func_71560_a((ICommand)new SkyblockAddonsCommand());
        int developerModeKey = Minecraft.field_142025_a ? 56 : 157;
        Collections.addAll(this.keyBindings, new SkyblockKeyBinding("open_settings", 0, "settings.settings"), new SkyblockKeyBinding("edit_gui", 0, "settings.editLocations"), new SkyblockKeyBinding("lock_slot", 38, "settings.lockSlot"), new SkyblockKeyBinding("freeze_backpack", 33, "settings.freezeBackpackPreview"), new SkyblockKeyBinding("increase_dungeon_map_zoom", 13, "keyBindings.increaseDungeonMapZoom"), new SkyblockKeyBinding("decrease_dungeon_map_zoom", 74, "keyBindings.decreaseDungeonMapZoom"), new SkyblockKeyBinding("copy_NBT", developerModeKey, "keyBindings.developerCopyNBT"));
        this.registerKeyBindings(this.keyBindings);
        this.setKeyBindingDescriptions();
        if (!this.getConfigValues().isEnabled(Feature.DEVELOPER_MODE)) {
            this.getDeveloperCopyNBTKey().deRegister();
        }
        this.usingLabymod = this.utils.isModLoaded("labymod");
        this.usingOofModv1 = this.utils.isModLoaded("refractionoof", "1.0");
        this.usingPatcher = this.utils.isModLoaded("patcher");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        for (Feature feature : Feature.values()) {
            if (feature.isGuiFeature()) {
                feature.getSettings().add(EnumUtils.FeatureSetting.GUI_SCALE);
            }
            if (feature.isColorFeature()) {
                feature.getSettings().add(EnumUtils.FeatureSetting.COLOR);
            }
            if (feature.getGuiFeatureData() == null || feature.getGuiFeatureData().getDrawType() != EnumUtils.DrawType.BAR) continue;
            feature.getSettings().add(EnumUtils.FeatureSetting.GUI_SCALE_X);
            feature.getSettings().add(EnumUtils.FeatureSetting.GUI_SCALE_Y);
        }
        if (this.configValues.isEnabled(Feature.FANCY_WARP_MENU)) {
            for (Enum enum_ : IslandWarpGui.Island.values()) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(((IslandWarpGui.Island)enum_).getResourceLocation());
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(SkyblockAddonsGui.LOGO);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(SkyblockAddonsGui.LOGO_GLOW);
        fullyInitialized = true;
        FontRendererHook.onModInitialized();
    }

    @Mod.EventHandler
    public void stop(FMLModDisabledEvent e) {
        this.discordRPCManager.stop();
    }

    public KeyBinding getOpenSettingsKey() {
        return this.keyBindings.get(0).getKeyBinding();
    }

    public KeyBinding getOpenEditLocationsKey() {
        return this.keyBindings.get(1).getKeyBinding();
    }

    public KeyBinding getLockSlotKey() {
        return this.keyBindings.get(2).getKeyBinding();
    }

    public KeyBinding getFreezeBackpackKey() {
        return this.keyBindings.get(3).getKeyBinding();
    }

    public SkyblockKeyBinding getDeveloperCopyNBTKey() {
        return this.keyBindings.get(6);
    }

    public void registerKeyBindings(List<SkyblockKeyBinding> keyBindings) {
        for (SkyblockKeyBinding keybinding : keyBindings) {
            keybinding.register();
        }
    }

    public void setKeyBindingDescriptions() {
        for (SkyblockKeyBinding skyblockKeyBinding : this.keyBindings) {
            skyblockKeyBinding.getKeyBinding().field_74515_c = Translations.getMessage(skyblockKeyBinding.getTranslationKey(), new Object[0]);
        }
    }

    public static Gson getGson() {
        return GSON;
    }

    public static Logger getLogger() {
        String fullClassName = new Throwable().getStackTrace()[1].getClassName();
        String simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        return LogManager.getLogger((String)fullClassName, (MessageFactory)new SkyblockAddonsMessageFactory(simpleClassName));
    }

    public static String getVersionFull() {
        if (!BUILD_NUMBER.isEmpty()) {
            return VERSION + '+' + BUILD_NUMBER;
        }
        return VERSION;
    }

    public static void runAsync(Runnable runnable) {
        THREAD_EXECUTOR.execute(runnable);
    }

    public ConfigValues getConfigValues() {
        return this.configValues;
    }

    public PersistentValuesManager getPersistentValuesManager() {
        return this.persistentValuesManager;
    }

    public PlayerListener getPlayerListener() {
        return this.playerListener;
    }

    public GuiScreenListener getGuiScreenListener() {
        return this.guiScreenListener;
    }

    public RenderListener getRenderListener() {
        return this.renderListener;
    }

    public ResourceManagerReloadListener getResourceManagerReloadListener() {
        return this.resourceManagerReloadListener;
    }

    public InventoryUtils getInventoryUtils() {
        return this.inventoryUtils;
    }

    public Utils getUtils() {
        return this.utils;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public OnlineData getOnlineData() {
        return this.onlineData;
    }

    public DiscordRPCManager getDiscordRPCManager() {
        return this.discordRPCManager;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public NewScheduler getNewScheduler() {
        return this.newScheduler;
    }

    public DungeonManager getDungeonManager() {
        return this.dungeonManager;
    }

    public GuiManager getGuiManager() {
        return this.guiManager;
    }

    public SkillXpManager getSkillXpManager() {
        return this.skillXpManager;
    }

    public boolean isUsingLabymod() {
        return this.usingLabymod;
    }

    public boolean isUsingOofModv1() {
        return this.usingOofModv1;
    }

    public boolean isUsingPatcher() {
        return this.usingPatcher;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public List<SkyblockKeyBinding> getKeyBindings() {
        return this.keyBindings;
    }

    public static SkyblockAddons getInstance() {
        return instance;
    }

    public static boolean isFullyInitialized() {
        return fullyInitialized;
    }

    public void setOnlineData(OnlineData onlineData) {
        this.onlineData = onlineData;
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public Set<Integer> getRegisteredFeatureIDs() {
        return this.registeredFeatureIDs;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(EnumMap.class, type -> {
            Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            return new EnumMap((Class)types[0]);
        }).registerTypeAdapterFactory((TypeAdapterFactory)new GsonInitializableTypeAdapter()).registerTypeAdapter(Pattern.class, (Object)new PatternAdapter()).create();
        LOGGER = LogManager.getLogger((MessageFactory)new SkyblockAddonsMessageFactory(MOD_NAME));
        THREAD_EXECUTOR = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("SkyblockAddons - #%d").build());
        if (VERSION.contains("@")) {
            VERSION = "1.6.0";
        }
    }
}

