/*
 * Decompiled with CFR 0.152.
 */
package codes.biscuit.skyblockaddons.utils.data;

import codes.biscuit.skyblockaddons.SkyblockAddons;
import codes.biscuit.skyblockaddons.core.Language;
import codes.biscuit.skyblockaddons.core.OnlineData;
import codes.biscuit.skyblockaddons.core.Translations;
import codes.biscuit.skyblockaddons.core.seacreatures.SeaCreature;
import codes.biscuit.skyblockaddons.core.seacreatures.SeaCreatureManager;
import codes.biscuit.skyblockaddons.exceptions.DataLoadingException;
import codes.biscuit.skyblockaddons.features.SkillXpManager;
import codes.biscuit.skyblockaddons.features.cooldowns.CooldownManager;
import codes.biscuit.skyblockaddons.features.enchantedItemBlacklist.EnchantedItemLists;
import codes.biscuit.skyblockaddons.features.enchantedItemBlacklist.EnchantedItemPlacementBlocker;
import codes.biscuit.skyblockaddons.features.enchants.EnchantManager;
import codes.biscuit.skyblockaddons.misc.scheduler.ScheduledTask;
import codes.biscuit.skyblockaddons.misc.scheduler.SkyblockRunnable;
import codes.biscuit.skyblockaddons.tweaker.SkyblockAddonsTransformer;
import codes.biscuit.skyblockaddons.utils.ItemUtils;
import codes.biscuit.skyblockaddons.utils.Utils;
import codes.biscuit.skyblockaddons.utils.data.RemoteFileRequest;
import codes.biscuit.skyblockaddons.utils.data.RequestRetryHandler;
import codes.biscuit.skyblockaddons.utils.data.UncaughtFetchExceptionHandler;
import codes.biscuit.skyblockaddons.utils.data.requests.CompactorItemsRequest;
import codes.biscuit.skyblockaddons.utils.data.requests.ContainersRequest;
import codes.biscuit.skyblockaddons.utils.data.requests.CooldownsRequest;
import codes.biscuit.skyblockaddons.utils.data.requests.EnchantedItemListsRequest;
import codes.biscuit.skyblockaddons.utils.data.requests.EnchantmentsRequest;
import codes.biscuit.skyblockaddons.utils.data.requests.LocalizedStringsRequest;
import codes.biscuit.skyblockaddons.utils.data.requests.OnlineDataRequest;
import codes.biscuit.skyblockaddons.utils.data.requests.SeaCreaturesRequest;
import codes.biscuit.skyblockaddons.utils.data.requests.SkillXpRequest;
import codes.biscuit.skyblockaddons.utils.skyblockdata.CompactorItem;
import codes.biscuit.skyblockaddons.utils.skyblockdata.ContainerData;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.minecraft.crash.CrashReport;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ReportedException;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpRequestFutureTask;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.logging.log4j.Logger;

public class DataUtils {
    private static final Gson gson = SkyblockAddons.getGson();
    private static final Logger logger = SkyblockAddons.getLogger();
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(120000).setConnectionRequestTimeout(120000).setSocketTimeout(30000).build();
    private static final PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    private static final CloseableHttpClient httpClient = HttpClientBuilder.create().setUserAgent(Utils.USER_AGENT).setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy()).setRetryHandler((HttpRequestRetryHandler)new RequestRetryHandler()).build();
    private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("SBA DataUtils Thread %d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtFetchExceptionHandler()).build();
    private static final ExecutorService executorService = Executors.newCachedThreadPool(threadFactory);
    private static final FutureRequestExecutionService futureRequestExecutionService = new FutureRequestExecutionService((HttpClient)httpClient, executorService);
    private static final ArrayList<RemoteFileRequest<?>> remoteRequests = new ArrayList();
    private static final ArrayList<HttpRequestFutureTask<?>> httpRequestFutureTasks = new ArrayList();
    private static final HashMap<RemoteFileRequest<?>, Throwable> failedRequests = new HashMap();
    static boolean useFallbackCDN;
    private static boolean failureMessageShown;
    public static final boolean USE_ONLINE_DATA;
    private static String path;
    private static LocalizedStringsRequest localizedStringsRequest;
    private static ScheduledTask languageLoadingTask;

    public static void readLocalAndFetchOnline() {
        DataUtils.readLocalFileData();
        if (USE_ONLINE_DATA) {
            DataUtils.fetchFromOnline();
        } else {
            SkyblockAddons.getInstance().getUpdater().checkForUpdate();
        }
    }

    public static void readLocalFileData() {
        Throwable throwable;
        InputStreamReader inputStreamReader2;
        Throwable throwable2;
        InputStream inputStream;
        path = "/data.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            throwable2 = null;
            try {
                inputStreamReader2 = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                throwable = null;
                try {
                    main.setOnlineData((OnlineData)gson.fromJson((Reader)inputStreamReader2, OnlineData.class));
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (inputStreamReader2 != null) {
                        if (throwable != null) {
                            try {
                                inputStreamReader2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            inputStreamReader2.close();
                        }
                    }
                }
            }
            catch (Throwable inputStreamReader2) {
                throwable2 = inputStreamReader2;
                throw inputStreamReader2;
            }
            finally {
                if (inputStream != null) {
                    if (throwable2 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable inputStreamReader2) {
                            throwable2.addSuppressed(inputStreamReader2);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        DataUtils.loadLocalizedStrings(false);
        path = "/enchantedItemLists.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            throwable2 = null;
            try {
                inputStreamReader2 = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                throwable = null;
                try {
                    EnchantedItemPlacementBlocker.setItemLists((EnchantedItemLists)gson.fromJson((Reader)inputStreamReader2, EnchantedItemLists.class));
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStreamReader2 != null) {
                        if (throwable != null) {
                            try {
                                inputStreamReader2.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            inputStreamReader2.close();
                        }
                    }
                }
            }
            catch (Throwable inputStreamReader3) {
                throwable2 = inputStreamReader3;
                throw inputStreamReader3;
            }
            finally {
                if (inputStream != null) {
                    if (throwable2 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable inputStreamReader3) {
                            throwable2.addSuppressed(inputStreamReader3);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        path = "/containers.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            throwable2 = null;
            try {
                inputStreamReader2 = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                throwable = null;
                try {
                    ItemUtils.setContainers((Map)gson.fromJson((Reader)inputStreamReader2, new TypeToken<HashMap<String, ContainerData>>(){}.getType()));
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
                finally {
                    if (inputStreamReader2 != null) {
                        if (throwable != null) {
                            try {
                                inputStreamReader2.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                        } else {
                            inputStreamReader2.close();
                        }
                    }
                }
            }
            catch (Throwable inputStreamReader4) {
                throwable2 = inputStreamReader4;
                throw inputStreamReader4;
            }
            finally {
                if (inputStream != null) {
                    if (throwable2 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable inputStreamReader4) {
                            throwable2.addSuppressed(inputStreamReader4);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        path = "/compactorItems.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            throwable2 = null;
            try {
                inputStreamReader2 = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                throwable = null;
                try {
                    ItemUtils.setCompactorItems((Map)gson.fromJson((Reader)inputStreamReader2, new TypeToken<HashMap<String, CompactorItem>>(){}.getType()));
                }
                catch (Throwable throwable9) {
                    throwable = throwable9;
                    throw throwable9;
                }
                finally {
                    if (inputStreamReader2 != null) {
                        if (throwable != null) {
                            try {
                                inputStreamReader2.close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                        } else {
                            inputStreamReader2.close();
                        }
                    }
                }
            }
            catch (Throwable inputStreamReader5) {
                throwable2 = inputStreamReader5;
                throw inputStreamReader5;
            }
            finally {
                if (inputStream != null) {
                    if (throwable2 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable inputStreamReader5) {
                            throwable2.addSuppressed(inputStreamReader5);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        path = "/seaCreatures.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            throwable2 = null;
            try {
                inputStreamReader2 = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                throwable = null;
                try {
                    SeaCreatureManager.getInstance().setSeaCreatures((Map)gson.fromJson((Reader)inputStreamReader2, new TypeToken<Map<String, SeaCreature>>(){}.getType()));
                }
                catch (Throwable throwable11) {
                    throwable = throwable11;
                    throw throwable11;
                }
                finally {
                    if (inputStreamReader2 != null) {
                        if (throwable != null) {
                            try {
                                inputStreamReader2.close();
                            }
                            catch (Throwable throwable12) {
                                throwable.addSuppressed(throwable12);
                            }
                        } else {
                            inputStreamReader2.close();
                        }
                    }
                }
            }
            catch (Throwable inputStreamReader6) {
                throwable2 = inputStreamReader6;
                throw inputStreamReader6;
            }
            finally {
                if (inputStream != null) {
                    if (throwable2 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable inputStreamReader6) {
                            throwable2.addSuppressed(inputStreamReader6);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        path = "/enchants.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            throwable2 = null;
            try {
                inputStreamReader2 = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                throwable = null;
                try {
                    EnchantManager.setEnchants((EnchantManager.Enchants)gson.fromJson((Reader)inputStreamReader2, new TypeToken<EnchantManager.Enchants>(){}.getType()));
                }
                catch (Throwable throwable13) {
                    throwable = throwable13;
                    throw throwable13;
                }
                finally {
                    if (inputStreamReader2 != null) {
                        if (throwable != null) {
                            try {
                                inputStreamReader2.close();
                            }
                            catch (Throwable throwable14) {
                                throwable.addSuppressed(throwable14);
                            }
                        } else {
                            inputStreamReader2.close();
                        }
                    }
                }
            }
            catch (Throwable inputStreamReader7) {
                throwable2 = inputStreamReader7;
                throw inputStreamReader7;
            }
            finally {
                if (inputStream != null) {
                    if (throwable2 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable inputStreamReader7) {
                            throwable2.addSuppressed(inputStreamReader7);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        path = "/cooldowns.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            throwable2 = null;
            try {
                inputStreamReader2 = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                throwable = null;
                try {
                    CooldownManager.setItemCooldowns((Map)gson.fromJson((Reader)inputStreamReader2, new TypeToken<HashMap<String, Integer>>(){}.getType()));
                }
                catch (Throwable throwable15) {
                    throwable = throwable15;
                    throw throwable15;
                }
                finally {
                    if (inputStreamReader2 != null) {
                        if (throwable != null) {
                            try {
                                inputStreamReader2.close();
                            }
                            catch (Throwable throwable16) {
                                throwable.addSuppressed(throwable16);
                            }
                        } else {
                            inputStreamReader2.close();
                        }
                    }
                }
            }
            catch (Throwable inputStreamReader8) {
                throwable2 = inputStreamReader8;
                throw inputStreamReader8;
            }
            finally {
                if (inputStream != null) {
                    if (throwable2 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable inputStreamReader8) {
                            throwable2.addSuppressed(inputStreamReader8);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        path = "/skillXp.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            throwable2 = null;
            try {
                inputStreamReader2 = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                throwable = null;
                try {
                    main.getSkillXpManager().initialize((SkillXpManager.JsonInput)gson.fromJson((Reader)inputStreamReader2, SkillXpManager.JsonInput.class));
                }
                catch (Throwable throwable17) {
                    throwable = throwable17;
                    throw throwable17;
                }
                finally {
                    if (inputStreamReader2 != null) {
                        if (throwable != null) {
                            try {
                                inputStreamReader2.close();
                            }
                            catch (Throwable throwable18) {
                                throwable.addSuppressed(throwable18);
                            }
                        } else {
                            inputStreamReader2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable19) {
                throwable2 = throwable19;
                throw throwable19;
            }
            finally {
                if (inputStream != null) {
                    if (throwable2 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable20) {
                            throwable2.addSuppressed(throwable20);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
    }

    private static void fetchFromOnline() {
        for (RemoteFileRequest<?> request : remoteRequests) {
            request.execute(futureRequestExecutionService);
        }
        if (useFallbackCDN) {
            logger.warn("Could not reach main CDN. Some resources were fetched from fallback CDN.");
        }
    }

    public static void loadOnlineData() {
        Iterator<RemoteFileRequest<?>> requestIterator = remoteRequests.iterator();
        while (requestIterator.hasNext()) {
            RemoteFileRequest<?> request = requestIterator.next();
            if (!request.isDone()) {
                DataUtils.handleOnlineFileLoadException(request, new RuntimeException(String.format("Request for \"%s\" didn't finish in time for mod init.", DataUtils.getFileNameFromUrlString(request.getURL()))));
            }
            try {
                DataUtils.loadOnlineFile(request);
                requestIterator.remove();
            }
            catch (IllegalArgumentException | InterruptedException | NullPointerException | ExecutionException e) {
                DataUtils.handleOnlineFileLoadException(Objects.requireNonNull(request), e);
            }
        }
    }

    public static void loadOnlineFile(RemoteFileRequest<?> request) throws ExecutionException, InterruptedException {
        request.load();
    }

    public static void loadLocalizedStrings(boolean loadOnlineStrings) {
        DataUtils.loadLocalizedStrings(main.getConfigValues().getLanguage(), loadOnlineStrings);
    }

    public static void loadLocalizedStrings(Language language, boolean loadOnlineStrings) {
        path = "lang/" + language.getPath() + ".json";
        try (InputStream inputStream = DataUtils.class.getClassLoader().getResourceAsStream(path);
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);){
            main.getConfigValues().setLanguageConfig((JsonObject)gson.fromJson((Reader)inputStreamReader, JsonObject.class));
            main.getConfigValues().setLanguage(language);
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        if (USE_ONLINE_DATA && loadOnlineStrings && language != Language.ENGLISH) {
            if (localizedStringsRequest != null) {
                HttpRequestFutureTask futureTask = localizedStringsRequest.getFutureTask();
                if (!futureTask.isDone()) {
                    futureTask.cancel(false);
                }
            } else if (languageLoadingTask != null) {
                languageLoadingTask.cancel();
            }
            localizedStringsRequest = new LocalizedStringsRequest(language);
            localizedStringsRequest.execute(futureRequestExecutionService);
            languageLoadingTask = main.getNewScheduler().scheduleLimitedRepeatingTask(new SkyblockRunnable(){

                @Override
                public void run() {
                    if (localizedStringsRequest != null) {
                        if (localizedStringsRequest.isDone()) {
                            try {
                                DataUtils.loadOnlineFile(localizedStringsRequest);
                            }
                            catch (IllegalArgumentException | InterruptedException | NullPointerException | ExecutionException e) {
                                DataUtils.handleOnlineFileLoadException(Objects.requireNonNull(localizedStringsRequest), e);
                            }
                            this.cancel();
                        }
                    } else {
                        this.cancel();
                    }
                }
            }, 10, 20, 8);
        }
    }

    public static void shutdownExecutorService() {
        try {
            futureRequestExecutionService.close();
            logger.debug("Executor service shut down.");
        }
        catch (IOException e) {
            logger.error("Failed to shut down executor service.", (Throwable)e);
        }
    }

    public static void onSkyblockJoined() {
        if (!failureMessageShown && !failedRequests.isEmpty()) {
            StringBuilder errorMessageBuilder = new StringBuilder("Failed Requests:\n");
            for (Map.Entry<RemoteFileRequest<?>, Throwable> failedRequest : failedRequests.entrySet()) {
                errorMessageBuilder.append(failedRequest.getKey().getURL()).append("\n");
                errorMessageBuilder.append(failedRequest.getValue().toString()).append("\n");
            }
            ChatComponentText failureMessageComponent = new ChatComponentText(Translations.getMessage("messages.fileFetchFailed", EnumChatFormatting.AQUA + "SkyblockAddons" + EnumChatFormatting.RED, failedRequests.size()));
            IChatComponent buttonRowComponent = new ChatComponentText("[" + Translations.getMessage("messages.copy", new Object[0]) + "]").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.WHITE).func_150227_a(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/sba internal copy %s", errorMessageBuilder))));
            buttonRowComponent.func_150258_a("  ");
            buttonRowComponent.func_150257_a(new ChatComponentText("[Discord]").func_150255_a(new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/PqTAEek"))));
            failureMessageComponent.func_150258_a("\n").func_150257_a(buttonRowComponent);
            main.getUtils().sendMessage(failureMessageComponent, false);
            failureMessageShown = true;
        }
    }

    static String getFileNameFromUrlString(String url) {
        int fileNameIndex;
        int queryParamIndex = url.indexOf(63, fileNameIndex = url.lastIndexOf(47) + 1);
        return url.substring(fileNameIndex, queryParamIndex > fileNameIndex ? queryParamIndex : url.length());
    }

    private static void registerRemoteRequests() {
        remoteRequests.add(new OnlineDataRequest());
        remoteRequests.add(new EnchantedItemListsRequest());
        remoteRequests.add(new ContainersRequest());
        remoteRequests.add(new CompactorItemsRequest());
        remoteRequests.add(new SeaCreaturesRequest());
        remoteRequests.add(new EnchantmentsRequest());
        remoteRequests.add(new CooldownsRequest());
        remoteRequests.add(new SkillXpRequest());
    }

    private static void handleLocalFileReadException(String filePath, Throwable exception) {
        if (FMLClientHandler.instance().isLoading()) {
            throw new DataLoadingException(filePath, exception);
        }
        CrashReport crashReport = CrashReport.func_85055_a((Throwable)exception, (String)String.format("Loading data file at %s", filePath));
        throw new ReportedException(crashReport);
    }

    private static void handleOnlineFileLoadException(RemoteFileRequest<?> request, Throwable exception) {
        String url = request.getURL();
        String fileName = DataUtils.getFileNameFromUrlString(url);
        failedRequests.put(request, exception);
        if (exception instanceof IllegalArgumentException) {
            logger.error(exception.getMessage());
            return;
        }
        if (request.isEssential()) {
            if (FMLClientHandler.instance().isLoading()) {
                throw new DataLoadingException(url, exception);
            }
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)exception, (String)String.format("Loading online data file at %s", fileName));
            throw new ReportedException(crashReport);
        }
        logger.error("Failed to load \"{}\" from the server. The local copy will be used instead.", new Object[]{fileName});
        if (exception != null) {
            logger.error(exception.getMessage());
        }
    }

    public static ArrayList<HttpRequestFutureTask<?>> getHttpRequestFutureTasks() {
        return httpRequestFutureTasks;
    }

    public static HashMap<RemoteFileRequest<?>, Throwable> getFailedRequests() {
        return failedRequests;
    }

    static {
        failureMessageShown = false;
        USE_ONLINE_DATA = !SkyblockAddonsTransformer.isDeobfuscated() || System.getenv().containsKey("FETCH_DATA_ONLINE");
        localizedStringsRequest = null;
        languageLoadingTask = null;
        String country = Locale.getDefault().getCountry();
        if (country.equals("CN") || country.equals("HK")) {
            useFallbackCDN = true;
        }
        connectionManager.setMaxTotal(5);
        connectionManager.setDefaultMaxPerRoute(5);
    }
}

