/*
 * Decompiled with CFR 0.152.
 */
package codes.biscuit.skyblockaddons.utils.data;

import codes.biscuit.skyblockaddons.SkyblockAddons;
import codes.biscuit.skyblockaddons.exceptions.LoadingException;
import codes.biscuit.skyblockaddons.utils.data.DataFetchCallback;
import codes.biscuit.skyblockaddons.utils.data.DataUtils;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpRequestFutureTask;

public class RemoteFileRequest<T> {
    protected static final String NO_DATA_RECEIVED_ERROR = "No data received for get request to \"%s\"";
    private final String REQUEST_URL;
    private final ResponseHandler<T> RESPONSE_HANDLER;
    private final FutureCallback<T> FETCH_CALLBACK;
    private final boolean ESSENTIAL;
    private HttpRequestFutureTask<T> futureTask;

    public RemoteFileRequest(@NonNull String requestPath, @NonNull ResponseHandler<T> responseHandler) {
        this(requestPath, responseHandler, false);
        if (requestPath == null) {
            throw new NullPointerException("requestPath is marked non-null but is null");
        }
        if (responseHandler == null) {
            throw new NullPointerException("responseHandler is marked non-null but is null");
        }
    }

    public RemoteFileRequest(@NonNull String requestPath, @NonNull ResponseHandler<T> responseHandler, boolean essential) {
        this(requestPath, responseHandler, essential, false);
        if (requestPath == null) {
            throw new NullPointerException("requestPath is marked non-null but is null");
        }
        if (responseHandler == null) {
            throw new NullPointerException("responseHandler is marked non-null but is null");
        }
    }

    public RemoteFileRequest(@NonNull String requestPath, @NonNull ResponseHandler<T> responseHandler, boolean essential, boolean usingCustomUrl) {
        if (requestPath == null) {
            throw new NullPointerException("requestPath is marked non-null but is null");
        }
        if (responseHandler == null) {
            throw new NullPointerException("responseHandler is marked non-null but is null");
        }
        this.REQUEST_URL = usingCustomUrl ? requestPath : RemoteFileRequest.getVersionedCDNBaseURL() + requestPath;
        this.RESPONSE_HANDLER = responseHandler;
        this.FETCH_CALLBACK = new DataFetchCallback(URI.create(this.REQUEST_URL));
        this.ESSENTIAL = essential;
        this.futureTask = null;
    }

    public void execute(@NonNull FutureRequestExecutionService executionService) {
        if (executionService == null) {
            throw new NullPointerException("executionService is marked non-null but is null");
        }
        this.futureTask = executionService.execute((HttpUriRequest)new HttpGet(this.REQUEST_URL), null, this.RESPONSE_HANDLER, this.FETCH_CALLBACK);
    }

    public void load() throws InterruptedException, ExecutionException, RuntimeException {
        throw new LoadingException(String.format("Loading method not implemented for file %s", this.REQUEST_URL.substring(this.REQUEST_URL.lastIndexOf(48))), new RuntimeException());
    }

    public String getURL() {
        return this.REQUEST_URL;
    }

    public boolean isEssential() {
        return this.ESSENTIAL;
    }

    protected T getResult() throws InterruptedException, ExecutionException, RuntimeException {
        return (T)this.futureTask.get();
    }

    protected boolean isDone() {
        return this.futureTask.isDone();
    }

    private static String getVersionedCDNBaseURL() {
        return String.format(DataUtils.useFallbackCDN ? "https://fastly.jsdelivr.net/gh/BiscuitDevelopment/SkyblockAddons-Data@%s/" : "https://cdn.jsdelivr.net/gh/BiscuitDevelopment/SkyblockAddons-Data@%s/", SkyblockAddons.VERSION.substring(0, StringUtils.ordinalIndexOf((CharSequence)SkyblockAddons.VERSION, (CharSequence)".", (int)2)));
    }

    public HttpRequestFutureTask<T> getFutureTask() {
        return this.futureTask;
    }
}

