/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.model;

import info.bliki.Messages;
import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.TagToken;
import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.filter.HTMLConverter;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.WikipediaPreTagParser;
import info.bliki.wiki.model.AbstractWikiModel;
import info.bliki.wiki.model.Configuration;
import info.bliki.wiki.model.IConfiguration;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.model.ImageFormat;
import info.bliki.wiki.model.SemanticAttribute;
import info.bliki.wiki.model.SemanticRelation;
import info.bliki.wiki.namespaces.INamespace;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.PTag;
import info.bliki.wiki.tags.WPATag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class WikiModel
extends AbstractWikiModel {
    protected Map<String, String> categories;
    protected Set<String> links;
    protected Set<String> templates;
    protected Set<String> includes;
    protected List<SemanticRelation> semanticRelations;
    protected List<SemanticAttribute> semanticAttributes;
    private String fExternalImageBaseURL;
    private String fExternalWikiBaseURL;

    public WikiModel(String imageBaseURL, String linkBaseURL) {
        this(new Configuration(), imageBaseURL, linkBaseURL);
    }

    public WikiModel(Configuration configuration, String imageBaseURL, String linkBaseURL) {
        super(configuration);
        this.fExternalImageBaseURL = imageBaseURL;
        this.fExternalWikiBaseURL = linkBaseURL;
    }

    public WikiModel(Configuration configuration, Locale locale, String imageBaseURL, String linkBaseURL) {
        super(configuration, locale);
        this.fExternalImageBaseURL = imageBaseURL;
        this.fExternalWikiBaseURL = linkBaseURL;
    }

    public WikiModel(Configuration configuration, Locale locale, INamespace namespace, String imageBaseURL, String linkBaseURL) {
        super(configuration, locale, namespace);
        this.fExternalImageBaseURL = imageBaseURL;
        this.fExternalWikiBaseURL = linkBaseURL;
    }

    @Override
    public void addCategory(String categoryName, String sortKey) {
        this.categories.put(categoryName, sortKey);
    }

    @Override
    public void addLink(String topicName) {
        this.links.add(topicName);
    }

    @Override
    public boolean addSemanticAttribute(String attribute, String attributeValue) {
        if (this.semanticAttributes == null) {
            this.semanticAttributes = new ArrayList<SemanticAttribute>();
        }
        this.semanticAttributes.add(new SemanticAttribute(attribute, attributeValue));
        return true;
    }

    @Override
    public boolean addSemanticRelation(String relation, String relationValue) {
        if (this.semanticRelations == null) {
            this.semanticRelations = new ArrayList<SemanticRelation>();
        }
        this.semanticRelations.add(new SemanticRelation(relation, relationValue));
        return true;
    }

    @Override
    public void addTemplate(String template) {
        this.templates.add(template);
    }

    @Override
    public void addInclude(String pageName) {
        this.includes.add(pageName);
    }

    @Override
    public void appendInternalLink(String topic, String hashSection, String topicDescription, String cssClass, boolean parseRecursive) {
        this.appendInternalLink(topic, hashSection, topicDescription, cssClass, parseRecursive, true);
    }

    protected void appendInternalLink(String topic, String hashSection, String topicDescription, String cssClass, boolean parseRecursive, boolean topicExists) {
        String hrefLink;
        String description = topicDescription.trim();
        WPATag aTagNode = new WPATag();
        if (topic.length() > 0) {
            String pageName;
            String title = Encoder.normaliseTitle(topic, true, ' ', this.casing() == IConfiguration.Casing.FirstLetter);
            if (hashSection == null && title.equals(pageName = Encoder.normaliseTitle(this.fPageTitle, true, ' ', true))) {
                HTMLTag selfLink = new HTMLTag("strong");
                selfLink.addAttribute("class", "selflink", false);
                this.pushNode(selfLink);
                selfLink.addChild(new ContentToken(description));
                this.popNode();
                return;
            }
            String encodedTopic = this.encodeTitleToUrl(topic, this.casing() == IConfiguration.Casing.FirstLetter);
            if (this.replaceColon()) {
                encodedTopic = encodedTopic.replace(':', '/');
            }
            hrefLink = this.getWikiBaseURL().replace("${title}", encodedTopic);
            if (!topicExists) {
                if (cssClass == null) {
                    cssClass = "new";
                }
                hrefLink = hrefLink.indexOf(63) != -1 ? hrefLink + "&" : hrefLink + "?";
                hrefLink = hrefLink + "action=edit&redlink=1";
                String redlinkString = Messages.getString(this.getResourceBundle(), "wiki.tags.red-link", "${title} (page does not exist)");
                title = redlinkString.replace("${title}", title);
            }
            aTagNode.addAttribute("title", title, true);
        } else if (hashSection != null) {
            hrefLink = "";
            if (description.length() == 0) {
                description = "&#35;" + hashSection;
            }
        } else {
            hrefLink = this.getWikiBaseURL().replace("${title}", "");
        }
        String href = hrefLink;
        if (topicExists && hashSection != null) {
            aTagNode.addObjectAttribute("anchor", hashSection);
            href = href + '#' + this.encodeTitleDotUrl(hashSection, false);
        }
        aTagNode.addAttribute("href", href, true);
        if (cssClass != null) {
            aTagNode.addAttribute("class", cssClass, true);
        }
        aTagNode.addObjectAttribute("wikilink", topic);
        this.pushNode(aTagNode);
        if (parseRecursive) {
            WikipediaPreTagParser.parseRecursive(description, this, false, true);
        } else {
            aTagNode.addChild(new ContentToken(description));
        }
        this.popNode();
    }

    public Map<String, String> getCategories() {
        return this.categories;
    }

    @Override
    public Set<String> getLinks() {
        return this.links;
    }

    @Override
    public List<SemanticAttribute> getSemanticAttributes() {
        return this.semanticAttributes;
    }

    @Override
    public List<SemanticRelation> getSemanticRelations() {
        return this.semanticRelations;
    }

    public Set<String> getTemplates() {
        return this.templates;
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    @Override
    public void parseInternalImageLink(String imageNamespace, String rawImageLink) {
        String imageSrc = this.getImageBaseURL();
        if (imageSrc != null) {
            String imageHref = this.getWikiBaseURL();
            ImageFormat imageFormat = ImageFormat.getImageFormat(rawImageLink, imageNamespace);
            String imageName = this.createImageName(imageFormat);
            String link = imageFormat.getLink();
            if (link != null) {
                if (link.length() == 0) {
                    imageHref = "";
                } else {
                    String encodedTitle = this.encodeTitleToUrl(link, true);
                    imageHref = imageHref.replace("${title}", encodedTitle);
                }
            } else {
                imageHref = this.replaceColon() ? imageHref.replace("${title}", imageNamespace + '/' + imageName) : imageHref.replace("${title}", imageNamespace + ':' + imageName);
            }
            imageSrc = imageSrc.replace("${image}", imageName);
            String type2 = imageFormat.getType();
            TagToken tag = null;
            if ("thumb".equals(type2) || "frame".equals(type2)) {
                if (this.fTagStack.size() > 0) {
                    tag = this.peekNode();
                }
                this.reduceTokenStack(Configuration.HTML_DIV_OPEN);
            }
            this.appendInternalImageLink(imageHref, imageSrc, imageFormat);
            if (tag instanceof PTag) {
                this.pushNode(new PTag());
            }
        }
    }

    protected String createImageName(ImageFormat imageFormat) {
        String imageName = imageFormat.getFilename();
        String sizeStr = imageFormat.getWidthStr();
        if (sizeStr != null) {
            imageName = sizeStr + '-' + imageName;
        }
        if (imageName.endsWith(".svg")) {
            imageName = imageName + ".png";
        }
        imageName = Encoder.encodeUrl(imageName);
        if (this.replaceColon()) {
            imageName = imageName.replace(':', '/');
        }
        return imageName;
    }

    @Override
    public boolean replaceColon() {
        return false;
    }

    @Override
    public void setUp() {
        super.setUp();
        this.categories = new HashMap<String, String>();
        this.links = new HashSet<String>();
        this.templates = new HashSet<String>();
        this.includes = new HashSet<String>();
        this.semanticRelations = null;
        this.semanticAttributes = null;
    }

    @Override
    public INamespace getNamespace() {
        return this.fNamespace;
    }

    public static void toText(IWikiModel model, ITextConverter converter, String rawWikiText, Appendable resultBuffer, boolean templateTopic, boolean parseTemplates) throws IOException {
        model.render(converter, rawWikiText, resultBuffer, templateTopic, parseTemplates);
    }

    public static void toHtml(String rawWikiText, Appendable resultBuffer, String imageBaseURL, String linkBaseURL) throws IOException {
        WikiModel.toText(new WikiModel(imageBaseURL, linkBaseURL), new HTMLConverter(), rawWikiText, resultBuffer, false, false);
    }

    public static void toHtml(String rawWikiText, Appendable resultBuffer) throws IOException {
        WikiModel.toText(new WikiModel("/${image}", "/${title}"), new HTMLConverter(), rawWikiText, resultBuffer, false, false);
    }

    public static String toHtml(String rawWikiText) {
        try {
            StringBuilder resultBuffer = new StringBuilder(rawWikiText.length() + rawWikiText.length() / 10);
            WikiModel.toText(new WikiModel("/${image}", "/${title}"), new HTMLConverter(), rawWikiText, resultBuffer, false, false);
            return resultBuffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getImageBaseURL() {
        return this.fExternalImageBaseURL;
    }

    @Override
    public String getWikiBaseURL() {
        return this.fExternalWikiBaseURL;
    }
}

