/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.code;

import info.bliki.wiki.tags.code.AbstractCPPBasedCodeFilter;
import info.bliki.wiki.tags.code.SourceCodeFormatter;
import java.util.HashMap;

public class JavaScriptCodeFilter
extends AbstractCPPBasedCodeFilter
implements SourceCodeFormatter {
    private static HashMap<String, String> KEYWORD_SET = new HashMap();
    private static final String[] KEYWORDS = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "volatile", "while", "with"};
    private static HashMap<String, String> OBJECT_SET = new HashMap();

    @Override
    public String filter(String input) {
        char[] source = input.toCharArray();
        int currentPosition = 0;
        int identStart = 0;
        char currentChar = ' ';
        HashMap<String, String> keywordsSet = this.getKeywordSet();
        HashMap<String, String> objectsSet = this.getObjectSet();
        StringBuilder result2 = new StringBuilder(input.length() + input.length() / 4);
        boolean identFound = false;
        try {
            while (true) {
                if ((currentChar = source[currentPosition++]) >= 'A' && currentChar <= 'Z' || currentChar == '_' || currentChar >= 'a' && currentChar <= 'z') {
                    identStart = currentPosition - 1;
                    identFound = true;
                    while (currentChar >= 'a' && currentChar <= 'z' || currentChar >= 'A' && currentChar <= 'Z' || currentChar == '_') {
                        currentChar = source[currentPosition++];
                    }
                    currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, objectsSet, result2);
                    identFound = false;
                    continue;
                }
                if (currentChar == '\"') {
                    result2.append("<span style=\"color:#2A00FF; \">");
                    JavaScriptCodeFilter.appendChar(result2, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        JavaScriptCodeFilter.appendChar(result2, currentChar);
                        if (currentChar == '\\') {
                            currentChar = source[currentPosition++];
                            JavaScriptCodeFilter.appendChar(result2, currentChar);
                            continue;
                        }
                        if (currentChar != 34) continue;
                    }
                    result2.append("</span>");
                    continue;
                }
                if (currentChar == '\'') {
                    result2.append("<span style=\"color:#2A00FF; \">");
                    JavaScriptCodeFilter.appendChar(result2, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        JavaScriptCodeFilter.appendChar(result2, currentChar);
                        if (currentChar == '\\') {
                            currentChar = source[currentPosition++];
                            JavaScriptCodeFilter.appendChar(result2, currentChar);
                            continue;
                        }
                        if (currentChar != 39) continue;
                    }
                    result2.append("</span>");
                    continue;
                }
                if (currentChar == '/' && currentPosition < input.length() && source[currentPosition] == '/') {
                    result2.append("<span style=\"color:#3F7F5F; \">");
                    JavaScriptCodeFilter.appendChar(result2, currentChar);
                    JavaScriptCodeFilter.appendChar(result2, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        JavaScriptCodeFilter.appendChar(result2, currentChar);
                        if (currentChar != 10) continue;
                    }
                    result2.append("</span>");
                    continue;
                }
                if (currentChar == '/' && currentPosition < input.length() && source[currentPosition] == '*') {
                    if (currentPosition < input.length() - 1 && source[currentPosition + 1] == '*') {
                        result2.append("<span style=\"color:#3F5FBF; \">");
                    } else {
                        result2.append("<span style=\"color:#3F7F5F; \">");
                    }
                    JavaScriptCodeFilter.appendChar(result2, currentChar);
                    JavaScriptCodeFilter.appendChar(result2, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        JavaScriptCodeFilter.appendChar(result2, currentChar);
                        if (currentChar != 47 || source[currentPosition - 2] != '*') continue;
                    }
                    result2.append("</span>");
                    continue;
                }
                JavaScriptCodeFilter.appendChar(result2, currentChar);
            }
        }
        catch (IndexOutOfBoundsException e2) {
            if (identFound) {
                currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, null, result2);
            }
            return result2.toString();
        }
    }

    @Override
    public HashMap<String, String> getKeywordSet() {
        return KEYWORD_SET;
    }

    @Override
    public HashMap<String, String> getObjectSet() {
        return OBJECT_SET;
    }

    static {
        for (int i = 0; i < KEYWORDS.length; ++i) {
            JavaScriptCodeFilter.createHashMap(KEYWORD_SET, KEYWORDS[i]);
        }
    }
}

