/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.cosmetics;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.cosmetics.NEUCape;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.potion.Potion;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL30;

public class CapeManager {
    public static final CapeManager INSTANCE = new CapeManager();
    public long lastCapeUpdate = 0L;
    public long lastCapeSynced = 0L;
    public Pair<NEUCape, String> localCape = null;
    private final HashMap<String, Pair<NEUCape, String>> capeMap = new HashMap();
    private int permSyncTries = 5;
    private boolean allAvailable = false;
    private final HashSet<String> availableCapes = new HashSet();
    public JsonObject lastJsonSync = null;
    public CapeData[] capes = new CapeData[]{new CapeData("patreon1", false, false), new CapeData("patreon2", false, false), new CapeData("fade", false, false), new CapeData("space", false, false), new CapeData("mcworld", false, false), new CapeData("negative", false, false), new CapeData("void", false, false), new CapeData("lava", false, false), new CapeData("tunnel", false, false), new CapeData("planets", false, false), new CapeData("screensaver", false, false), new CapeData("nullzee", true, false), new CapeData("ironmoon", true, false), new CapeData("gravy", true, false), new CapeData("contrib", true, false), new CapeData("mbstaff", true, false), new CapeData("thebakery", true, false), new CapeData("furf", true, false), new CapeData("dsm", true, false), new CapeData("skyclient", true, false), new CapeData("subreddit_dark", true, false), new CapeData("subreddit_light", true, false), new CapeData("packshq", true, false), new CapeData("skytils", true, false), new CapeData("sbp", true, false), new CapeData("sharex", true, false), new CapeData("sharex_white", true, false), new CapeData("dg", true, false), new CapeData("jakethybro", false, true), new CapeData("krusty", false, true), new CapeData("krusty_day", false, true), new CapeData("krusty_sunset", false, true), new CapeData("krusty_night", false, true), new CapeData("zera", false, true), new CapeData("soldier", false, true), new CapeData("alexxoffi", false, true), new CapeData("secondpfirsisch", false, true), new CapeData("stormy_lh", false, true)};
    public boolean updateWorldFramebuffer = false;
    public Framebuffer backgroundFramebuffer = null;
    private static final ExecutorService CAPE_TICKER = Executors.newCachedThreadPool();

    public static CapeManager getInstance() {
        return INSTANCE;
    }

    public void tryUnlockCape(String unlock) {
        for (CapeData data : this.capes) {
            if (!data.capeName.equalsIgnoreCase(unlock)) continue;
            data.hidden = false;
        }
    }

    public void tick() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCapeUpdate > 60000L) {
            this.lastCapeUpdate = currentTime;
            this.updateCapes();
        }
    }

    private void updateCapes() {
        NotEnoughUpdates.INSTANCE.manager.apiUtils.newMoulberryRequest("activecapes.json").requestJson().thenAcceptAsync(jsonObject -> {
            if (jsonObject.get("success").getAsBoolean()) {
                this.lastJsonSync = jsonObject;
                this.lastCapeSynced = System.currentTimeMillis();
                this.capeMap.clear();
                for (JsonElement active : jsonObject.get("active").getAsJsonArray()) {
                    if (!active.isJsonObject()) continue;
                    JsonObject activeObj = (JsonObject)active;
                    this.setCape(activeObj.get("_id").getAsString(), activeObj.get("capeType").getAsString(), false);
                }
            }
        });
        if (Minecraft.func_71410_x().field_71439_g != null && this.permSyncTries > 0) {
            String uuid = Minecraft.func_71410_x().field_71439_g.func_110124_au().toString().replace("-", "");
            --this.permSyncTries;
            NotEnoughUpdates.INSTANCE.manager.apiUtils.newMoulberryRequest("permscapes.json").requestJson().thenAcceptAsync(jsonObject -> {
                if (!jsonObject.get("success").getAsBoolean()) {
                    return;
                }
                this.permSyncTries = 0;
                this.availableCapes.clear();
                for (JsonElement permPlayer : jsonObject.get("perms").getAsJsonArray()) {
                    String playerUuid;
                    if (!permPlayer.isJsonObject() || (playerUuid = permPlayer.getAsJsonObject().get("_id").getAsString()) == null || !playerUuid.equals(uuid)) continue;
                    for (JsonElement perm : permPlayer.getAsJsonObject().get("perms").getAsJsonArray()) {
                        if (!perm.isJsonPrimitive()) continue;
                        String cape = perm.getAsString();
                        if (cape.equals("*")) {
                            this.allAvailable = true;
                            continue;
                        }
                        this.availableCapes.add(cape);
                    }
                    return;
                }
            });
        }
    }

    public HashSet<String> getAvailableCapes() {
        return this.allAvailable ? null : this.availableCapes;
    }

    public void setCape(String playerUUID, String capename, boolean updateConfig) {
        boolean none = capename == null || capename.equals("null");
        boolean bl = updateConfig = updateConfig && playerUUID.equals(Minecraft.func_71410_x().field_71439_g.func_110124_au().toString().replace("-", ""));
        if (updateConfig) {
            NotEnoughUpdates.INSTANCE.config.hidden.selectedCape = String.valueOf(capename);
        }
        if (updateConfig) {
            this.localCape = none ? null : new MutablePair((Object)new NEUCape(capename), (Object)capename);
        } else if (this.capeMap.containsKey(playerUUID)) {
            if (none) {
                this.capeMap.remove(playerUUID);
            } else {
                Pair<NEUCape, String> capePair = this.capeMap.get(playerUUID);
                capePair.setValue((Object)capename);
            }
        } else if (!none) {
            this.capeMap.put(playerUUID, (Pair<NEUCape, String>)new MutablePair((Object)new NEUCape(capename), (Object)capename));
        }
    }

    public String getCape(String player) {
        if (this.capeMap.containsKey(player)) {
            return (String)this.capeMap.get(player).getRight();
        }
        return null;
    }

    private static Framebuffer checkFramebufferSizes(Framebuffer framebuffer, int width, int height) {
        if (framebuffer == null || framebuffer.field_147621_c != width || framebuffer.field_147618_d != height) {
            if (framebuffer == null) {
                framebuffer = new Framebuffer(width, height, true);
            } else {
                framebuffer.func_147613_a(width, height);
            }
            framebuffer.func_147607_a(9728);
        }
        return framebuffer;
    }

    public void postRenderBlocks() {
        int width = Minecraft.func_71410_x().field_71443_c;
        int height = Minecraft.func_71410_x().field_71440_d;
        this.backgroundFramebuffer = CapeManager.checkFramebufferSizes(this.backgroundFramebuffer, width, height);
        if (OpenGlHelper.func_148822_b() && this.updateWorldFramebuffer) {
            GL30.glBindFramebuffer((int)36008, (int)Minecraft.func_71410_x().func_147110_a().field_147616_f);
            GL30.glBindFramebuffer((int)36009, (int)this.backgroundFramebuffer.field_147616_f);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)width, (int)height, (int)0, (int)0, (int)width, (int)height, (int)16384, (int)9728);
            Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
        }
        this.updateWorldFramebuffer = false;
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post e2) {
        if (e2.partialRenderTick == 1.0f) {
            return;
        }
        try {
            String selCape;
            String uuid = e2.entityPlayer.func_110124_au().toString().replace("-", "");
            String clientUuid = Minecraft.func_71410_x().field_71439_g.func_110124_au().toString().replace("-", "");
            if (Minecraft.func_71410_x().field_71439_g != null && uuid.equals(clientUuid) && (selCape = NotEnoughUpdates.INSTANCE.config.hidden.selectedCape) != null && !selCape.isEmpty()) {
                if (this.localCape == null) {
                    this.localCape = new MutablePair((Object)new NEUCape(selCape), (Object)selCape);
                } else {
                    this.localCape.setValue((Object)selCape);
                }
            }
            if (uuid.equals(clientUuid) && this.localCape != null && this.localCape.getRight() != null && !((String)this.localCape.getRight()).equals("null")) {
                ((NEUCape)this.localCape.getLeft()).onRenderPlayer(e2);
            } else if (!Minecraft.func_71410_x().field_71439_g.func_70644_a(Potion.field_76440_q) && this.capeMap.containsKey(uuid)) {
                ((NEUCape)this.capeMap.get(uuid).getLeft()).onRenderPlayer(e2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        boolean hasLocalCape;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        if (event.player == null) {
            return;
        }
        String uuid = event.player.func_110124_au().toString().replace("-", "");
        boolean isLocalPlayer = event.player == Minecraft.func_71410_x().field_71439_g;
        boolean bl = hasLocalCape = this.localCape != null && this.localCape.getRight() != null && !((String)this.localCape.getRight()).equals("null");
        if (!(this.capeMap.containsKey(uuid) || hasLocalCape && isLocalPlayer)) {
            return;
        }
        try {
            String capeName;
            Pair<NEUCape, String> entry = this.capeMap.get(uuid);
            String string = capeName = entry == null ? null : (String)entry.getRight();
            if (isLocalPlayer && hasLocalCape) {
                ((NEUCape)this.localCape.getLeft()).setCapeTexture((String)this.localCape.getValue());
                CAPE_TICKER.submit(() -> ((NEUCape)this.localCape.getLeft()).onTick(event.player));
            } else if (capeName != null && !capeName.equals("null")) {
                ((NEUCape)entry.getLeft()).setCapeTexture(capeName);
                CAPE_TICKER.submit(() -> ((NEUCape)this.capeMap.get(uuid).getLeft()).onTick(event.player));
            } else {
                this.capeMap.remove(uuid);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CapeData[] getCapes() {
        return this.capes;
    }

    public static class CapeData {
        public String capeName;
        public boolean special;
        public boolean hidden;

        public boolean canShow() {
            return !this.special && !this.hidden;
        }

        public CapeData(String capeName, boolean special, boolean hidden) {
            this.capeName = capeName;
            this.special = special;
            this.hidden = hidden;
        }
    }
}

