/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui;

import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.RenderUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.TextRenderUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.processor.ProcessedOption;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import org.jetbrains.annotations.ApiStatus;

public abstract class GuiOptionEditor {
    private static final int HEIGHT = 45;
    protected final ProcessedOption option;
    private String searchDescNameCache;

    @ApiStatus.Internal
    public ProcessedOption getOption() {
        return this.option;
    }

    public GuiOptionEditor(ProcessedOption option) {
        this.option = option;
    }

    public void render(int x, int y, int width) {
        int height = this.getHeight();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        RenderUtils.drawFloatingRectDark(x, y, width, height, true);
        TextRenderUtils.drawStringCenteredScaledMaxWidth(this.option.name, fr, x + width / 6, y + 13, true, width / 3 - 10, 0xC0C0C0);
        int maxLines = 5;
        float scale = 1.0f;
        int lineCount = fr.func_78271_c(this.option.desc, width * 2 / 3 - 10).size();
        if (lineCount <= 0) {
            return;
        }
        float paraHeight = 9 * lineCount - 1;
        while (paraHeight >= 35.0f) {
            lineCount = fr.func_78271_c(this.option.desc, (int)((float)(width * 2 / 3) / (scale -= 0.125f) - 10.0f)).size();
            paraHeight = (int)(9.0f * scale * (float)lineCount - 1.0f * scale);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)(x + 5) + (float)width / 3.0f), (float)((float)y + 22.5f - paraHeight / 2.0f), (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        fr.func_78279_b(this.option.desc, 0, 0, (int)((float)(width * 2 / 3) / scale - 10.0f), 0xC0C0C0);
        GlStateManager.func_179121_F();
    }

    public int getHeight() {
        return 45;
    }

    public abstract boolean mouseInput(int var1, int var2, int var3, int var4, int var5);

    public abstract boolean keyboardInput();

    public boolean mouseInputOverlay(int x, int y, int width, int mouseX, int mouseY) {
        return false;
    }

    public void renderOverlay(int x, int y, int width) {
    }

    public boolean fulfillsSearch(String word) {
        if (this.searchDescNameCache == null) {
            this.searchDescNameCache = (this.option.name + this.option.desc).toLowerCase(Locale.ROOT);
        }
        return this.searchDescNameCache.contains(word);
    }
}

