/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.infopanes;

import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NEUOverlay;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.BackgroundBlur;
import io.github.moulberry.notenoughupdates.infopanes.HTMLInfoPane;
import io.github.moulberry.notenoughupdates.infopanes.TextInfoPane;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;

public abstract class InfoPane
extends Gui {
    final NEUOverlay overlay;
    final NEUManager manager;

    public InfoPane(NEUOverlay overlay, NEUManager manager) {
        this.overlay = overlay;
        this.manager = manager;
    }

    public void reset() {
    }

    public void tick() {
    }

    public abstract void render(int var1, int var2, Color var3, Color var4, ScaledResolution var5, int var6, int var7);

    public abstract void mouseInput(int var1, int var2, int var3, int var4, boolean var5);

    public void mouseInputOutside() {
    }

    public abstract boolean keyboardInput();

    public void renderDefaultBackground(int width, int height, Color bg) {
        int paneWidth = (int)((float)(width / 3) * this.overlay.getWidthMult());
        int rightSide = (int)((float)width * this.overlay.getInfoPaneOffsetFactor());
        int leftSide = rightSide - paneWidth;
        int boxLeft = leftSide + this.overlay.getBoxPadding() - 5;
        int boxRight = rightSide - this.overlay.getBoxPadding() + 5;
        BackgroundBlur.renderBlurredBackground(NotEnoughUpdates.INSTANCE.config.itemlist.bgBlurFactor, width, height, boxLeft, this.overlay.getBoxPadding() - 5, boxRight - boxLeft, height - this.overlay.getBoxPadding() * 2 + 10, true);
        InfoPane.func_73734_a((int)boxLeft, (int)(this.overlay.getBoxPadding() - 5), (int)boxRight, (int)(height - this.overlay.getBoxPadding() + 5), (int)bg.getRGB());
    }

    public static CompletableFuture<? extends InfoPane> create(NEUOverlay overlay, NEUManager manager, String infoType, String name, String internalName, String infoText) {
        switch (infoType.intern()) {
            case "WIKI_URL": {
                return HTMLInfoPane.createFromWikiUrl(overlay, manager, name, infoText);
            }
            case "WIKI": {
                return CompletableFuture.completedFuture(HTMLInfoPane.createFromWikiText(overlay, manager, name, internalName, infoText, false));
            }
            case "HTML": {
                return CompletableFuture.completedFuture(new HTMLInfoPane(overlay, manager, name, internalName, infoText, false));
            }
        }
        return CompletableFuture.completedFuture(new TextInfoPane(overlay, manager, name, infoText));
    }
}

