/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.ConfigUtil;
import io.github.moulberry.notenoughupdates.core.config.KeybindHelper;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.events.ReplaceItemEvent;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.StorageManager;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiContainer;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class SlotLocking {
    private static final SlotLocking INSTANCE = new SlotLocking();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final LockedSlot DEFAULT_LOCKED_SLOT = new LockedSlot();
    private final ResourceLocation LOCK = new ResourceLocation("notenoughupdates:slotlocking/lock.png");
    private final ResourceLocation BOUND = new ResourceLocation("notenoughupdates:slotlocking/bound.png");
    private SlotLockingConfig config = new SlotLockingConfig();
    private boolean lockKeyHeld = false;
    private Slot pairingSlot = null;
    private Slot realSlot = null;
    private final long[] slotChanges = new long[9];
    private static final Pattern WINDOW_REGEX = Pattern.compile(".+ Backpack (?:\u2726 )?\\(Slot #(\\d+)\\)");
    private static final Pattern ECHEST_WINDOW_REGEX = Pattern.compile("Ender Chest \\((\\d+)/(\\d+)\\)");
    boolean setTopHalfBarrier = false;

    public static SlotLocking getInstance() {
        return INSTANCE;
    }

    public void setRealSlot(Slot slot) {
        this.realSlot = slot;
    }

    public Slot getRealSlot() {
        return this.realSlot;
    }

    public void loadConfig(File file) {
        this.config = ConfigUtil.loadConfig(SlotLockingConfig.class, file, GSON);
        if (this.config == null) {
            this.config = new SlotLockingConfig();
        }
    }

    public void changedSlot(int slotNumber) {
        int pingModifier = NotEnoughUpdates.INSTANCE.config.slotLocking.slotLockSwapDelay;
        if (pingModifier == 0) {
            return;
        }
        if (!this.isSlotIndexLocked(slotNumber)) {
            return;
        }
        long currentTimeMilis = System.currentTimeMillis();
        for (int i = 0; i < this.slotChanges.length; ++i) {
            if (i == slotNumber || this.slotChanges[i] == 0L || this.slotChanges[i] + (long)pingModifier <= currentTimeMilis) continue;
            this.slotChanges[i] = 0L;
        }
        this.slotChanges[slotNumber] = currentTimeMilis;
    }

    public boolean isSwapedSlotLocked() {
        int pingModifier = NotEnoughUpdates.INSTANCE.config.slotLocking.slotLockSwapDelay;
        if (pingModifier == 0) {
            return false;
        }
        long currentTimeMilis = System.currentTimeMillis();
        for (int i = 0; i < this.slotChanges.length; ++i) {
            if (this.slotChanges[i] == 0L || !this.isSlotIndexLocked(i) || this.slotChanges[i] + (long)pingModifier <= currentTimeMilis) continue;
            return true;
        }
        return false;
    }

    public void saveConfig(File file) {
        ConfigUtil.saveConfig(this.config, file, GSON);
    }

    private LockedSlot[] getDataForProfile() {
        String profileName;
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard() || !NotEnoughUpdates.INSTANCE.config.slotLocking.enableSlotLocking) {
            return null;
        }
        if (NotEnoughUpdates.INSTANCE.config.slotLocking.disableInStorage) {
            if (StorageManager.getInstance().isStorageOpen) {
                return null;
            }
            String openChestName = Utils.getOpenChestName();
            if (openChestName.trim().equals("Storage")) {
                return null;
            }
            openChestName = Utils.cleanColour(openChestName);
            Matcher matcher = WINDOW_REGEX.matcher(openChestName);
            Matcher matcherEchest = ECHEST_WINDOW_REGEX.matcher(openChestName);
            if (matcher.matches() || matcherEchest.matches()) {
                return null;
            }
        }
        if ((profileName = SBInfo.getInstance().currentProfile) == null) {
            profileName = "generic";
        }
        SlotLockProfile profile = this.config.profileData.computeIfAbsent(profileName, k -> new SlotLockProfile());
        if (profile.slotLockData[0] == null) {
            profile.slotLockData[0] = new SlotLockData();
        }
        if (!"rift".equals(SBInfo.getInstance().getLocation())) {
            return profile.slotLockData[0].lockedSlots;
        }
        return profile.slotLockData[0].riftLockedSlots;
    }

    private LockedSlot getLockedSlot(LockedSlot[] lockedSlots, int index) {
        if (lockedSlots == null) {
            return DEFAULT_LOCKED_SLOT;
        }
        LockedSlot slot = lockedSlots[index];
        if (slot == null) {
            return DEFAULT_LOCKED_SLOT;
        }
        return slot;
    }

    private Slot getFocusedSlot(GuiContainer container) {
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int scaledWidth = scaledresolution.func_78326_a();
        int scaledHeight = scaledresolution.func_78328_b();
        int mouseX = Mouse.getX() * scaledWidth / Minecraft.func_71410_x().field_71443_c;
        int mouseY = scaledHeight - Mouse.getY() * scaledHeight / Minecraft.func_71410_x().field_71440_d - 1;
        return ((AccessorGuiContainer)container).doGetSlotAtPosition(mouseX, mouseY);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void keyboardInput(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        int slotNum;
        Slot slot;
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard() || !NotEnoughUpdates.INSTANCE.config.slotLocking.enableSlotLocking) {
            return;
        }
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
            return;
        }
        GuiContainer container = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        int key = NotEnoughUpdates.INSTANCE.config.slotLocking.slotLockKey;
        if (!this.lockKeyHeld && KeybindHelper.isKeyPressed(key) && !Keyboard.isRepeatEvent() && (slot = this.getFocusedSlot(container)) != null && slot.getSlotIndex() != 8 && slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by && (slotNum = slot.getSlotIndex()) >= 0 && slotNum <= 39) {
            boolean isHotbar = slotNum < 9;
            boolean isInventory = !isHotbar && slotNum < 36;
            boolean isArmor = !isHotbar && !isInventory;
            this.pairingSlot = isInventory || isArmor ? slot : null;
            LockedSlot[] lockedSlots = this.getDataForProfile();
            if (lockedSlots != null) {
                float vol;
                if (lockedSlots[slotNum] == null) {
                    lockedSlots[slotNum] = new LockedSlot();
                }
                lockedSlots[slotNum].locked = !lockedSlots[slotNum].locked;
                lockedSlots[slotNum].boundTo = -1;
                if (NotEnoughUpdates.INSTANCE.config.slotLocking.slotLockSound && (vol = NotEnoughUpdates.INSTANCE.config.slotLocking.slotLockSoundVol / 100.0f) > 0.0f) {
                    if (vol > 1.0f) {
                        vol = 1.0f;
                    }
                    final float volF = vol;
                    final boolean locked = lockedSlots[slotNum].locked;
                    PositionedSound sound = new PositionedSound(new ResourceLocation("random.orb")){
                        {
                            super(x0);
                            this.field_147662_b = volF;
                            this.field_147663_c = locked ? 0.943f : 0.1f;
                            this.field_147659_g = false;
                            this.field_147665_h = 0;
                            this.field_147666_i = ISound.AttenuationType.NONE;
                        }
                    };
                    float oldLevel = Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.PLAYERS);
                    Minecraft.func_71410_x().field_71474_y.func_151439_a(SoundCategory.PLAYERS, 1.0f);
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
                    Minecraft.func_71410_x().field_71474_y.func_151439_a(SoundCategory.PLAYERS, oldLevel);
                }
                if (isHotbar && lockedSlots[slotNum].locked) {
                    for (int i = 9; i <= 39; ++i) {
                        if (lockedSlots[i] == null || lockedSlots[i].boundTo != slotNum) continue;
                        lockedSlots[i].boundTo = -1;
                    }
                }
            }
        }
        this.lockKeyHeld = KeybindHelper.isKeyDown(key);
        if (!this.lockKeyHeld) {
            this.pairingSlot = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void mouseEvent(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard() || !NotEnoughUpdates.INSTANCE.config.slotLocking.enableSlotLocking) {
            return;
        }
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
            return;
        }
        GuiContainer container = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        if (NotEnoughUpdates.INSTANCE.config.slotLocking.enableSlotBinding && this.lockKeyHeld && this.pairingSlot != null) {
            int mouseY;
            ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
            int scaledWidth = scaledresolution.func_78326_a();
            int scaledHeight = scaledresolution.func_78328_b();
            int mouseX = Mouse.getX() * scaledWidth / Minecraft.func_71410_x().field_71443_c;
            Slot slot = ((AccessorGuiContainer)container).doGetSlotAtPosition(mouseX, mouseY = scaledHeight - Mouse.getY() * scaledHeight / Minecraft.func_71410_x().field_71440_d - 1);
            if (slot != null && slot.getSlotIndex() != 8 && slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by) {
                int slotNum = slot.getSlotIndex();
                if (slotNum >= 0 && slotNum <= 39) {
                    LockedSlot[] lockedSlots;
                    boolean isHotbar = slotNum < 9;
                    boolean isInventory = !isHotbar && slotNum < 36;
                    boolean isArmor = !isHotbar && !isInventory;
                    int pairingNum = this.pairingSlot.getSlotIndex();
                    if (isHotbar && slotNum != pairingNum && (lockedSlots = this.getDataForProfile()) != null) {
                        if (lockedSlots[slotNum] == null) {
                            lockedSlots[slotNum] = new LockedSlot();
                        }
                        if (!lockedSlots[slotNum].locked) {
                            if (lockedSlots[pairingNum] == null) {
                                lockedSlots[pairingNum] = new LockedSlot();
                            }
                            lockedSlots[pairingNum].boundTo = slotNum;
                            lockedSlots[pairingNum].locked = false;
                            lockedSlots[slotNum].boundTo = pairingNum;
                        }
                    }
                }
            } else {
                int pairingNum = this.pairingSlot.getSlotIndex();
                LockedSlot[] lockedSlots = this.getDataForProfile();
                if (lockedSlots != null && lockedSlots[pairingNum] != null) {
                    if (lockedSlots[pairingNum].boundTo >= 0) {
                        lockedSlots[lockedSlots[pairingNum].boundTo] = null;
                    }
                    lockedSlots[pairingNum] = null;
                }
            }
        }
    }

    public void toggleLock(int lockIndex) {
        if (lockIndex == 8) {
            return;
        }
        LockedSlot[] lockedSlots = this.getDataForProfile();
        if (lockedSlots != null) {
            float vol;
            if (lockedSlots[lockIndex] == null) {
                lockedSlots[lockIndex] = new LockedSlot();
            }
            lockedSlots[lockIndex].locked = !lockedSlots[lockIndex].locked;
            lockedSlots[lockIndex].boundTo = -1;
            if (NotEnoughUpdates.INSTANCE.config.slotLocking.slotLockSound && (vol = NotEnoughUpdates.INSTANCE.config.slotLocking.slotLockSoundVol / 100.0f) > 0.0f) {
                if (vol > 1.0f) {
                    vol = 1.0f;
                }
                final float volF = vol;
                final boolean locked = lockedSlots[lockIndex].locked;
                PositionedSound sound = new PositionedSound(new ResourceLocation("random.orb")){
                    {
                        super(x0);
                        this.field_147662_b = volF;
                        this.field_147663_c = locked ? 0.943f : 0.1f;
                        this.field_147659_g = false;
                        this.field_147665_h = 0;
                        this.field_147666_i = ISound.AttenuationType.NONE;
                    }
                };
                float oldLevel = Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.PLAYERS);
                Minecraft.func_71410_x().field_71474_y.func_151439_a(SoundCategory.PLAYERS, 1.0f);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
                Minecraft.func_71410_x().field_71474_y.func_151439_a(SoundCategory.PLAYERS, oldLevel);
            }
            if (lockIndex < 9 && lockedSlots[lockIndex].locked) {
                for (int i = 9; i <= 39; ++i) {
                    if (lockedSlots[i] == null || lockedSlots[i].boundTo != lockIndex) continue;
                    lockedSlots[i].boundTo = -1;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void drawScreenEvent(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (NotEnoughUpdates.INSTANCE.config.slotLocking.enableSlotBinding && !event.isCanceled() && this.pairingSlot != null && this.lockKeyHeld) {
            LockedSlot[] lockedSlots = this.getDataForProfile();
            LockedSlot lockedSlot = this.getLockedSlot(lockedSlots, this.pairingSlot.getSlotIndex());
            if (lockedSlot.boundTo >= 0 && lockedSlot.boundTo < 8) {
                return;
            }
            if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                return;
            }
            AccessorGuiContainer container = (AccessorGuiContainer)Minecraft.func_71410_x().field_71462_r;
            int x1 = container.getGuiLeft() + this.pairingSlot.field_75223_e + 8;
            int y1 = container.getGuiTop() + this.pairingSlot.field_75221_f + 8;
            int x2 = event.mouseX;
            int y2 = event.mouseY;
            if (x2 > x1 - 8 && x2 < x1 + 8 && y2 > y1 - 8 && y2 < y1 + 8) {
                return;
            }
            this.drawLinkArrow(x1, y1, x2, y2);
            this.setTopHalfBarrier = true;
        } else {
            this.setTopHalfBarrier = false;
        }
    }

    private void drawLinkArrow(int x1, int y1, int x2, int y2) {
        GlStateManager.func_179131_c((float)0.2f, (float)0.93333334f, (float)0.8666667f, (float)1.0f);
        GlStateManager.func_179140_f();
        RenderHelper.func_74518_a();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
        this.drawLine(x1, y1, x2, y2);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
        GlStateManager.func_179098_w();
    }

    private void drawLine(int x1, int y1, int x2, int y2) {
        Vector2f vec = new Vector2f((float)(x2 - x1), (float)(y2 - y1));
        vec.normalise(vec);
        Vector2f side = new Vector2f(vec.y, -vec.x);
        GL11.glLineWidth((float)1.0f);
        GL11.glEnable((int)2848);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        int lines = 6;
        for (int i = 0; i < lines; ++i) {
            worldrenderer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
            worldrenderer.func_181662_b((double)((float)x1 - side.x + side.x * (float)i / (float)lines), (double)((float)y1 - side.y + side.y * (float)i / (float)lines), 0.0).func_181675_d();
            worldrenderer.func_181662_b((double)((float)x2 - side.x + side.x * (float)i / (float)lines), (double)((float)y2 - side.y + side.y * (float)i / (float)lines), 0.0).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    @SubscribeEvent
    public void onWindowClick(SlotClickEvent slotClickEvent) {
        LockedSlot locked = this.getLockedSlot(slotClickEvent.slot);
        if (locked == null) {
            return;
        }
        if (locked.locked || slotClickEvent.clickType == 2 && SlotLocking.getInstance().isSlotIndexLocked(slotClickEvent.clickedButton)) {
            slotClickEvent.setCanceled(true);
            return;
        }
        if (NotEnoughUpdates.INSTANCE.config.slotLocking.enableSlotBinding && slotClickEvent.clickType == 1 && locked.boundTo != -1) {
            int to;
            int from;
            Slot boundSlot = slotClickEvent.guiContainer.field_147002_h.func_75147_a((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by, locked.boundTo);
            if (boundSlot == null) {
                return;
            }
            LockedSlot boundLocked = this.getLockedSlot(boundSlot);
            if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                return;
            }
            GuiContainer container = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
            int size = container.field_147002_h.field_75151_b.size();
            int id = slotClickEvent.slot.getSlotIndex();
            int idChest = id + (size - 45);
            if (idChest >= 9 && 0 <= locked.boundTo && locked.boundTo < 8 && !boundLocked.locked) {
                from = idChest;
                to = locked.boundTo;
                if (boundLocked == DEFAULT_LOCKED_SLOT) {
                    LockedSlot[] lockedSlots = this.getDataForProfile();
                    lockedSlots[locked.boundTo] = new LockedSlot();
                    lockedSlots[locked.boundTo].boundTo = idChest;
                } else {
                    boundLocked.boundTo = id;
                }
            } else if (0 <= id && id < 8 && locked.boundTo >= 9 && locked.boundTo <= 39) {
                if (boundLocked.locked || boundLocked.boundTo != id) {
                    locked.boundTo = -1;
                    return;
                }
                from = boundSlot.field_75222_d;
                to = id;
            } else {
                return;
            }
            if (from == 39) {
                from = 5;
            }
            if (from == 38) {
                from = 6;
            }
            if (from == 37) {
                from = 7;
            }
            if (from == 36) {
                from = 8;
            }
            Minecraft.func_71410_x().field_71442_b.func_78753_a(slotClickEvent.guiContainer.field_147002_h.field_75152_c, from, to, 2, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            slotClickEvent.setCanceled(true);
        } else if (NotEnoughUpdates.INSTANCE.config.slotLocking.enableSlotBinding && locked.boundTo != -1 && NotEnoughUpdates.INSTANCE.config.slotLocking.bindingAlsoLocks) {
            slotClickEvent.setCanceled(true);
        }
    }

    public void drawSlot(Slot slot) {
        LockedSlot locked = this.getLockedSlot(slot);
        if (locked != null) {
            if (locked.locked) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)400.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.LOCK);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                GlStateManager.func_179132_a((boolean)false);
                RenderUtils.drawTexturedRect(slot.field_75223_e, slot.field_75221_f, 16.0f, 16.0f, 0.0f, 1.0f, 0.0f, 1.0f, 9728);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179147_l();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-400.0f);
            } else if (NotEnoughUpdates.INSTANCE.config.slotLocking.enableSlotBinding && slot.func_111238_b() && locked.boundTo >= 0 && locked.boundTo <= 39) {
                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                    return;
                }
                GuiContainer container = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
                int scaledWidth = scaledresolution.func_78326_a();
                int scaledHeight = scaledresolution.func_78328_b();
                int mouseX = Mouse.getX() * scaledWidth / Minecraft.func_71410_x().field_71443_c;
                int mouseY = scaledHeight - Mouse.getY() * scaledHeight / Minecraft.func_71410_x().field_71440_d - 1;
                Slot boundSlot = container.field_147002_h.func_75147_a((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by, locked.boundTo);
                if (boundSlot == null) {
                    return;
                }
                boolean hoverOverSlot = ((AccessorGuiContainer)container).doIsMouseOverSlot(slot, mouseX, mouseY);
                if (hoverOverSlot || slot.getSlotIndex() >= 9) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.BOUND);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                    GlStateManager.func_179132_a((boolean)false);
                    RenderUtils.drawTexturedRect(slot.field_75223_e, slot.field_75221_f, 16.0f, 16.0f, 0.0f, 1.0f, 0.0f, 1.0f, 9728);
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179147_l();
                    if (slot.func_75211_c() != null) {
                        Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71466_p, slot.func_75211_c(), slot.field_75223_e, slot.field_75221_f, null);
                    }
                } else if (this.pairingSlot != null && this.lockKeyHeld && slot.getSlotIndex() < 8) {
                    int x1 = ((AccessorGuiContainer)container).getGuiLeft() + this.pairingSlot.field_75223_e;
                    int y1 = ((AccessorGuiContainer)container).getGuiTop() + this.pairingSlot.field_75221_f;
                    if (mouseX <= x1 || mouseX >= x1 + 16 || mouseY <= y1 || mouseY >= y1 + 16) {
                        Gui.func_73734_a((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)-2130706433);
                    }
                }
                if (hoverOverSlot) {
                    float y1;
                    LockedSlot boundLocked = this.getLockedSlot(boundSlot);
                    if (boundLocked == null || boundLocked.locked || boundSlot.getSlotIndex() >= 9 && boundLocked.boundTo != slot.getSlotIndex()) {
                        locked.boundTo = -1;
                        return;
                    }
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.BOUND);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                    GlStateManager.func_179132_a((boolean)false);
                    RenderUtils.drawTexturedRect(boundSlot.field_75223_e, boundSlot.field_75221_f, 16.0f, 16.0f, 0.0f, 1.0f, 0.0f, 1.0f, 9728);
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179147_l();
                    if (boundSlot.func_75211_c() != null) {
                        Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71466_p, boundSlot.func_75211_c(), boundSlot.field_75223_e, boundSlot.field_75221_f, null);
                    }
                    int maxIter = 100;
                    float x1 = slot.field_75223_e + 8;
                    float x2 = boundSlot.field_75223_e + 8;
                    float y2 = boundSlot.field_75221_f + 8;
                    Vector2f vec = new Vector2f(x2 - x1, y2 - y1);
                    vec.normalise(vec);
                    for (y1 = (float)(slot.field_75221_f + 8); x1 > (float)slot.field_75223_e && x1 < (float)(slot.field_75223_e + 16) && y1 > (float)slot.field_75221_f && y1 < (float)(slot.field_75221_f + 16) && maxIter-- >= 50; x1 += vec.x, y1 += vec.y) {
                    }
                    while (x2 > (float)boundSlot.field_75223_e && x2 < (float)(boundSlot.field_75223_e + 16) && y2 > (float)boundSlot.field_75221_f && y2 < (float)(boundSlot.field_75221_f + 16) && maxIter-- >= 0) {
                        x2 -= vec.x;
                        y2 -= vec.y;
                    }
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
                    this.drawLinkArrow((int)x1, (int)y1, (int)x2, (int)y2);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-200.0f);
                }
            } else if (NotEnoughUpdates.INSTANCE.config.slotLocking.enableSlotBinding && slot.getSlotIndex() < 8 && this.pairingSlot != null && this.lockKeyHeld) {
                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                    return;
                }
                GuiContainer container = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
                int scaledWidth = scaledresolution.func_78326_a();
                int scaledHeight = scaledresolution.func_78328_b();
                int mouseX = Mouse.getX() * scaledWidth / Minecraft.func_71410_x().field_71443_c;
                int mouseY = scaledHeight - Mouse.getY() * scaledHeight / Minecraft.func_71410_x().field_71440_d - 1;
                int x1 = ((AccessorGuiContainer)container).getGuiLeft() + this.pairingSlot.field_75223_e;
                int y1 = ((AccessorGuiContainer)container).getGuiTop() + this.pairingSlot.field_75221_f;
                if (mouseX <= x1 || mouseX >= x1 + 16 || mouseY <= y1 || mouseY >= y1 + 16) {
                    Gui.func_73734_a((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)-2130706433);
                }
            }
        }
    }

    public LockedSlot getLockedSlot(Slot slot) {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard() || !NotEnoughUpdates.INSTANCE.config.slotLocking.enableSlotLocking) {
            return null;
        }
        if (slot == null) {
            return null;
        }
        if (slot.field_75224_c != Minecraft.func_71410_x().field_71439_g.field_71071_by) {
            return null;
        }
        int index = slot.getSlotIndex();
        if (index < 0 || index > 39) {
            return null;
        }
        return this.getLockedSlotIndex(index);
    }

    public LockedSlot getLockedSlotIndex(int index) {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard() || !NotEnoughUpdates.INSTANCE.config.slotLocking.enableSlotLocking) {
            return null;
        }
        LockedSlot[] lockedSlots = this.getDataForProfile();
        if (lockedSlots == null) {
            return null;
        }
        return this.getLockedSlot(lockedSlots, index);
    }

    public boolean isSlotLocked(Slot slot) {
        LockedSlot locked = this.getLockedSlot(slot);
        return locked != null && (locked.locked || NotEnoughUpdates.INSTANCE.config.slotLocking.bindingAlsoLocks && locked.boundTo != -1);
    }

    public boolean isSlotIndexLocked(int index) {
        LockedSlot locked = this.getLockedSlotIndex(index);
        return locked != null && (locked.locked || NotEnoughUpdates.INSTANCE.config.slotLocking.bindingAlsoLocks && locked.boundTo != -1);
    }

    private boolean shouldShowBarrier(int slotNumber, IInventory inventory) {
        if (!(inventory instanceof InventoryPlayer)) {
            return false;
        }
        if (slotNumber < 9) {
            return false;
        }
        if (this.pairingSlot != null && (slotNumber == this.pairingSlot.field_75222_d || this.isArmourSlot(slotNumber, this.pairingSlot.field_75222_d))) {
            return false;
        }
        return this.setTopHalfBarrier;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void afterRenderInventory(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!(event.gui instanceof GuiContainer)) {
            return;
        }
        GuiContainer gui = (GuiContainer)event.gui;
        Slot slot = this.getFocusedSlot(gui);
        if (slot == null || !this.shouldShowBarrier(slot.getSlotIndex(), slot.field_75224_c)) {
            return;
        }
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int scaledWidth = scaledresolution.func_78326_a();
        int scaledHeight = scaledresolution.func_78328_b();
        int mouseX = Mouse.getX() * scaledWidth / Minecraft.func_71410_x().field_71443_c;
        int mouseY = scaledHeight - Mouse.getY() * scaledHeight / Minecraft.func_71410_x().field_71440_d - 1;
        Utils.drawHoveringText(Arrays.asList("\u00a7cYou cannot bind slots to anything except the hotbar.", "\u00a7cBinding to a normal inventory slot would require cheats.", "\u00a7cAnd you are not a cheater, are you?", "\u00a7cWe certainly hope you are not."), mouseX, mouseY, scaledWidth, scaledHeight, -1);
    }

    @SubscribeEvent
    public void barrierInventory(ReplaceItemEvent event) {
        if (!this.shouldShowBarrier(event.getSlotNumber(), event.getInventory())) {
            return;
        }
        ItemStack stack = new ItemStack(Blocks.field_180401_cv);
        ItemUtils.getOrCreateTag(stack).func_74757_a("NEUHIDETOOLIP", true);
        event.replaceWith(stack);
    }

    boolean isArmourSlot(int eventSlotNumber, int pairingSlotNumber) {
        if (eventSlotNumber == 39 && pairingSlotNumber == 5) {
            return true;
        }
        if (eventSlotNumber == 38 && pairingSlotNumber == 6) {
            return true;
        }
        if (eventSlotNumber == 37 && pairingSlotNumber == 7) {
            return true;
        }
        return eventSlotNumber == 36 && pairingSlotNumber == 8;
    }

    public void resetSlotLocking() {
        SlotLockProfile slotLockProfile;
        String profileName = SBInfo.getInstance().currentProfile;
        if (profileName == null) {
            profileName = "generic";
        }
        if ((slotLockProfile = this.config.profileData.get(profileName)) != null) {
            slotLockProfile.slotLockData[0] = new SlotLockData();
        }
    }

    public static class SlotLockingConfig {
        public HashMap<String, SlotLockProfile> profileData = new HashMap();
    }

    public static class SlotLockProfile {
        public SlotLockData[] slotLockData = new SlotLockData[1];
    }

    public static class SlotLockData {
        public LockedSlot[] lockedSlots = new LockedSlot[40];
        public LockedSlot[] riftLockedSlots = new LockedSlot[40];
    }

    public static class LockedSlot {
        public boolean locked = false;
        public int boundTo = -1;
    }
}

